/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.chunk.Chunk;
import au.gov.bafcsi.chunk.DecryptionResponse;
import au.gov.bafcsi.chunk.DecryptionStatus;
import au.gov.bafcsi.chunk.EncryptionAlgorithm;
import au.gov.bafcsi.chunk.c8;
import au.gov.bafcsi.clapi.packaging.smime.EnvelopedSMimeInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedOutputStream;

public final class SmimeEnvelopeOpener {
    private PipedOutputStream out;
    private ByteArrayOutputStream smimeOut;
    private EnvelopedSMimeInputStream smimeIn;
    private Thread otherEnd;
    private DecryptionStatus status = null;
    private final Object lock = new Object();

    public void start() throws IOException {
        this.out = new PipedOutputStream();
        this.otherEnd = new Thread(new c8(this));
        this.otherEnd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptionResponse update(Chunk chunk) throws IOException {
        byte[] byArray;
        if (chunk == null) {
            throw new IllegalArgumentException("SmimeEnvelopeOpener.update(Chunk): Chunk is null.");
        }
        byte[] byArray2 = chunk.getData();
        if (byArray2 != null && byArray2.length > 0) {
            this.out.write(byArray2);
        }
        Object object = this.lock;
        synchronized (object) {
            byArray = this.smimeOut.toByteArray();
            this.smimeOut.reset();
        }
        return this.buildResponse(chunk.getId(), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptionResponse finish() throws IOException {
        byte[] byArray;
        this.out.flush();
        this.out.close();
        while (this.otherEnd.isAlive()) {
        }
        Object object = this.lock;
        synchronized (object) {
            byArray = this.smimeOut.toByteArray();
            this.smimeOut.reset();
        }
        return this.buildResponse(-1L, byArray);
    }

    private DecryptionResponse buildResponse(long l10, byte[] byArray) {
        DecryptionResponse decryptionResponse = new DecryptionResponse(new Chunk(l10, byArray));
        if (byArray != null && byArray.length > 0) {
            if (this.status == null) {
                EncryptionAlgorithm encryptionAlgorithm = new EncryptionAlgorithm(this.smimeIn.getEncryptionAlgorithm().getAlgorithmName());
                this.status = new DecryptionStatus(this.smimeIn.getDecryptingCertificate(), encryptionAlgorithm);
            }
            decryptionResponse.setStatus(this.status);
        }
        return decryptionResponse;
    }

    static /* synthetic */ ByteArrayOutputStream access$002(SmimeEnvelopeOpener smimeEnvelopeOpener, ByteArrayOutputStream byteArrayOutputStream) {
        smimeEnvelopeOpener.smimeOut = byteArrayOutputStream;
        return smimeEnvelopeOpener.smimeOut;
    }

    static /* synthetic */ PipedOutputStream access$100(SmimeEnvelopeOpener smimeEnvelopeOpener) {
        return smimeEnvelopeOpener.out;
    }

    static /* synthetic */ EnvelopedSMimeInputStream access$202(SmimeEnvelopeOpener smimeEnvelopeOpener, EnvelopedSMimeInputStream envelopedSMimeInputStream) {
        smimeEnvelopeOpener.smimeIn = envelopedSMimeInputStream;
        return smimeEnvelopeOpener.smimeIn;
    }

    static /* synthetic */ EnvelopedSMimeInputStream access$200(SmimeEnvelopeOpener smimeEnvelopeOpener) {
        return smimeEnvelopeOpener.smimeIn;
    }

    static /* synthetic */ Object access$300(SmimeEnvelopeOpener smimeEnvelopeOpener) {
        return smimeEnvelopeOpener.lock;
    }

    static /* synthetic */ ByteArrayOutputStream access$000(SmimeEnvelopeOpener smimeEnvelopeOpener) {
        return smimeEnvelopeOpener.smimeOut;
    }
}

