/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.certs.CertificationRequestInfo;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;

public final class CertificationRequest
extends az {
    public static final String certificationRequestInfo = "certificationRequestInfo";
    public static final String signatureAlgorithm = "signatureAlgorithm";
    public static final String signature = "signature";

    public CertificationRequest() {
        this.a((ax)new CertificationRequestInfo(), certificationRequestInfo);
        this.a((ax)new AlgorithmIdentifier(), signatureAlgorithm);
        this.a((ax)new b0(), signature);
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, PrivateKey privateKey) throws CertificateException {
        if (certificationRequestInfo == null) {
            throw new IllegalArgumentException("CertificationRequest(CertificationRequestInfo, PrivateKey) - The supplied CertificationRequestInfo is null.");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("CertificationRequest(CertificationRequestInfo, PrivateKey) - The supplied PrivateKey is null.");
        }
        this.a((ax)certificationRequestInfo, certificationRequestInfo);
        String string = privateKey.getAlgorithm();
        if (string.equals("RSA")) {
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.sha1WithRSAEncryption, new dn()), signatureAlgorithm);
        } else if (string.equals("DSA")) {
            this.a((ax)new AlgorithmIdentifier(Oids.dsaWithSHA1), signatureAlgorithm);
        }
        try {
            Signature signature = q.d("SHA1with" + privateKey.getAlgorithm());
            signature.initSign(privateKey);
            signature.update(certificationRequestInfo.g().getBytes());
            this.a((ax)new b0(new ByteArray(signature.sign()), 0), signature);
        }
        catch (Exception exception) {
            throw new CertificateException("CertificationRequest(CertificationRequestInfo, PrivateKey) - " + exception.toString());
        }
    }

    public CertificationRequestInfo getRequestInfo() {
        return (CertificationRequestInfo)this.a(certificationRequestInfo);
    }

    public Oid getAlgorithmIdentifier() {
        return ((AlgorithmIdentifier)this.a(signatureAlgorithm)).getAlgorithmOID();
    }

    public ByteArray getSignature() {
        return ((b0)this.a((String)signature)).a;
    }

    public boolean verify() throws CertificateException {
        try {
            CertificationRequestInfo certificationRequestInfo = this.getRequestInfo();
            PublicKey publicKey = certificationRequestInfo.getPublicKeyInfo().getPublicKey();
            Signature signature = q.d(Oids.getJCAMapping(this.getAlgorithmIdentifier()));
            signature.initVerify(publicKey);
            signature.update(certificationRequestInfo.g().getBytes());
            return signature.verify(this.getSignature().getBytes());
        }
        catch (Exception exception) {
            throw new CertificateException("CertificationRequest.verify() - " + exception.getMessage());
        }
    }
}

