/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.a4;
import au.gov.bafcsi.clapi.asn1.av;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.bc;
import au.gov.bafcsi.clapi.asn1.be;
import au.gov.bafcsi.clapi.asn1.bj;
import au.gov.bafcsi.clapi.asn1.bl;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.coders.bb;
import au.gov.bafcsi.clapi.certs.ek;
import au.gov.bafcsi.clapi.certs.extensions.AuthorityKeyIdentifier;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.em;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;

public final class CsiX509CRL
extends X509CRL
implements av {
    private final az tree = new az();

    public CsiX509CRL() {
        this.tree.a((ax)new ek(), "tbsCertList");
        this.tree.a((ax)new AlgorithmIdentifier(), "signatureAlgorithm");
        this.tree.a((ax)new b0(), "signature");
    }

    public CsiX509CRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new IllegalArgumentException("CsiX509CRL(InputStream) - The supplied InputStream is null.");
        }
        this.tree.a((ax)new ek(), "tbsCertList");
        this.tree.a((ax)new AlgorithmIdentifier(), "signatureAlgorithm");
        this.tree.a((ax)new b0(), "signature");
        try {
            this.decode(inputStream);
            this.decodeFully();
        }
        catch (IOException iOException) {
            throw new CRLException("CsiX509CRL(InputStream) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CRLException("CsiX509CRL(InputStream) - " + coderException.getMessage());
        }
    }

    public a4 getTag() {
        return this.tree.getTag();
    }

    public bc encode(OutputStream outputStream) throws IOException, CoderException {
        return this.tree.encode(outputStream);
    }

    public bj decode(InputStream inputStream) throws IOException, CoderException {
        return this.tree.decode(inputStream);
    }

    public int getUniqueID() {
        return this.tree.getUniqueID();
    }

    public void accept(be be2) throws IOException, CoderException {
        if (be2 == null) {
            throw new IllegalArgumentException("CsiX509CRL(ASN1Visitor) - The supplied ASN1Visitor is null.");
        }
        be2.a(this);
    }

    public ax getPrimitive() {
        return this.tree.getPrimitive();
    }

    public ax getHasATaggedInterface() {
        return this.tree;
    }

    public boolean getImplicitlyWrapped() {
        return this.tree.getImplicitlyWrapped();
    }

    public void setImplicitlyWrapped(boolean bl2) {
        this.tree.setImplicitlyWrapped(bl2);
    }

    public void decodeFully() throws IOException, CoderException {
        this.tree.decodeFully();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        CsiX509CRL csiX509CRL = (CsiX509CRL)object;
        try {
            return em.a(this.getEncoded(), csiX509CRL.getEncoded());
        }
        catch (CRLException cRLException) {
            r.a(w.f, "CsiX509CRL equals()", cRLException);
            return false;
        }
    }

    public int hashCode() {
        try {
            return new ByteArray(this.getEncoded()).hashCode();
        }
        catch (CRLException cRLException) {
            r.a(w.f, "CsiX509CRL hashCode()", cRLException);
            return 0;
        }
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bb bb2 = new bb(byteArrayOutputStream);
        try {
            this.tree.encode(bb2);
            bb2.close();
        }
        catch (Exception exception) {
            throw new CRLException("CsiX509CRL.getEncoded() - " + exception.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Principal getIssuerDN() {
        return ((ek)this.tree.a("tbsCertList")).h();
    }

    public Date getNextUpdate() {
        return ((ek)this.tree.a("tbsCertList")).i();
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("CsiX509CRL.getRevokedCertificate(BigInteger) - The supplied BigInteger is null.");
        }
        ek ek2 = (ek)this.tree.a("tbsCertList");
        return ek2.a(bigInteger);
    }

    public Set getRevokedCertificates() {
        ek ek2 = (ek)this.tree.a("tbsCertList");
        return ek2.l();
    }

    public String getSigAlgName() {
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
        return algorithmIdentifier.getAlgorithmName();
    }

    public String getSigAlgOID() {
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
        return algorithmIdentifier.getAlgorithmOID().getValue();
    }

    public byte[] getSigAlgParams() {
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
        try {
            AlgorithmParameters algorithmParameters = algorithmIdentifier.getAlgorithmParameters();
            return algorithmParameters == null ? null : algorithmParameters.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            r.a(w.f, "CsiX509CRL getSigAlgParams()", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            r.a(w.f, "CsiX509CRL getSigAlgParams()", iOException);
        }
        catch (CoderException coderException) {
            r.a(w.f, "CsiX509CRL getSigAlgParams()", coderException);
        }
        return null;
    }

    public byte[] getSignature() {
        b0 b02 = (b0)this.tree.a("signature");
        return b02.a.getBytes();
    }

    public byte[] getTBSCertList() {
        ek ek2 = (ek)this.tree.a("tbsCertList");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bb bb2 = new bb(byteArrayOutputStream);
        try {
            ek2.encode(bb2);
            bb2.close();
        }
        catch (IOException iOException) {
            throw new bl("CsiX509CRL.getTBSCertList()", iOException);
        }
        catch (CoderException coderException) {
            throw new bl("CsiX509CRL.getTBSCertList()", coderException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Date getThisUpdate() {
        return ((ek)this.tree.a("tbsCertList")).j();
    }

    public int getVersion() {
        return ((ek)this.tree.a("tbsCertList")).k();
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (publicKey == null) {
            throw new IllegalArgumentException("CsiX509CRL.verify(PublicKey) - The supplied PublicKey is null.");
        }
        this.verify(publicKey, "CSIPROVIDER");
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        ByteArray byteArray;
        if (publicKey == null) {
            throw new IllegalArgumentException("CsiX509CRL.verify(PublicKey, String) - The supplied PublicKey is null.");
        }
        ek ek2 = (ek)this.tree.a("tbsCertList");
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
        String string2 = Oids.getJCAMapping(algorithmIdentifier.getAlgorithmOID());
        if (string2 == null) {
            throw new CRLException("CsiX509CRL.verify(PublicKey, String) - The Signature Algorithm '" + algorithmIdentifier.getAlgorithmOID() + "' is not supported.");
        }
        Signature signature = string == null ? Signature.getInstance(string2) : (string.equalsIgnoreCase("CSIPROVIDER") ? Signature.getInstance(string2, q.a()) : Signature.getInstance(string2, string));
        try {
            byteArray = ek2.g();
        }
        catch (IOException iOException) {
            throw new CRLException("CsiX509CRL.verify(PublicKey, String) - " + iOException.toString());
        }
        catch (CoderException coderException) {
            throw new CRLException("CsiX509CRL.verify(PublicKey, String) - " + coderException.toString());
        }
        signature.initVerify(publicKey);
        signature.update(byteArray.getBytes(), 0, byteArray.length());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CsiX509CRL.verify(PublicKey, String) - The signature is invalid.");
        }
    }

    public String toString() {
        return "This is a CRL.";
    }

    public boolean isRevoked(Certificate certificate) {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        return this.getRevokedCertificate(x509Certificate.getSerialNumber()) != null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        ek ek2 = (ek)this.tree.a("tbsCertList");
        return ek2.m();
    }

    public Set getNonCriticalExtensionOIDs() {
        ek ek2 = (ek)this.tree.a("tbsCertList");
        return ek2.n();
    }

    public byte[] getExtensionValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("CsiX509CRL.getExtensionValue(String) - The supplied String is null.");
        }
        ek ek2 = (ek)this.tree.a("tbsCertList");
        return ek2.b(string);
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return p.a(this);
    }
}

