/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.a4;
import au.gov.bafcsi.clapi.asn1.av;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.bc;
import au.gov.bafcsi.clapi.asn1.be;
import au.gov.bafcsi.clapi.asn1.bj;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.coders.bb;
import au.gov.bafcsi.clapi.certs.a6;
import au.gov.bafcsi.clapi.certs.extensions.AuthorityKeyIdentifier;
import au.gov.bafcsi.clapi.certs.extensions.SubjectKeyIdentifier;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.ExtensionOid;
import au.gov.bafcsi.clapi.common.InvalidOidException;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.q;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;

public final class CsiX509Certificate
extends X509Certificate
implements av,
Serializable {
    private byte[] m_encoded = null;
    private byte[] m_signature = null;
    private a6 m_tbsCertificate = null;
    private final az tree = new az();

    public CsiX509Certificate() {
        this.tree.a((ax)new a6(), "tbsCertificate");
        this.tree.a((ax)new AlgorithmIdentifier(), "signatureAlgorithm");
        this.tree.a((ax)new b0(), "signature");
    }

    public CsiX509Certificate(InputStream inputStream) throws CertificateEncodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("CsiX509Certificate(InputStream) - The supplied InputStream is null.");
        }
        this.tree.a((ax)new a6(), "tbsCertificate");
        this.tree.a((ax)new AlgorithmIdentifier(), "signatureAlgorithm");
        this.tree.a((ax)new b0(), "signature");
        try {
            this.decode(inputStream);
            this.decodeFully();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("CsiX509Certificate(InputStream) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateEncodingException("CsiX509Certificate(InputStream) - " + coderException.getMessage());
        }
    }

    public CsiX509Certificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("CsiX509Certificate(X509Certificate) - The supplied X509Certificate is null.");
        }
        this.tree.a((ax)new a6(), "tbsCertificate");
        this.tree.a((ax)new AlgorithmIdentifier(), "signatureAlgorithm");
        this.tree.a((ax)new b0(), "signature");
        try {
            this.tree.a(new ByteArray(x509Certificate.getEncoded()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("CsiX509Certificate(X509Certificate) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateEncodingException("CsiX509Certificate(X509Certificate) - " + coderException.getMessage());
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.m_encoded == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bb bb2 = new bb(byteArrayOutputStream);
            try {
                this.accept(bb2);
                bb2.close();
            }
            catch (Exception exception) {
                throw new CertificateEncodingException("CsiX509Certificate.getEncoded() - " + exception.getMessage());
            }
            this.m_encoded = byteArrayOutputStream.toByteArray();
        }
        return this.m_encoded;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.getTBSCertifiateObject().h();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.getTBSCertifiateObject().a(date);
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "CSIPROVIDER");
    }

    public Set getCriticalExtensionOIDs() {
        return this.getTBSCertifiateObject().i();
    }

    public int getVersion() {
        return this.getTBSCertifiateObject().j() + 1;
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        ByteArray byteArray;
        if (publicKey == null) {
            throw new IllegalArgumentException("CsiX509Certificate.verify(PublicKey, String) - The supplied Key is null.");
        }
        AlgorithmIdentifier algorithmIdentifier = this.getSignatureAlgorithm();
        a6 a62 = this.getTBSCertifiateObject();
        if (!a62.v().getAlgorithmOID().equals(algorithmIdentifier.getAlgorithmOID())) {
            throw new CertificateException("CsiX509Certificate.verify(PublicKey, String) - The Signature Algorithm inside the TbsCertificate is not the same as the Signature Algorithm used to sign this X509Certificate.");
        }
        String string2 = Oids.getJCAMapping(algorithmIdentifier.getAlgorithmOID());
        if (string2 == null) {
            throw new CertificateException("CsiX509Certificate.verify(PublicKey, String) - The Signature Algorithm '" + algorithmIdentifier.getAlgorithmOID() + "' is not supported.");
        }
        Signature signature = string == null ? Signature.getInstance(string2) : (string.equalsIgnoreCase("CSIPROVIDER") ? Signature.getInstance(string2, q.a()) : Signature.getInstance(string2, string));
        try {
            byteArray = a62.g();
        }
        catch (IOException iOException) {
            throw new CertificateException("CsiX509Certificate.verify(PublicKey, String) - " + iOException.toString());
        }
        catch (CoderException coderException) {
            throw new CertificateException("CsiX509Certificate.verify(PublicKey, String) - " + coderException.toString());
        }
        signature.initVerify(publicKey);
        signature.update(byteArray.getBytes(), 0, byteArray.length());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CsiX509Certificate.verify(PublicKey, String) - The signature is invalid.");
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getTBSCertifiateObject().k();
    }

    public BigInteger getSerialNumber() {
        return this.getTBSCertifiateObject().l();
    }

    public String toString() {
        return this.getTBSCertifiateObject().toString();
    }

    public byte[] getExtensionValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("CsiX509Certificate.getExtensionValue(String) - The supplied String is null.");
        }
        try {
            return this.getTBSCertifiateObject().a(new ExtensionOid(string));
        }
        catch (InvalidOidException invalidOidException) {
            return null;
        }
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return p.a(this);
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return p.a((X509Extension)this);
    }

    public Principal getIssuerDN() {
        return this.getTBSCertifiateObject().m();
    }

    public PublicKey getPublicKey() {
        try {
            return this.getTBSCertifiateObject().n();
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("CsiX509Certificate.getPublicKey() - " + certificateException.toString());
        }
    }

    public Principal getSubjectDN() {
        return this.getTBSCertifiateObject().o();
    }

    public Date getNotBefore() {
        return this.getTBSCertifiateObject().p();
    }

    public Date getNotAfter() {
        return this.getTBSCertifiateObject().q();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bb bb2 = new bb(byteArrayOutputStream);
        try {
            this.getTBSCertifiateObject().accept(bb2);
            bb2.flush();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("CsiX509Certifciate.getTBSCertificate() - " + exception.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignature() {
        if (this.m_signature == null) {
            b0 b02 = (b0)this.tree.a("signature");
            this.m_signature = b02.a.getDefensiveBytes();
        }
        return this.m_signature;
    }

    public String getSigAlgName() {
        try {
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
            return algorithmIdentifier.getAlgorithmName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSigAlgOID() {
        try {
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
            return algorithmIdentifier.getAlgorithmOID().getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getSigAlgParams() {
        try {
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
            return algorithmIdentifier.getAlgorithmParameters().getEncoded();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean[] getIssuerUniqueID() {
        return this.getTBSCertifiateObject().r();
    }

    public boolean[] getSubjectUniqueID() {
        return this.getTBSCertifiateObject().s();
    }

    public boolean[] getKeyUsage() {
        return this.getTBSCertifiateObject().t();
    }

    public int getBasicConstraints() {
        return this.getTBSCertifiateObject().u();
    }

    public a4 getTag() {
        return this.tree.getTag();
    }

    public ax getPrimitive() {
        return this.tree.getPrimitive();
    }

    public ax getHasATaggedInterface() {
        return this.tree;
    }

    public a6 getTBSCertifiateObject() {
        if (this.m_tbsCertificate == null) {
            this.m_tbsCertificate = (a6)this.tree.a("tbsCertificate");
        }
        return this.m_tbsCertificate;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return (AlgorithmIdentifier)this.tree.a("signatureAlgorithm");
    }

    public void decodeFully() throws IOException, CoderException {
        this.tree.decodeFully();
    }

    public void setImplicitlyWrapped(boolean bl2) {
        this.tree.setImplicitlyWrapped(bl2);
    }

    public boolean getImplicitlyWrapped() {
        return this.tree.getImplicitlyWrapped();
    }

    public void accept(be be2) throws IOException, CoderException {
        if (be2 == null) {
            throw new IllegalArgumentException("CsiX509Certificate(ASN1Visitor) - The supplied ASN1Visitor is null.");
        }
        be2.a(this);
    }

    public int getUniqueID() {
        return this.tree.getUniqueID();
    }

    public bc encode(OutputStream outputStream) throws IOException, CoderException {
        return this.tree.encode(outputStream);
    }

    public bj decode(InputStream inputStream) throws IOException, CoderException {
        this.m_encoded = null;
        this.m_signature = null;
        this.m_tbsCertificate = null;
        return this.tree.decode(inputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.write(this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException("Unable to serialize CsiX509Certificate due to CertificateEncodingException: " + certificateEncodingException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n10;
        byte[] byArray = new byte[1024];
        ByteArray byteArray = new ByteArray();
        while ((n10 = objectInputStream.read(byArray)) != -1) {
            byteArray.append(byArray, 0, n10);
        }
        this.m_encoded = byteArray.getBytes();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return new CsiX509Certificate(new ByteArrayInputStream(this.m_encoded));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new InvalidObjectException("Unable to deserialize CsiX509Certificate due to CertificateEncodingException: " + certificateEncodingException.getMessage());
        }
    }
}

