/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.CsiRsaPublicKey;
import au.gov.bafcsi.clapi.crypto.DsaParameters;
import au.gov.bafcsi.clapi.crypto.Pkcs1EncodedRsaPublicKey;
import au.gov.bafcsi.clapi.crypto.eh;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class SubjectPublicKeyInfo
extends az {
    public SubjectPublicKeyInfo() {
        this.a((ax)new AlgorithmIdentifier(), "algorithm");
        this.a((ax)new b0(), "subjectPublicKey");
    }

    public SubjectPublicKeyInfo(PublicKey publicKey) throws IOException, CoderException {
        if (publicKey == null) {
            throw new IllegalArgumentException("SubjectPublicKeyInfo(PublicKey) - PublicKey is null.");
        }
        if (!publicKey.getAlgorithm().equals("RSA") && !publicKey.getAlgorithm().equals("DSA")) {
            throw new IllegalArgumentException("SubjectPublicKeyInfo(PublicKey) - PublicKey must be either RSA or DSA.");
        }
        if (publicKey.getAlgorithm().equals("RSA")) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.rsaEncryption, new dn()), "algorithm");
            this.a((ax)new b0(new Pkcs1EncodedRsaPublicKey(rSAPublicKey).g(), 0), "subjectPublicKey");
        } else if (publicKey.getAlgorithm().equals("DSA")) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            DsaParameters dsaParameters = dSAParams instanceof DsaParameters ? (DsaParameters)dSAParams : new DsaParameters(dSAParams);
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.dsaANSI, dsaParameters), "algorithm");
            this.a((ax)new b0(new a7(dSAPublicKey.getY()).g(), 0), "subjectPublicKey");
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return (AlgorithmIdentifier)this.a("algorithm");
    }

    public ByteArray getSubjectPublicKey() {
        return ((b0)this.a((String)"subjectPublicKey")).a;
    }

    public PublicKey getPublicKey() throws UnsupportedAlgorithmException, NoSuchAlgorithmException, IOException, CoderException, InvalidParameterSpecException {
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier();
        Oid oid = algorithmIdentifier.getAlgorithmOID();
        if (oid.equals(Oids.rsaEncryption) || oid.equals(Oids.rsa)) {
            Pkcs1EncodedRsaPublicKey pkcs1EncodedRsaPublicKey = new Pkcs1EncodedRsaPublicKey();
            pkcs1EncodedRsaPublicKey.a(((b0)this.a((String)"subjectPublicKey")).a);
            return new CsiRsaPublicKey(pkcs1EncodedRsaPublicKey);
        }
        if (oid.equals(Oids.dsa) || oid.equals(Oids.dsaANSI)) {
            AlgorithmParameters algorithmParameters = algorithmIdentifier.getAlgorithmParameters();
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            a7 a72 = new a7();
            a72.a(((b0)this.a((String)"subjectPublicKey")).a);
            return new eh(new DsaParameters(dSAParameterSpec), a72.a);
        }
        if (oid.equals(Oids.ecdsa)) {
            throw new UnsupportedAlgorithmException("SubjectPublicKeyInfo.getPublicKey() - ECDSA is not supported.");
        }
        String string = Oids.getJCAMapping(oid);
        if (string != null) {
            throw new UnsupportedAlgorithmException("SubjectPublicKeyInfo.getPublicKey() - '" + string + "' not supported.");
        }
        throw new UnsupportedAlgorithmException("SubjectPublicKeyInfo.getPublicKey() - '" + oid.toString() + "' not supported.");
    }
}

