/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.CsiX509CRL;
import au.gov.bafcsi.clapi.certs.CsiX509Certificate;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.packaging.cms.full.ct;
import au.gov.bafcsi.common.utils.base64.Base64InputStream;
import au.gov.bafcsi.common.utils.k8;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class en
extends CertificateFactorySpi {
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(10240);
            boolean bl2 = false;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.equals("-----BEGIN CERTIFICATE-----")) {
                    bl2 = true;
                    break;
                }
                string = bufferedReader.readLine();
            }
            inputStream.reset();
            InputStream inputStream2 = inputStream;
            if (bl2) {
                inputStream2 = new Base64InputStream(new k8(inputStream, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"));
            }
            return new CsiX509Certificate(inputStream2);
        }
        catch (IOException iOException) {
            throw new CertificateException("CsiX509CertificateFactory.engineGenerateCertificate(InputStream) - " + iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream, 10240);
        }
        try {
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            try {
                inputStream.mark(10240);
                arrayList.add(this.engineGenerateCertificate(inputStream));
            }
            catch (CertificateException certificateException) {
                inputStream.reset();
            }
            if (arrayList.isEmpty()) {
                ct ct2 = new ct();
                ct2.decode(inputStream);
                CertificateCollection certificateCollection = ct2.k();
                Iterator iterator = certificateCollection.iterator();
                while (iterator.hasNext()) {
                    arrayList.add((Certificate)iterator.next());
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new CertificateException("CsiX509CertificateFactory.engineGenerateCertificates(InputStream) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("CsiX509CertificateFactory.engineGenerateCertificates(InputStream) - " + coderException.getMessage());
        }
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        return new CsiX509CRL(inputStream);
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            Collection<CRL> collection = null;
            try {
                inputStream.mark(10240);
                collection = new ArrayList<CRL>();
                collection.add(this.engineGenerateCRL(inputStream));
            }
            catch (CRLException cRLException) {
                inputStream.reset();
            }
            if (collection == null) {
                ct ct2 = new ct();
                ct2.decode(inputStream);
                collection = ct2.l();
            }
            return collection;
        }
        catch (IOException iOException) {
            throw new CRLException("CsiX509CertificateFactory.engineGenerateCRL(InputStream) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CRLException("CsiX509CertificateFactory.engineGenerateCRL(InputStream) - " + coderException.getMessage());
        }
    }
}

