/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.a9;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b1;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.GeneralNames;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;

public final class AuthorityKeyIdentifier
extends az {
    public AuthorityKeyIdentifier(ByteArray byteArray) throws CertificateException {
        if (byteArray == null) {
            throw new IllegalArgumentException("AuthorityKeyIdentifier(ByteArray) - The supplied ByteArray is null.");
        }
        this.a((ax)new bm(new b1(new cf(), 0)), "keyIdentifier");
        this.a((ax)new bm(new b1(new GeneralNames(), 1)), "authorityCertIssuer");
        this.a((ax)new bm(new b1(new a7(), 2)), "authorityCertSerialNumber");
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("AuthorityKeyIdentifier(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("AuthorityKeyIdentifier(ByteArray) - " + coderException.getMessage());
        }
    }

    public ByteArray getKeyIdentifier() {
        bm bm2 = (bm)this.a("keyIdentifier");
        if (bm2.a) {
            return ((cf)bm2.getPrimitive()).j();
        }
        return null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        bm bm2 = (bm)this.a("authorityCertIssuer");
        if (bm2.a) {
            return (GeneralNames)bm2.getPrimitive();
        }
        return null;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        bm bm2 = (bm)this.a("authorityCertSerialNumber");
        if (bm2.a) {
            return ((a7)bm2.getPrimitive()).a;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AuthorityKeyIdentifier - \r\n");
        bm bm2 = (bm)this.a("keyIdentifier");
        if (bm2.a) {
            stringBuffer.append("  keyIdentifier = " + this.getKeyIdentifier().toHexString());
            stringBuffer.append("\r\n");
        }
        bm2 = (bm)this.a("authorityCertIssuer");
        if (bm2.a) {
            b1 b12 = (b1)((a9)bm2).a;
            GeneralNames generalNames = (GeneralNames)((a9)b12).a;
            stringBuffer.append("  authorityCertIssuer = " + generalNames.toString());
            stringBuffer.append("\r\n");
        }
        bm2 = (bm)this.a("authorityCertSerialNumber");
        if (bm2.a) {
            stringBuffer.append("  authorityCertSerialNumber = " + bm2.getPrimitive().toString());
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public boolean compare(AuthorityKeyIdentifier authorityKeyIdentifier) {
        if (this.getKeyIdentifier() != null && authorityKeyIdentifier.getKeyIdentifier() != null) {
            return this.getKeyIdentifier().equals(authorityKeyIdentifier.getKeyIdentifier());
        }
        if (this.getAuthorityCertSerialNumber() != null && authorityKeyIdentifier.getAuthorityCertSerialNumber() != null && this.getAuthorityCertIssuer() != null && authorityKeyIdentifier.getAuthorityCertIssuer() != null) {
            ByteArray byteArray;
            ByteArray byteArray2;
            try {
                byteArray2 = this.getAuthorityCertIssuer().g();
                byteArray = authorityKeyIdentifier.getAuthorityCertIssuer().g();
            }
            catch (Exception exception) {
                r.a(w.i, "Could not extract the DER encoded bytes from the General Name in an authority key identifier when comparing against another key identifier.", exception);
                return false;
            }
            return this.getAuthorityCertSerialNumber().equals(authorityKeyIdentifier.getAuthorityCertSerialNumber()) && byteArray2.equals(byteArray);
        }
        return false;
    }
}

