/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.common;

import au.gov.bafcsi.clapi.common.InvalidOidException;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.crypto.provider.CsiProvider;
import au.gov.bafcsi.common.utils.q;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestOid
extends Oid {
    private int m_Length;
    private String m_JCEName;
    private static final int MD5DIGESTLENGTH = 16;
    private static final int MD2DIGESTLENGTH = 16;
    private static final int SHA1DIGESTLENGTH = 20;
    private static final int SHA256DIGESTLENGTH = 32;
    private static final int SHA384DIGESTLENGTH = 48;
    private static final int SHA512DIGESTLENGTH = 64;
    private static final int NULLDIGESTLENGTH = 0;
    public static final DigestOid MD5 = new DigestOid("1.2.840.113549.2.5", 16, "MD5");
    public static final DigestOid MD2 = new DigestOid("1.2.840.113549.2.2", 16, "MD2");
    public static final DigestOid SHA256 = new DigestOid("2.16.840.1.101.3.4.2.1", 32, "SHA-256");
    public static final DigestOid SHA1 = new DigestOid("1.3.14.3.2.26", 20, "SHA-1");
    public static final DigestOid SHA384 = new DigestOid("2.16.840.1.101.3.4.2.2");
    public static final DigestOid SHA512 = new DigestOid("2.16.840.1.101.3.4.2.3");
    public static final DigestOid NULL_DIGEST = new DigestOid("0.0.0.0.0.0.0", 0, "Null");

    public DigestOid(String string) {
        super(string);
        if (!DigestOid.isValid(string)) {
            throw new InvalidOidException("DigestOid(String) - The supplied String does not represent a valid Digest Oid.");
        }
        this.m_Length = this.getLength(string);
        if (this.m_Length == -1 || (this.m_JCEName = this.getJCEName(string)).equalsIgnoreCase("")) {
            throw new InvalidOidException("Algorithm not supported by CSI Provider.");
        }
    }

    private DigestOid(String string, int n10, String string2) {
        super(string);
        if (!DigestOid.isValid(string)) {
            throw new InvalidOidException("DigestOid(String) - The supplied String does not represent a valid Digest Oid.");
        }
        this.m_JCEName = string2;
        this.m_Length = n10;
    }

    public DigestOid(Oid oid) {
        super(oid.getValue());
        if (!DigestOid.isValid(oid.getValue())) {
            throw new InvalidOidException("DigestOid(String) - The supplied String does not represent a valid Digest Oid.");
        }
        this.m_Length = this.getLength(oid);
        if (this.m_Length == -1 || (this.m_JCEName = this.getJCEName(oid)).equalsIgnoreCase("")) {
            throw new InvalidOidException("Algorithm not supported by CSI Provider ");
        }
    }

    public static boolean isValid(String string) {
        return string.equals("1.3.14.3.2.26") || string.equals("1.2.840.113549.2.2") || string.equals("1.2.840.113549.2.5") || string.equals("2.16.840.1.101.3.4.2.1") || string.equals("2.16.840.1.101.3.4.2.2") || string.equals("2.16.840.1.101.3.4.2.3") || string.equals("0.0.0.0.0.0.0");
    }

    public MessageDigest getDigester() throws GeneralSecurityException {
        if (this.getJCEName().equalsIgnoreCase(MD2.getJCEName()) || this.getJCEName().equalsIgnoreCase(SHA384.getJCEName()) || this.getJCEName().equalsIgnoreCase(SHA512.getJCEName())) {
            throw new GeneralSecurityException(this.getJCEName() + " is not a supported algorithm");
        }
        try {
            return MessageDigest.getInstance(this.m_JCEName, q.a());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new GeneralSecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    public int getDigestLength() {
        return this.m_Length;
    }

    public static DigestOid getInstance(Oid oid) {
        if (oid.equals("1.3.14.3.2.26")) {
            return SHA1;
        }
        if (oid.equals("1.2.840.113549.2.5")) {
            return MD5;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.1")) {
            return SHA256;
        }
        if (oid.equals("0.0.0.0.0.0.0")) {
            return NULL_DIGEST;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.2")) {
            return SHA384;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.3")) {
            return SHA512;
        }
        if (oid.equals("1.2.840.113549.2.2")) {
            return MD2;
        }
        return null;
    }

    private String getJCEName() {
        if (this.m_JCEName != null) {
            return this.m_JCEName;
        }
        return "";
    }

    private String getJCEName(String string) {
        if (string.equals("1.3.14.3.2.26")) {
            return "SHA1";
        }
        if (string.equals("2.16.840.1.101.3.4.2.1")) {
            return "SHA256";
        }
        if (string.equals("1.2.840.113549.2.2")) {
            return "MD2";
        }
        if (string.equals("1.2.840.113549.2.5")) {
            return "MD5";
        }
        if (string.equals("0.0.0.0.0.0.0")) {
            return "Null";
        }
        if (string.equals("2.16.840.1.101.3.4.2.2")) {
            return "SHA384";
        }
        if (string.equals("2.16.840.1.101.3.4.2.3")) {
            return "SHA512";
        }
        return "";
    }

    private int getLength(String string) {
        if (string.equals("1.3.14.3.2.26")) {
            return 20;
        }
        if (string.equals("2.16.840.1.101.3.4.2.1")) {
            return 32;
        }
        if (string.equals("1.2.840.113549.2.5")) {
            return 16;
        }
        if (string.equals("1.2.840.113549.2.2")) {
            return 16;
        }
        if (string.equals("0.0.0.0.0.0.0")) {
            return 0;
        }
        if (string.equals("2.16.840.1.101.3.4.2.2")) {
            return 48;
        }
        if (string.equals("2.16.840.1.101.3.4.2.3")) {
            return 64;
        }
        return -1;
    }

    private String getJCEName(Oid oid) {
        if (oid.equals("1.3.14.3.2.26")) {
            return "SHA1";
        }
        if (oid.equals("1.2.840.113549.2.5")) {
            return "MD5";
        }
        if (oid.equals("2.16.840.1.101.3.4.2.1")) {
            return "SHA256";
        }
        if (oid.equals("2.16.840.1.101.3.4.2.2")) {
            return "SHA384";
        }
        if (oid.equals("2.16.840.1.101.3.4.2.3")) {
            return "SHA512";
        }
        if (oid.equals("0.0.0.0.0.0.0")) {
            return "Null";
        }
        if (oid.equals("1.2.840.113549.2.2")) {
            return "MD2";
        }
        return "";
    }

    private int getLength(Oid oid) {
        if (oid.equals("1.3.14.3.2.26")) {
            return 20;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.1")) {
            return 32;
        }
        if (oid.equals("1.2.840.113549.2.5")) {
            return 16;
        }
        if (oid.equals("1.2.840.113549.2.2")) {
            return 16;
        }
        if (oid.equals("0.0.0.0.0.0.0")) {
            return 0;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.2")) {
            return 48;
        }
        if (oid.equals("2.16.840.1.101.3.4.2.3")) {
            return 64;
        }
        return -1;
    }

    static {
        CsiProvider.addCsiProvider();
    }
}

