/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.common;

import java.util.StringTokenizer;

public class Oid {
    protected String oid;

    public Oid(String string) {
        if (!Oid.validateOID(string)) {
            throw new IllegalArgumentException("Oid(String) - The supplied parameter is not a valid Oid.");
        }
        this.oid = string;
    }

    public String getValue() {
        return this.oid;
    }

    public int[] toIntArray() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n10 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n10++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public boolean isASubOrdinateOf(Oid oid) {
        return this.oid.startsWith(oid.getValue());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Oid) {
            return this.oid.equals(((Oid)object).getValue());
        }
        if (object instanceof String) {
            return this.oid.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public String toString() {
        return this.oid;
    }

    public static boolean validateOID(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        try {
            int n10 = Integer.parseInt(stringTokenizer.nextToken());
            int n11 = Integer.parseInt(stringTokenizer.nextToken());
            if (n10 < 0 || n10 > 2 || n10 != 2 && (n11 < 0 || n11 > 39) || n10 == 2 && (n11 < 0 || n11 > 47)) {
                return false;
            }
            while (stringTokenizer.hasMoreTokens()) {
                Integer.parseInt(stringTokenizer.nextToken());
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

