/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.common;

import au.gov.bafcsi.clapi.common.CsiAttributeOid;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.ExtendedKeyUsageOid;
import au.gov.bafcsi.clapi.common.ExtensionOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Pkcs12AlgorithmOid;
import au.gov.bafcsi.clapi.common.Pkcs12BagOid;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.common.Pkcs9AttributeOid;
import au.gov.bafcsi.clapi.common.PolicyQualifierOid;
import au.gov.bafcsi.clapi.common.PublicKeyEncryptionOid;
import au.gov.bafcsi.clapi.common.SignatureOid;
import au.gov.bafcsi.clapi.common.SymmetricCipherOid;
import au.gov.bafcsi.clapi.common.X500AttributeOid;
import au.gov.bafcsi.clapi.common.X509ExtensionOid;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.util.HashMap;

public class Oids {
    public static final Oid emptyOID = new Oid("0.0");
    public static final Oid rsaDSI = new Oid("1.2.840.113549");
    public static final Oid pkcs = new Oid("1.2.840.113549.1");
    public static final Oid pkcs1 = new Oid("1.2.840.113549.1.1");
    public static final PublicKeyEncryptionOid rsaEncryption = PublicKeyEncryptionOid.RSAENCRYPTION;
    public static final SignatureOid md2WithRSAEncryption = SignatureOid.MD2_WITH_RSA;
    public static final SignatureOid md5WithRSAEncryption = SignatureOid.MD5_WITH_RSA;
    public static final SignatureOid sha1WithRSAEncryption = SignatureOid.SHA1_WITH_RSA;
    public static final PublicKeyEncryptionOid rsaEncryptionOAEP = PublicKeyEncryptionOid.RSAENCRYPTION_OAEP;
    public static final SignatureOid sha256WithRSAEncryption = SignatureOid.SHA256_WITH_RSA;
    public static final SignatureOid sha384WithRSAEncryption = SignatureOid.SHA384_WITH_RSA;
    public static final SignatureOid sha512WithRSAEncryption = SignatureOid.SHA512_WITH_RSA;
    public static final Oid pkcs2 = new Oid("1.2.840.113549.2");
    public static final DigestOid md2 = DigestOid.MD2;
    public static final DigestOid md5 = DigestOid.MD5;
    public static final Oid pkcs3 = new Oid("1.2.840.113549.1.3");
    public static final Oid dhKeyAgreementPKCS3 = new Oid("1.2.840.113549.1.3.1");
    public static final Oid rsaEncryptionAlgortihms = new Oid("1.2.840.113549.3");
    public static final SymmetricCipherOid rc2CBC = SymmetricCipherOid.RC2CBC;
    public static final SymmetricCipherOid rc4 = SymmetricCipherOid.RC4;
    public static final SymmetricCipherOid rc5CBC = SymmetricCipherOid.RC5CBC;
    public static final SymmetricCipherOid tripleDesCBC = SymmetricCipherOid.TRIPLEDESCBC;
    public static final Oid x500DirectoryServices = new Oid("2.5");
    public static final Oid x500AttributeType = new Oid("2.5.4");
    public static final X500AttributeOid commonName = X500AttributeOid.COMMON_NAME;
    public static final X500AttributeOid surname = X500AttributeOid.SURNAME;
    public static final X500AttributeOid serialNumber = X500AttributeOid.SERIAL_NUMBER;
    public static final X500AttributeOid country = X500AttributeOid.COUNTRY;
    public static final X500AttributeOid locality = X500AttributeOid.LOCALITY;
    public static final X500AttributeOid stateOrProvince = X500AttributeOid.STATE_OR_PROVINCE;
    public static final X500AttributeOid streetAddress = X500AttributeOid.STREET_ADDRESS;
    public static final X500AttributeOid organization = X500AttributeOid.ORGANIZATION;
    public static final X500AttributeOid organizationalUnit = X500AttributeOid.ORGANIZATIONAL_UNIT;
    public static final X500AttributeOid title = X500AttributeOid.TITLE;
    public static final X500AttributeOid description = X500AttributeOid.DESCRIPTION;
    public static final X500AttributeOid postalAddress = X500AttributeOid.POSTAL_ADDRESS;
    public static final X500AttributeOid postalCode = X500AttributeOid.POSTAL_CODE;
    public static final X500AttributeOid postOfficeBox = X500AttributeOid.POST_OFFICE_BOX;
    public static final X500AttributeOid telephoneNumber = X500AttributeOid.TELEPHONE_NUMBER;
    public static final X500AttributeOid telexNumber = X500AttributeOid.TELEX_NUMBER;
    public static final X500AttributeOid facsimileTelephoneNumber = X500AttributeOid.FACSIMILE_TELEPHONE_NUMBER;
    public static final X500AttributeOid givenName = X500AttributeOid.GIVEN_NAME;
    public static final X500AttributeOid initials = X500AttributeOid.INITIALS;
    public static final X500AttributeOid generationQualifier = X500AttributeOid.GENERATION_QUALIFIER;
    public static final X500AttributeOid uniqueIdentifier = X500AttributeOid.UNIQUE_IDENTIFIER;
    public static final X500AttributeOid dnQualifier = X500AttributeOid.DN_QUALIFIER;
    public static final Oid pkcs7 = new Oid("1.2.840.113549.1.7");
    public static final Pkcs7DataOid data = Pkcs7DataOid.DATA;
    public static final Pkcs7DataOid signedData = Pkcs7DataOid.SIGNED_DATA;
    public static final Pkcs7DataOid envelopedData = Pkcs7DataOid.ENVELOPED_DATA;
    public static final Pkcs7DataOid signedAndEnvelopedData = Pkcs7DataOid.SIGNED_AND_ENVELOPED_DATA;
    public static final Pkcs7DataOid digestedData = Pkcs7DataOid.DIGESTED_DATA;
    public static final Pkcs7DataOid encryptedData = Pkcs7DataOid.ENCRYPTED_DATA;
    public static final Oid pkcs9 = new Oid("1.2.840.113549.1.9");
    public static final Pkcs9AttributeOid emailAddress = Pkcs9AttributeOid.EMAIL_ADDRESS;
    public static final Pkcs9AttributeOid unstructuredName = Pkcs9AttributeOid.UNSTRUCTURED_NAME;
    public static final Pkcs9AttributeOid contentType = Pkcs9AttributeOid.CONTENT_TYPE;
    public static final Pkcs9AttributeOid messageDigest = Pkcs9AttributeOid.MESSAGE_DIGEST;
    public static final Pkcs9AttributeOid signingTime = Pkcs9AttributeOid.SIGNING_TIME;
    public static final Pkcs9AttributeOid counterSignature = Pkcs9AttributeOid.COUNTER_SIGNATURE;
    public static final Pkcs9AttributeOid challengePassword = Pkcs9AttributeOid.CHALLENGE_PASSWORD;
    public static final Pkcs9AttributeOid unstructuredAddress = Pkcs9AttributeOid.UNSTRUCTURED_ADDRESS;
    public static final Pkcs9AttributeOid extendedCertificateAttributes = Pkcs9AttributeOid.EXTENDED_CERTIFICATE_ATTRIBUTES;
    public static final Pkcs9AttributeOid extensionRequest = Pkcs9AttributeOid.EXTENSION_REQUEST;
    public static final Pkcs9AttributeOid smimeCapabilities = Pkcs9AttributeOid.SMIME_CAPABILITIES;
    public static final Pkcs9AttributeOid friendlyName = Pkcs9AttributeOid.FRIENDLY_NAME;
    public static final Pkcs9AttributeOid localKeyID = Pkcs9AttributeOid.LOCAL_KEY_ID;
    public static final Pkcs9AttributeOid x509Certificate = Pkcs9AttributeOid.X509_CERTIFICATE;
    public static final Pkcs9AttributeOid sdsiCertificate = Pkcs9AttributeOid.SDSI_CERTIFICATE;
    public static final Pkcs9AttributeOid x509CRL = Pkcs9AttributeOid.X509_CRL;
    public static final Pkcs9AttributeOid smime = Pkcs9AttributeOid.SMIME;
    public static final Pkcs9AttributeOid smimeEncrypKeyPref = Pkcs9AttributeOid.SMIME_ENCRYP_KEY_PREF;
    public static final Pkcs9AttributeOid cmsTripleDesWrap = Pkcs9AttributeOid.CMS_TRIPLE_DES_WRAP;
    public static final Pkcs9AttributeOid cmsRC2Wrap = Pkcs9AttributeOid.CMS_RC2_WRAP;
    public static final Oid x509CertificateExtension = new Oid("2.5.29");
    public static final X509ExtensionOid subjectKeyIdentifier = X509ExtensionOid.SUBJECT_KEY_IDENTIFIER;
    public static final X509ExtensionOid keyUsage = X509ExtensionOid.KEY_USAGE;
    public static final X509ExtensionOid privateKeyUsagePeriod = X509ExtensionOid.PRIVATE_KEY_USAGE_PERIOD;
    public static final X509ExtensionOid subjectAltName = X509ExtensionOid.SUBJECT_ALT_NAME;
    public static final X509ExtensionOid issuerAltName = X509ExtensionOid.ISSUER_ALT_NAME;
    public static final X509ExtensionOid basicConstraints = X509ExtensionOid.BASIC_CONSTRAINTS;
    public static final X509ExtensionOid cRLNumber = X509ExtensionOid.CRL_NUMBER;
    public static final X509ExtensionOid certificatePolicies = X509ExtensionOid.CERTIFICATE_POLICIES;
    public static final X509ExtensionOid policyMappings = X509ExtensionOid.POLICY_MAPPINGS;
    public static final X509ExtensionOid authorityKeyIdentifier = X509ExtensionOid.AUTHORITY_KEY_IDENTIFIER;
    public static final X509ExtensionOid extKeyUsage = X509ExtensionOid.EXT_KEY_USAGE;
    public static final X509ExtensionOid cRLReason = X509ExtensionOid.CRL_REASON;
    public static final X509ExtensionOid holdInstructionCode = X509ExtensionOid.HOLD_INSTRUCTION_CODE;
    public static final X509ExtensionOid invalidityDate = X509ExtensionOid.INVALIDITY_DATE;
    public static final X509ExtensionOid subjectDirectoryAttributes = X509ExtensionOid.SUBJECT_DIRECTORY_ATTRIBUTES;
    public static final X509ExtensionOid policyConstraints = X509ExtensionOid.POLICY_CONSTRAINTS;
    public static final X509ExtensionOid nameConstraints = X509ExtensionOid.NAME_CONSTRAINTS;
    public static final X509ExtensionOid cRLDistributionPoints = X509ExtensionOid.CRL_DISTRIBUTION_POINTS;
    public static final X509ExtensionOid issuingDistributionPoint = X509ExtensionOid.ISSUING_DISTRIBUTION_POINT;
    public static final X509ExtensionOid extendedKeyUsage = X509ExtensionOid.EXTENDED_KEY_USAGE;
    public static final X509ExtensionOid inhibitAnyPolicy = X509ExtensionOid.INHIBIT_ANY_POLICY;
    public static final PublicKeyEncryptionOid rsa = PublicKeyEncryptionOid.RSA;
    public static final SignatureOid dsaANSI = SignatureOid.DSAANSI;
    public static final SignatureOid dsaWithSHA1 = SignatureOid.DSA_WITH_SHA1;
    public static final SignatureOid ecdsa = SignatureOid.ECDSA;
    public static final SymmetricCipherOid des3CBC = SymmetricCipherOid.DES3CBC;
    public static final Oid dhKeyAgreementx942 = new Oid("1.2.840.10046.2.1");
    public static final SymmetricCipherOid desCBC = SymmetricCipherOid.DESCBC;
    public static final SignatureOid rsaSignature = SignatureOid.RSA_SIGNATURE;
    public static final SignatureOid dsa = SignatureOid.DSA;
    public static final SignatureOid shaWithRSASignature = SignatureOid.SHA_WITH_RSASIGNATURE;
    public static final Oid dhWithCommonModulus = new Oid("1.3.14.3.2.16");
    public static final SignatureOid dsaCommon = SignatureOid.DSA_COMMON;
    public static final SignatureOid dsaCommonWithSHA = SignatureOid.DSA_COMMON_WITH_SHA;
    public static final SignatureOid md2WithRSASignature = SignatureOid.MD2_WITH_RSASIGNATURE;
    public static final SignatureOid md5WithRSASignature = SignatureOid.MD5_WITH_RSASIGNATURE;
    public static final DigestOid sha1 = DigestOid.SHA1;
    public static final SignatureOid sha1WithRSASignature = SignatureOid.SHA1_WITH_RSA;
    public static final Oid pkcs12 = new Oid("1.2.840.113549.1.12");
    public static final Pkcs12AlgorithmOid pbeWithSHAAnd128BitRC4 = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_128BITRC4;
    public static final Pkcs12AlgorithmOid pbeWithSHAAnd40BitRC4 = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_40BIT_RC4;
    public static final Pkcs12AlgorithmOid pbeWithSHAAnd3_KeyTripleDES_CBC = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_3KEYTRIPLEDES_CBC;
    public static final Pkcs12AlgorithmOid pbeWithSHAAnd2_KeyTripleDESCCBC = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_2KEYTRIPLEDES_CCBC;
    public static final Pkcs12AlgorithmOid pbeWithSHAAnd128BitRC2_CBC = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_128BITRC2_CBC;
    public static final Pkcs12AlgorithmOid pbewithSHAAnd40BitRC2_CBC = Pkcs12AlgorithmOid.PBE_WITH_SHA_AND_40BITRC2_CBC;
    public static final Oid p12BagTypes = new Oid("1.2.840.113549.1.12.10.1");
    public static final Pkcs12BagOid keyBag = Pkcs12BagOid.KEY_BAG;
    public static final Pkcs12BagOid shroudedKeyBag = Pkcs12BagOid.SHROUDED_KEY_BAG;
    public static final Pkcs12BagOid certBag = Pkcs12BagOid.CERT_BAG;
    public static final Pkcs12BagOid crlBag = Pkcs12BagOid.CRL_BAG;
    public static final Pkcs12BagOid secretBag = Pkcs12BagOid.SECRET_BAG;
    public static final Pkcs12BagOid safeContentsBag = Pkcs12BagOid.SAFE_CONTENTS_BAG;
    public static final Oid id_pkix = new Oid("1.3.6.1.5.5.7");
    public static final Oid policyQualifier = new Oid(id_pkix + ".2");
    public static final PolicyQualifierOid cpsUri = PolicyQualifierOid.CPS_URI;
    public static final PolicyQualifierOid userNotice = PolicyQualifierOid.USER_NOTICE;
    public static final Oid id_kp = new Oid(id_pkix + ".3");
    public static final ExtendedKeyUsageOid anyExtendedKeyUsage = ExtendedKeyUsageOid.ANY_EXTENDED_KEY_USAGE;
    public static final ExtendedKeyUsageOid serverAuth = ExtendedKeyUsageOid.SERVER_AUTH;
    public static final ExtendedKeyUsageOid clientAuth = ExtendedKeyUsageOid.CLIENT_AUTH;
    public static final ExtendedKeyUsageOid codeSigning = ExtendedKeyUsageOid.CODE_SIGNING;
    public static final ExtendedKeyUsageOid emailProtection = ExtendedKeyUsageOid.EMAIL_PROTECTION;
    public static final ExtendedKeyUsageOid ipsecEndSystem = ExtendedKeyUsageOid.IPSEC_END_SYSTEM;
    public static final ExtendedKeyUsageOid ipsecTunnel = ExtendedKeyUsageOid.IPSEC_TUNNEL;
    public static final ExtendedKeyUsageOid ipsecUser = ExtendedKeyUsageOid.IPSEC_USER;
    public static final ExtendedKeyUsageOid timeStamping = ExtendedKeyUsageOid.TIME_STAMPING;
    public static final ExtendedKeyUsageOid OCSPSigning = ExtendedKeyUsageOid.OCSP_SIGNING;
    public static final SymmetricCipherOid aes128CBC = SymmetricCipherOid.AES128CBC;
    public static final SymmetricCipherOid aes192CBC = SymmetricCipherOid.AES192CBC;
    public static final SymmetricCipherOid aes256CBC = SymmetricCipherOid.AES256CBC;
    public static final DigestOid sha256 = DigestOid.SHA256;
    public static final DigestOid sha384 = DigestOid.SHA384;
    public static final DigestOid sha512 = DigestOid.SHA512;
    public static final ExtensionOid ABN = ExtensionOid.ABN;
    public static final ExtensionOid CAC = ExtensionOid.CAC;
    public static final ExtensionOid CARN = ExtensionOid.CARN;
    public static final ExtensionOid ATOPrimaryCertificateHolder = ExtensionOid.ATO_PRIMARY_CERTIFICATE_HOLDER;
    public static final ExtensionOid ATOSecondaryCertificateHolder = ExtensionOid.ATO_SECONDARY_CERTIFICATE_HOLDER;
    public static final CsiAttributeOid csiSigningInformation = CsiAttributeOid.CSI_SIGNING_INFORMATION;
    public static final Oid identrus = new Oid("1.2.840.114021");
    public static final Oid identrusIdentity = new Oid("1.2.840.114021.1.4.1");
    public static final Oid identrusUtility = new Oid("1.2.840.114021.1.5.1");
    public static final Oid SunJKS = new Oid("1.3.6.1.4.1.42.2.17.1.1");
    public static final DigestOid nullDigest = DigestOid.NULL_DIGEST;
    private static HashMap jcaMapping = new HashMap();
    private static HashMap attributeMapping = new HashMap();
    private static HashMap oidMapping = new HashMap();

    public static void addJCAMapping(Oid oid, String string) {
        if (oid != null && oid.getValue().length() != 0 && string != null && string.length() != 0) {
            jcaMapping.put(oid, string);
            Oids.addOIDMapping(string, oid);
        }
    }

    public static String getJCAMapping(Oid oid) {
        String string = null;
        if (oid != null && (string = (String)jcaMapping.get(oid)) == null) {
            r.a(w.i, "No JCA mapping exists for the Oid " + oid.toString() + ".");
        }
        return string;
    }

    public static void addAttribute(Oid oid, String string, String string2) {
        if (oid != null && oid.getValue().length() != 0 && string != null && string.length() != 0) {
            attributeMapping.put(oid, string);
            Oids.addOIDMapping(string, oid);
        }
    }

    public static String getAttribute(Oid oid) {
        String string = null;
        if (oid != null && (string = (String)attributeMapping.get(oid)) == null) {
            r.a(w.i, "No attribute exists for the Oid " + oid.toString() + ".");
        }
        return string;
    }

    public static void addOIDMapping(String string, Oid oid) {
        if (string != null && string.length() != 0 && oid != null && oid.getValue().length() != 0) {
            oidMapping.put(string.toLowerCase(), oid);
        }
    }

    public static Oid getOIDMapping(String string) {
        Oid oid = null;
        if (string != null && (oid = (Oid)oidMapping.get(string.toLowerCase())) == null) {
            r.a(w.i, "No OID mapping exists for the name " + string + ".");
        }
        return oid;
    }

    static {
        Oids.addJCAMapping(md2, "MD2");
        Oids.addJCAMapping(md5, "MD5");
        Oids.addJCAMapping(sha1, "SHA");
        Oids.addJCAMapping(sha1, "SHA-1");
        Oids.addJCAMapping(sha256, "SHA-256");
        Oids.addJCAMapping(sha256, "SHA256");
        Oids.addJCAMapping(sha384, "SHA-384");
        Oids.addJCAMapping(sha512, "SHA-512");
        Oids.addJCAMapping(nullDigest, "Null");
        Oids.addJCAMapping(rsaEncryption, "RSA");
        Oids.addJCAMapping(rsa, "RSA");
        Oids.addJCAMapping(rsaEncryptionOAEP, "RSA//OAEP");
        Oids.addJCAMapping(rc4, "RC4");
        Oids.addJCAMapping(rc2CBC, "RC2/CBC");
        Oids.addJCAMapping(des3CBC, "DESede/CBC");
        Oids.addJCAMapping(tripleDesCBC, "DESede/CBC");
        Oids.addOIDMapping("3DES", tripleDesCBC);
        Oids.addOIDMapping("DES3", tripleDesCBC);
        Oids.addOIDMapping("DESEDE", tripleDesCBC);
        Oids.addOIDMapping("DESede", tripleDesCBC);
        Oids.addOIDMapping("DESEDE/CBC", tripleDesCBC);
        Oids.addJCAMapping(desCBC, "DES/CBC");
        Oids.addJCAMapping(aes128CBC, "AES/CBC");
        Oids.addJCAMapping(aes192CBC, "AES/CBC");
        Oids.addJCAMapping(aes256CBC, "AES/CBC");
        Oids.addOIDMapping("AES/128", aes128CBC);
        Oids.addOIDMapping("AES/192", aes192CBC);
        Oids.addOIDMapping("AES/256", aes256CBC);
        Oids.addJCAMapping(md2WithRSAEncryption, "MD2withRSA");
        Oids.addJCAMapping(md5WithRSAEncryption, "MD5withRSA");
        Oids.addJCAMapping(sha1WithRSAEncryption, "SHA1withRSA");
        Oids.addJCAMapping(shaWithRSASignature, "SHA1withRSA");
        Oids.addJCAMapping(sha1WithRSASignature, "SHA1withRSA");
        Oids.addJCAMapping(sha256WithRSAEncryption, "SHA256withRSA");
        Oids.addJCAMapping(dsa, "DSA");
        Oids.addJCAMapping(dsaANSI, "DSA");
        Oids.addJCAMapping(dsaWithSHA1, "SHA1withDSA");
        Oids.addJCAMapping(pbeWithSHAAnd128BitRC4, "PBE/128/RC4/CBC");
        Oids.addJCAMapping(pbeWithSHAAnd40BitRC4, "PBE/40/RC4/CBC");
        Oids.addJCAMapping(pbeWithSHAAnd3_KeyTripleDES_CBC, "PBE/192/DESede/CBC");
        Oids.addJCAMapping(pbeWithSHAAnd2_KeyTripleDESCCBC, "PBE/128/DESede/CBC");
        Oids.addJCAMapping(pbeWithSHAAnd128BitRC2_CBC, "PBE/128/RC2/CBC");
        Oids.addJCAMapping(pbewithSHAAnd40BitRC2_CBC, "PBE/40/RC2/CBC");
        Oids.addJCAMapping(SunJKS, "sunJKS");
        Oids.addAttribute(commonName, "cn", "commonName");
        Oids.addAttribute(surname, "sn", "surname");
        Oids.addAttribute(serialNumber, "serialNumber", "serialNumber");
        Oids.addAttribute(country, "c", "country");
        Oids.addAttribute(locality, "l", "locality");
        Oids.addAttribute(stateOrProvince, "st", "stateOrProvince");
        Oids.addAttribute(streetAddress, "street", "streetAddress");
        Oids.addAttribute(organization, "o", "organization");
        Oids.addAttribute(organizationalUnit, "ou", "organizationalUnit");
        Oids.addAttribute(title, "title", "title");
        Oids.addAttribute(description, "description", "description");
        Oids.addAttribute(postalCode, "postalCode", "postalCode");
        Oids.addAttribute(telephoneNumber, "telephoneNumber", "telephoneNumber");
        Oids.addAttribute(facsimileTelephoneNumber, "fax", "facsimileTelephoneNumber");
        Oids.addAttribute(givenName, "givenName", "givenName");
        Oids.addAttribute(initials, "initials", "initials");
        Oids.addAttribute(uniqueIdentifier, "uniqueIdentifier", "uniqueIdentifier");
        Oids.addAttribute(dnQualifier, "dnQualifier", "dnQualifier");
        Oids.addAttribute(generationQualifier, "generationQualifier", "generationQualifier");
        Oids.addAttribute(emailAddress, "emailAddress", "emailAddress");
        Oids.addAttribute(smimeCapabilities, "smimeCapabilities", "smimeCapabilities");
        Oids.addAttribute(unstructuredName, "unstructuredName", "unstructuredName");
        Oids.addAttribute(unstructuredAddress, "unstructuredAddress", "unstructuredAddress");
        Oids.addAttribute(smimeEncrypKeyPref, "id-aa-encrypKeyPref", "id-aa-encrypKeyPref");
    }
}

