/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.crypto.PbeParameters;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class CsiPbeParameters
extends AlgorithmParametersSpi {
    private PBEParameterSpec pbeParams;
    private PbeParameters tree = new PbeParameters();

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("CsiPbeParameters.engineInit(AlgorithmParameterSpec) - " + algorithmParameterSpec.getClass().getName() + " not supported, expected PBEParameterSpec.");
        }
        this.pbeParams = (PBEParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.tree.a(new ByteArray(byArray, false));
            this.pbeParams = new PBEParameterSpec(this.tree.getSalt().getBytes(), this.tree.getIterations());
        }
        catch (CoderException coderException) {
            throw new IOException("CsiPbeParameters.engineInit(byte[]) - " + coderException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(PBEParameterSpec.class)) {
            throw new InvalidParameterSpecException("CsiPbeParameters.engineGetParameterSpec(Class) - " + clazz.getName() + " not supported, expected PBEParameterSpec.");
        }
        return this.pbeParams;
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.tree.g().getBytes();
        }
        catch (CoderException coderException) {
            throw new IOException("CsiPbeParameters.engineGetEncoded() - " + coderException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "PBE Parameters";
    }
}

