/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.crypto.Rc2Parameters;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public class CsiRc2Parameters
extends AlgorithmParametersSpi {
    private RC2ParameterSpec rc2Params;
    private Rc2Parameters tree = new Rc2Parameters();

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException("CSIRC2Parameters.engineInit(AlgorithmParameterSpec) - " + algorithmParameterSpec.getClass().getName() + " not supported, expected RC2ParameterSpec.");
        }
        this.rc2Params = (RC2ParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.tree.a(new ByteArray(byArray, false));
            this.rc2Params = new RC2ParameterSpec(this.tree.getEffectiveKeyBits(), this.tree.getIV().getBytes());
        }
        catch (CoderException coderException) {
            throw new IOException("CSIRC2Parameters.engineInit(byte[]) - " + coderException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(RC2ParameterSpec.class)) {
            throw new InvalidParameterSpecException("CSIRC2Parameters.engineGetParameterSpec(Class) - " + clazz.getName() + " not supported, expected RC2ParameterSpec.");
        }
        return this.rc2Params;
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.tree.g().getBytes();
        }
        catch (CoderException coderException) {
            throw new IOException("CSIRC2Parameters.engineGetEncoded() - " + coderException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "RC2 Parameters";
    }
}

