/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.keygen;

import au.gov.bafcsi.clapi.crypto.CsiRsaPrivateKey;
import au.gov.bafcsi.clapi.crypto.CsiRsaPublicKey;
import au.gov.bafcsi.clapi.crypto.CsiSecurityError;
import au.gov.bafcsi.clapi.crypto.do;
import au.gov.bafcsi.clapi.crypto.keygen.f1;
import au.gov.bafcsi.common.utils.q;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;

public final class CsiRsaKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static final int KEYSIZE_MIN = 1024;
    private static final int KEYSIZE_MAX = 16384;
    private int keysize = 1024;
    private BigInteger publicExponent = F4;

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n10 = this.keysize / 2;
        int n11 = this.keysize - n10;
        BigInteger bigInteger4 = this.publicExponent;
        do {
            bigInteger3 = f1.a(n10);
            bigInteger2 = f1.a(n11);
            bigInteger = bigInteger3.multiply(bigInteger2);
        } while (bigInteger3.compareTo(bigInteger2) == 0 || bigInteger.bitLength() != this.keysize);
        BigInteger bigInteger5 = bigInteger3.subtract(ONE);
        BigInteger bigInteger6 = bigInteger2.subtract(ONE);
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger4.modInverse(bigInteger7);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger5);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger6);
        BigInteger bigInteger11 = bigInteger2.modInverse(bigInteger3);
        CsiRsaPrivateKey csiRsaPrivateKey = new CsiRsaPrivateKey(bigInteger, bigInteger4, bigInteger8, bigInteger3, bigInteger2, bigInteger9, bigInteger10, bigInteger11);
        CsiRsaPublicKey csiRsaPublicKey = new CsiRsaPublicKey(bigInteger, bigInteger4);
        BigInteger bigInteger12 = new BigInteger(n10, q.c());
        BigInteger bigInteger13 = do.a(bigInteger12, bigInteger, bigInteger4);
        BigInteger bigInteger14 = do.a(csiRsaPrivateKey, bigInteger13);
        if (!bigInteger14.equals(bigInteger12)) {
            throw new CsiSecurityError("CsiRsaKeyPairGenerator.generateKeyPair() - Invalid key pair generated.");
        }
        return new KeyPair(csiRsaPublicKey, csiRsaPrivateKey);
    }

    public void initialize(int n10, SecureRandom secureRandom) {
        if (n10 < 1024 || n10 > 16384) {
            throw new InvalidParameterException("CsiRsaKeyPairGenerator(int, SecureRandom) - The supplied keysize must be between 1024 and 16384 bits.");
        }
        this.keysize = n10;
    }

    public void initialize(int n10) {
        this.initialize(n10, q.c());
    }
}

