/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

abstract class g6
extends SecretKeyFactorySpi {
    g6() {
    }

    protected final SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        KeySpec keySpec = null;
        SecretKey secretKey2 = null;
        if (secretKey == null) {
            throw new NullPointerException("The key passed to " + this.getClass().getName() + ".engineTranslateKey() was null.");
        }
        try {
            keySpec = this.engineGetKeySpec(secretKey, SecretKeySpec.class);
            secretKey2 = this.engineGenerateSecret(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("An error occured in " + this.getClass().getName() + ".engineTranslateKey(). The originating error is " + invalidKeySpecException.toString());
        }
        return secretKey2;
    }

    protected final KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        SecretKeySpec secretKeySpec = null;
        if (secretKey == null) {
            throw new NullPointerException("The key passed to " + this.getClass().getName() + ".engineGetKeySpec() was null.");
        }
        if (clazz == null) {
            throw new NullPointerException("The keySpec passed to " + this.getClass().getName() + ".engineGetKeySpec() was null.");
        }
        if (clazz.equals(SecretKeySpec.class)) {
            if (!secretKey.getFormat().equalsIgnoreCase("RAW")) {
                throw new InvalidKeySpecException(this.getClass().getName() + ".engineGetKeySpec() only accepts keys" + " with the RAW format. The key passed in" + " had a format of " + secretKey.getFormat());
            }
        } else {
            throw new InvalidKeySpecException(this.getClass().getName() + ".engineGetKeySpec() only accepts keySpec's of type" + " javax.crypto.spec.SecretKeySpec. The keySpec passed in" + " was of the type " + clazz.getClass().getName());
        }
        secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm());
        return secretKeySpec;
    }

    protected final SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        SecretKeySpec secretKeySpec;
        SecretKey secretKey = null;
        if (keySpec == null) {
            throw new NullPointerException("The keySpec passed to " + this.getClass().getName() + ".engineGenerateSecret() was null.");
        }
        if (keySpec instanceof SecretKeySpec) {
            secretKeySpec = null;
            secretKeySpec = (SecretKeySpec)keySpec;
            if (!secretKeySpec.getFormat().equalsIgnoreCase("RAW")) {
                throw new InvalidKeySpecException(this.getClass().getName() + ".engineGenerateSecret() only accepts keySpec's" + " with the RAW format. The keySpec passed in" + " had a format of " + secretKeySpec.getFormat());
            }
        } else {
            throw new InvalidKeySpecException(this.getClass().getName() + ".engineGenerateSecret() only accepts keySpec's of type" + " javax.crypto.spec.SecretKeySpec. The keySpec passed in" + " was of the type " + keySpec.getClass().getName());
        }
        secretKey = this.parseSecretKey(secretKeySpec);
        return secretKey;
    }

    abstract SecretKey parseSecretKey(SecretKeySpec var1) throws InvalidKeySpecException;
}

