/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.coders.dz;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.packaging.SignedOutputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ct;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import java.io.IOException;
import java.io.OutputStream;

public class SignedCmsOutputStream
extends SignedOutputStream {
    private OutputStream out = null;
    private cc contentInfo = null;
    private dz berOs = null;
    private OutputStream contentStream = null;
    private boolean cancelled = false;

    public SignedCmsOutputStream(OutputStream outputStream, SigningParameters signingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("SignedCmsOutputStream(OutputStream,SigningParameters) : OutputStream is null.");
        }
        if (signingParameters == null) {
            throw new IllegalArgumentException("SignedCmsOutputStream(OutputStream,SigningParameters) : SigningParameters is null.");
        }
        if (signingParameters.isNonRepudiationIntended()) {
            throw new IllegalArgumentException("SignedCmsOutputStream(OutputStream,SigningParameters) : This class may not be used to do NonRepudiation signing. Please use NonRepudiationSign instead.");
        }
        this.out = outputStream;
        ct ct2 = new ct(signingParameters);
        this.contentInfo = new cc(Oids.signedData, ct2);
        try {
            this.berOs = (dz)this.contentInfo.encode(this.out);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot encode contentInfo.", coderException);
        }
        this.contentStream = ct2.n();
    }

    public void write(int n10) throws IOException {
        this.contentStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.contentStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
        }
        this.contentStream = null;
        this.berOs.flush();
        this.berOs.close();
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.out instanceof da) {
            ((da)((Object)this.out)).setCancelled();
        }
    }
}

