/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms.full;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.InvalidConfigurationException;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.cz;
import au.gov.bafcsi.clapi.packaging.cms.full.Identifier;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public final class dl
extends az {
    public dl() {
        this.a((ax)new a7(), "version");
        this.a((ax)new Identifier(), "recipientId");
        this.a((ax)new AlgorithmIdentifier(), "keyEncryptionAlgorithm");
        this.a((ax)new cf(), "encryptedKey");
    }

    public dl(CsiCertificate csiCertificate, SecretKey secretKey) throws IOException {
        if (csiCertificate == null) {
            throw new IllegalArgumentException("KeyTransRecipientInfo(CsiCertificate, SecretKey) : CsiCertificate is null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("KeyTransRecipientInfo(CsiCertificate, SecretKey) : SecretKey is null.");
        }
        try {
            this.a((ax)new a7(0L), "version");
            this.a((ax)new Identifier(csiCertificate), "recipientId");
            cz cz2 = null;
            String string = Oids.getJCAMapping(new Oid(csiCertificate.getSigAlgOID()));
            if (string.indexOf("RSA") > 0) {
                cz2 = q.c("RSA");
                this.a((ax)new AlgorithmIdentifier((Oid)Oids.rsaEncryption, new dn()), "keyEncryptionAlgorithm");
            } else if (csiCertificate.getSigAlgName().indexOf("DSA") > 0) {
                cz2 = q.c("DSA");
                this.a((ax)new AlgorithmIdentifier((Oid)Oids.dsa, new dn()), "keyEncryptionAlgorithm");
            } else {
                throw new PackagingException("KeyTransRecipientInfo(CsiCertificate,SecretKey) : This certificate specifies an unsupported wrapping algorithm.");
            }
            cz2.a(3, csiCertificate.getPublicKey());
            this.a((ax)new cf(cz2.a(secretKey)), "encryptedKey");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PackagingException("KeyTransRecipientInfo(CsiCertificate,SecretKey) : " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PackagingException("KeyTransRecipientInfo(CsiCertificate,SecretKey) : " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (CertificateException certificateException) {
            throw new PackagingException("KeyTransRecipientInfo(CsiCertificate,SecretKey) : " + certificateException.getMessage(), certificateException);
        }
    }

    public int h() {
        return ((a7)this.a((String)"version")).a.intValue();
    }

    public Identifier i() {
        return (Identifier)this.a("recipientId");
    }

    public AlgorithmIdentifier j() {
        return (AlgorithmIdentifier)this.a("keyEncryptionAlgorithm");
    }

    public ByteArray k() {
        return ((cf)this.a("encryptedKey")).j();
    }

    public SecretKey a(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) throws IOException {
        try {
            String string = this.j().getAlgorithmName();
            if (string.indexOf("RSA") == -1 && string.indexOf("DSA") != -1) {
                throw new PackagingException("KeyTransRecipientInfo.unwrapKey(PrivateKey, AlgorithmIdentifier) : This certificate specifies an unsupported wrapping algorithm.");
            }
            cz cz2 = q.c(string);
            cz2.a(4, privateKey);
            String string2 = algorithmIdentifier.getAlgorithmName();
            String string3 = string2.substring(0, string2.indexOf("/"));
            return (SecretKey)cz2.a(this.k().getBytes(), string3, 7);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidConfigurationException("KeyTransRecipientInfo.unwrapKey(PrivateKey, Algorithmidentifier) : " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PackagingException("KeyTransRecipientInfo.unwrapKey(PrivateKey, Algorithmidentifier) : " + invalidKeyException.getMessage(), invalidKeyException);
        }
    }
}

