/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.packaging.SignedOutputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.clapi.packaging.smime.in;
import java.io.IOException;
import java.io.OutputStream;

public class MultipartSignedOutputStream
extends SignedOutputStream {
    private in teeStream = null;
    private String boundary = "***-DR-TD-DJ-TN-PC-EB-***-" + this.hashCode() + "-***";

    public MultipartSignedOutputStream(OutputStream outputStream, SigningParameters signingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("MultipartSignedOutputStream(OutputStream, SigningParameters) : OutputStream is null.");
        }
        if (signingParameters == null) {
            throw new IllegalArgumentException("MultipartSignedOutputStream(OutputStream, SigningParameters) : SigningParameters is null.");
        }
        if (!signingParameters.shouldSignatureBeDetached()) {
            throw new IllegalArgumentException("MultipartSignedOutputStream(OutputStream, SigningParameters) : The SigningParameters specifies that the signature should NOT be detached.");
        }
        if (signingParameters.shouldCreateCertificatesOnly()) {
            throw new IllegalArgumentException("MultipartSignedOutputStream(OutputStream, SigningParameters) : The SigningParameters specifies that a certificates only message should be created.");
        }
        this.writeHeaders(outputStream, Oids.getJCAMapping(signingParameters.getDigestAlgorithm()));
        this.teeStream = new in(outputStream, signingParameters);
        this.teeStream.a(this.boundary);
    }

    public void write(int n10) throws IOException {
        this.teeStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.teeStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        this.teeStream.a(this.boundary);
        this.teeStream.a();
        this.teeStream.a(this.boundary);
        this.teeStream.close();
    }

    public void setCancelled() {
        this.teeStream.setCancelled();
    }

    private void writeHeaders(OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Content-Type: multipart/signed; protocol=\"application/pkcs7-signature\"; micalg=");
        stringBuffer.append(string.toLowerCase() + "; ");
        stringBuffer.append("boundary=" + this.boundary + "\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
    }
}

