/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.packaging.SignedOutputStream;
import au.gov.bafcsi.clapi.packaging.cms.SignedCmsOutputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.common.utils.base64.Base64OutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SignedSMimeOutputStream
extends SignedOutputStream {
    private SignedCmsOutputStream signingStream = null;

    public SignedSMimeOutputStream(OutputStream outputStream, SigningParameters signingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("SignedSMimeOutputStream(OutputStream, SigningParameters) : OutputStream is null.");
        }
        if (signingParameters == null) {
            throw new IllegalArgumentException("SignedSMimeOutputStream(OutputStream, SigningParameters) : SigningParameters is null.");
        }
        if (signingParameters.isNonRepudiationIntended()) {
            throw new IllegalArgumentException("SignedSMimeOutputStream(OutputStream, SigningParameters) : This class may not be used to do NonRepudiation signing. Please use NonRepudiationSign instead.");
        }
        this.writeHeaders(outputStream, signingParameters);
        OutputStream outputStream2 = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        this.signingStream = new SignedCmsOutputStream(new Base64OutputStream(outputStream2), signingParameters);
    }

    public void write(int n10) throws IOException {
        this.signingStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.signingStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        this.signingStream.close();
    }

    public void setCancelled() {
        this.signingStream.setCancelled();
    }

    private void writeHeaders(OutputStream outputStream, SigningParameters signingParameters) throws IOException {
        String string = signingParameters.shouldSignatureBeDetached() ? ".p7s" : (signingParameters.shouldCreateCertificatesOnly() ? ".p7c" : ".p7m");
        String string2 = signingParameters.shouldCreateCertificatesOnly() ? "certs-only" : "signed-data";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Content-Type: application/pkcs7-mime; smime-type=" + string2 + "; name=smime" + string + "\r\n");
        stringBuffer.append("Content-Transfer-Encoding: base64\r\n");
        stringBuffer.append("Content-Disposition: attachment; filename=smime" + string + "\r\n");
        stringBuffer.append("\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
    }
}

