/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml;

import au.gov.bafcsi.clapi.packaging.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLElement {
    public static final String ATTRIBUTE_ALGORITHM = "Algorithm";
    public static final String ATTRIBUTE_URI = "URI";
    public static final String ATTRIBUTE_TYPE = "Type";
    public static final String ATTRIBUTE_ID = "Id";
    public static final String ATTRIBUTE_MIMETYPE = "MimeType";
    public static final String ATTRIBUTE_ENCODING = "Encoding";
    public static final String ATTRIBUTE_TARGET = "Target";
    public static final String NAMESPACE_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NAMESPACE_XMLDSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String NAMESPACE_WSSE = "http://schemas.xmlsoap.org/ws/2003/06/secext";
    public static final String NAMESPACE_CSI = "http://csi.business.gov.au/CSI/2004/04/csi";
    private Element element;

    protected XMLElement(Document document, String string, String string2) {
        if (document == null) {
            throw new IllegalArgumentException("XMLElement(Document, String, String) - The supplied Document is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLElement(Document, String, String) - The supplied elementName is null.");
        }
        String string3 = this.getDefaultPrefix(string2);
        if (string2 == null) {
            this.element = document.createElementNS(null, string);
        } else if (string3 == null || string3.length() == 0) {
            this.element = document.createElementNS(string2, string);
            this.element.setAttributeNS(NAMESPACE_XMLNS, "xmlns", string2);
        } else {
            this.element = document.createElementNS(string2, string3 + ":" + string);
            this.element.setAttributeNS(NAMESPACE_XMLNS, "xmlns:" + string3, string2);
        }
    }

    protected XMLElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("XMLElement(Element) - The supplied Element is null.");
        }
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public Document getOwnerDocument() {
        return XMLUtils.getOwnerDocument(this);
    }

    protected void addChild(XMLElement xMLElement) {
        if (xMLElement == null) {
            throw new IllegalArgumentException("XMLElement.addChild(XMLElement) - The suppled XMLElement is null.");
        }
        this.element.appendChild(xMLElement.getElement());
    }

    protected void addReturn(String string) {
        Document document = XMLUtils.getOwnerDocument(this);
        this.element.appendChild(document.createTextNode("\n" + (string == null ? "" : string)));
    }

    protected void setAttribute(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("XMLElement.setAttribute(String, String) - The supplied attributeName is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("XMLElement.setAttribute(String, String) - The supplied attributeValue is null.");
        }
        this.element.setAttributeNS(null, string, string2);
    }

    protected String getAttribute(String string) {
        if (string == null) {
            throw new IllegalArgumentException("XMLElement.getAttribute(String) - The supplied attributeName is null.");
        }
        return this.element.getAttributeNS(null, string);
    }

    protected void removeAttribute(String string) {
        if (string == null) {
            throw new IllegalArgumentException("XMLElement.removeAttribute(String) - The supplied attributeName is null.");
        }
        this.element.removeAttributeNS(null, string);
    }

    public Element findChild(String string, String string2) {
        return XMLElement.findChild(this.element, string, string2, 0);
    }

    protected static Element findChild(Element element, String string, String string2) {
        return XMLElement.findChild(element, string, string2, 0);
    }

    protected Element findChild(String string, String string2, int n10) {
        return XMLElement.findChild(this.element, string, string2, n10);
    }

    private static Element findChild(Element element, String string, String string2, int n10) {
        if (element == null) {
            throw new IllegalArgumentException("XMLElement.findChild(String, String, int) - The supplied element is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLElement.findChild(String, String, int) - The supplied localName is null");
        }
        if (n10 < 0) {
            throw new IllegalArgumentException("XMLElement.findChild(String, String, int) - The index is negative !");
        }
        NodeList nodeList = element.getChildNodes();
        int n11 = nodeList.getLength();
        int n12 = 0;
        for (int i10 = 0; i10 < n11; ++i10) {
            Node node = nodeList.item(i10);
            if (node.getNodeType() != 1) continue;
            String string3 = node.getNamespaceURI();
            if ((string2 != null || string3 != null) && (string3 == null || !string3.equals(string2))) continue;
            String string4 = node.getLocalName();
            if (!string.equals("*") && !string.equals(string4) || n12++ != n10) continue;
            return (Element)node;
        }
        return null;
    }

    protected int numberOfChildren(String string, String string2) {
        return XMLElement.numberOfChildren(this.element, string, string2);
    }

    protected static int numberOfChildren(Element element, String string, String string2) {
        if (element == null) {
            throw new IllegalArgumentException("XMLElement.numberOfChildren(String, String) - The supplied element is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLElement.numberOfChildren(String, String) - The supplied localName is null");
        }
        NodeList nodeList = element.getChildNodes();
        int n10 = nodeList.getLength();
        int n11 = 0;
        for (int i10 = 0; i10 < n10; ++i10) {
            Node node = nodeList.item(i10);
            if (node.getNodeType() != 1) continue;
            String string3 = node.getNamespaceURI();
            if ((string2 != null || string3 != null) && (string3 == null || !string3.equals(string2))) continue;
            String string4 = node.getLocalName();
            if (!string.equals("*") && !string.equals(string4)) continue;
            ++n11;
        }
        return n11;
    }

    private String getDefaultPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (NAMESPACE_XMLNS.equals(string)) {
            return "xmlns";
        }
        if (NAMESPACE_XMLDSIG.equals(string)) {
            return "ds";
        }
        if (NAMESPACE_WSSE.equals(string)) {
            return "wsse";
        }
        if (NAMESPACE_CSI.equals(string)) {
            return "csi";
        }
        return null;
    }
}

