/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml.signature.properties;

import au.gov.bafcsi.clapi.packaging.xml.XMLElement;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignatureException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SigningTime
extends XMLElement {
    private static final DateFormat format = new SimpleDateFormat("yyyyMMddHHmmssZ");

    public SigningTime(Document document, Date date) {
        super(document, "SigningTime", "http://csi.business.gov.au/CSI/2004/04/csi");
        if (date == null) {
            date = new Date();
        }
        this.getElement().appendChild(document.createTextNode(format.format(date)));
    }

    private SigningTime(Element element) {
        super(element);
    }

    public Date getTime() throws XMLSignatureException {
        try {
            return format.parse(this.getElement().getFirstChild().getNodeValue());
        }
        catch (ParseException parseException) {
            throw new XMLSignatureException("SigningTime.getTime() - " + parseException.getMessage());
        }
    }

    public static SigningTime buildInstance(Document document, Date date) {
        if (document == null) {
            throw new IllegalArgumentException("SigningTime.buildInstance(Document, Date) - The supplied document is null.");
        }
        return new SigningTime(document, date);
    }

    public static SigningTime getInstance(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("SigningTime.getInstance(Element) - The supplied Element is null.");
        }
        String string = element.getNamespaceURI();
        if (string == null || !string.equals("http://csi.business.gov.au/CSI/2004/04/csi")) {
            throw new IllegalArgumentException("SigningTime.getInstance(Element) - The supplied Element is not in the namespace 'http://csi.business.gov.au/CSI/2004/04/csi'.");
        }
        if (!element.getLocalName().equals("SigningTime")) {
            throw new IllegalArgumentException("SigningTime.getInstance(Element) - The supplied Element is not an SigningTime.");
        }
        return new SigningTime(element);
    }
}

