/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.pkcs12;

import au.gov.bafcsi.clapi.asn1.a1;
import au.gov.bafcsi.clapi.asn1.aw;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.InsertIdentity;
import au.gov.bafcsi.clapi.crypto.mac.f7;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ci;
import au.gov.bafcsi.clapi.packaging.cms.full.ga;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Exception;
import au.gov.bafcsi.clapi.pkcs12.cb;
import au.gov.bafcsi.clapi.pkcs12.cd;
import au.gov.bafcsi.clapi.pkcs12.cg;
import au.gov.bafcsi.clapi.pkcs12.ck;
import au.gov.bafcsi.clapi.pkcs12.cx;
import au.gov.bafcsi.clapi.pkcs12.fx;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class Pkcs12Importer {
    private boolean noKeyMaterial = false;
    private Collection keys = null;
    private Collection certs = null;
    private Collection chains = null;
    private Collection crls = null;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    public Pkcs12Importer(String string, String string2) throws Pkcs12Exception {
        this.noKeyMaterial = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Pkcs12Exception("Could not find the specified file (" + string + ").", fileNotFoundException);
        }
        this.load(fileInputStream, string2);
    }

    public Pkcs12Importer(String string) throws Pkcs12Exception {
        this.noKeyMaterial = true;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Pkcs12Exception("Could not find the specified file (" + string + ").", fileNotFoundException);
        }
        this.load(fileInputStream);
    }

    public Pkcs12Importer(InputStream inputStream, String string) throws Pkcs12Exception {
        this.noKeyMaterial = false;
        this.load(inputStream, string);
    }

    public Pkcs12Importer(InputStream inputStream) throws Pkcs12Exception {
        this.noKeyMaterial = true;
        this.load(inputStream);
    }

    public void insertIdentities(String string) throws CertStoreException, Pkcs12Exception {
        if (this.noKeyMaterial) {
            throw new Pkcs12Exception("Invalid use of importer: key material not imported by this instance.");
        }
        Collection collection = this.getIdentities();
        CertificateStore certificateStore = CertificateStore.getInstance();
        InsertIdentity.insert(collection, string);
        certificateStore.refreshStore();
    }

    private void load(InputStream inputStream, String string) throws Pkcs12Exception {
        if (inputStream == null) {
            throw new IllegalArgumentException("Pkcs12Importer.load(InputStream,String) - InputStream is null.");
        }
        if (this.noKeyMaterial) {
            throw new Pkcs12Exception("Invalid use of importer: key material not imported by this instance.");
        }
        try {
            MessageDigest messageDigest;
            cb cb2 = new cb();
            cb2.decode(inputStream);
            cb2.decodeFully();
            inputStream.close();
            cd cd2 = cb2.k();
            if (cd2 == null) {
                throw new Pkcs12Exception("Pkcs12Importer.load(InputStream,String) - PKCS#12s protected with a public key are not supported.");
            }
            Oid oid = cd2.h().h().getAlgorithmOID();
            String string2 = Oids.getJCAMapping(oid);
            try {
                messageDigest = DigestOid.getInstance(oid).getDigester();
            }
            catch (GeneralSecurityException generalSecurityException) {
                r.a(w.h, oid + " not a supported algorithm");
                throw new Pkcs12Exception(oid + "is not a supported algorithm");
            }
            cx cx2 = new cx(string, new PBEParameterSpec(cd2.i().getBytes(), cd2.j()), messageDigest);
            SecretKey secretKey = cx2.a(20, string2);
            ByteArray byteArray = cb2.i().k().p();
            f7 f72 = q.e("HMACwith" + messageDigest.getAlgorithm());
            f72.a(secretKey);
            f72.a(byteArray.getBytes());
            byte[] byArray = f72.a();
            if (!Arrays.equals(byArray, cd2.h().i().getBytes())) {
                throw new Pkcs12Exception("The supplied password is incorrect.");
            }
            this.certs = new ArrayList();
            this.keys = new ArrayList();
            this.chains = new ArrayList();
            this.crls = new ArrayList();
            cg cg2 = cb2.j();
            Iterator iterator = cg2.a();
            while (iterator.hasNext()) {
                a1 a12;
                cc cc2 = (cc)iterator.next();
                Oid oid2 = cc2.j();
                aw aw2 = null;
                if (oid2.equals(Oids.data)) {
                    aw2 = cc2.k();
                } else if (oid2.equals(Oids.encryptedData)) {
                    a12 = (ga)cc2.k();
                    a12.decodeFully();
                    PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)((ga)a12).j().getAlgorithmParameters().getParameterSpec(class$javax$crypto$spec$PBEParameterSpec == null ? Pkcs12Importer.class$("javax.crypto.spec.PBEParameterSpec") : class$javax$crypto$spec$PBEParameterSpec);
                    cx cx3 = new cx(string, pBEParameterSpec, messageDigest);
                    SecretKey secretKey2 = cx3.a(((ga)a12).j().getAlgorithmOID());
                    ((ga)a12).a(secretKey2, cx3.a(secretKey2.getAlgorithm()));
                    aw2 = a12;
                } else {
                    if (oid2.equals(Oids.envelopedData)) {
                        throw new Pkcs12Exception("Public-key integrity mode is not supported.");
                    }
                    throw new Pkcs12Exception("Invalid AuthenticatedSafe found.");
                }
                a12 = new ck();
                a12.a(aw2.p());
                ((ck)a12).a(string);
                this.keys.addAll(((ck)a12).a);
                this.certs.addAll(((ck)a12).b);
                this.chains.addAll(((ck)a12).c);
                this.crls.addAll(((ck)a12).d);
            }
        }
        catch (CoderException coderException) {
            throw new Pkcs12Exception(w.h, "Unexpected CoderException.", coderException);
        }
        catch (IOException iOException) {
            throw new Pkcs12Exception(w.h, "Unexpected I/O Exception.", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Pkcs12Exception(w.g, "Unexpected NoSuchAlgorithmException.", noSuchAlgorithmException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new Pkcs12Exception(w.h, "Unexpected InvalidParameterSpecException.", invalidParameterSpecException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Pkcs12Exception(w.h, "Unexpected InvalidKeyException.", invalidKeyException);
        }
    }

    private void load(InputStream inputStream) throws Pkcs12Exception {
        if (inputStream == null) {
            throw new IllegalArgumentException("Pkcs12Importer.load(InputStream) - InputStream is null.");
        }
        try {
            cb cb2 = new cb();
            cb2.decode(inputStream);
            cb2.decodeFully();
            inputStream.close();
            this.certs = new ArrayList();
            this.keys = new ArrayList();
            this.chains = new ArrayList();
            this.crls = new ArrayList();
            cg cg2 = cb2.j();
            Iterator iterator = cg2.a();
            while (iterator.hasNext()) {
                cc cc2 = (cc)iterator.next();
                Oid oid = cc2.j();
                ci ci2 = null;
                if (!oid.equals(Oids.data)) {
                    if (oid.equals(Oids.encryptedData) || oid.equals(Oids.envelopedData)) continue;
                    throw new Pkcs12Exception("Invalid AuthenticatedSafe found.");
                }
                ci2 = cc2.k();
                ck ck2 = new ck();
                ck2.a(ci2.p());
                ck2.a(Oids.certBag, null);
                ck2.a(Oids.secretBag, null);
                ck2.a(Oids.crlBag, null);
                this.keys.addAll(ck2.a);
                this.certs.addAll(ck2.b);
                this.chains.addAll(ck2.c);
                this.crls.addAll(ck2.d);
            }
        }
        catch (CoderException coderException) {
            throw new Pkcs12Exception("Unexpected CoderException.", coderException);
        }
        catch (IOException iOException) {
            throw new Pkcs12Exception("Unexpected I/O Exception.", iOException);
        }
        catch (Exception exception) {
            throw new Pkcs12Exception(w.g, "Unexpected Exception: " + exception.toString(), exception);
        }
    }

    public Collection getIdentities() throws Pkcs12Exception {
        if (this.noKeyMaterial) {
            throw new Pkcs12Exception("Invalid use of importer: key material not imported by this instance.");
        }
        ArrayList<fx> arrayList = new ArrayList<fx>();
        Iterator iterator = this.certs.iterator();
        block0: while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            Iterator iterator2 = this.keys.iterator();
            while (iterator2.hasNext()) {
                CertificateCollection certificateCollection;
                PrivateKey privateKey = (PrivateKey)iterator2.next();
                fx fx2 = new fx(privateKey);
                if (!fx2.a(csiCertificate)) continue;
                if (!this.chains.isEmpty()) {
                    certificateCollection = this.getMatchingCertificateChain(csiCertificate);
                    fx2.a(certificateCollection);
                } else {
                    certificateCollection = new CertificateCollection();
                    Object[] objectArray = this.certs.toArray();
                    for (int i10 = 0; i10 < objectArray.length; ++i10) {
                        certificateCollection.addCertificate((CsiCertificate)objectArray[i10]);
                    }
                    CsiCertificate csiCertificate2 = certificateCollection.getIssuerCertificate(csiCertificate);
                    if (csiCertificate2 != null) {
                        CertificateCollection certificateCollection2 = new CertificateCollection();
                        do {
                            certificateCollection2.addCertificate(csiCertificate2);
                        } while ((csiCertificate2 = certificateCollection.getIssuerCertificate(csiCertificate2)) != null);
                        fx2.a(certificateCollection2);
                    }
                }
                arrayList.add(fx2);
                continue block0;
            }
        }
        return arrayList;
    }

    public CertificateCollection getCertificates() {
        CertificateCollection certificateCollection = this.getUserCertificates();
        if (certificateCollection.isEmpty()) {
            Iterator iterator = this.certs.iterator();
            while (iterator.hasNext()) {
                certificateCollection.addCertificate((CsiCertificate)iterator.next());
            }
        }
        return certificateCollection;
    }

    public CertificateCollection getMatchingCertificateChain(CsiCertificate csiCertificate) {
        Iterator iterator = this.chains.iterator();
        while (iterator.hasNext()) {
            CertificateCollection certificateCollection = (CertificateCollection)iterator.next();
            if (certificateCollection.getIssuerCertificate(csiCertificate) == null) continue;
            return certificateCollection;
        }
        return null;
    }

    private CertificateCollection getUserCertificates() {
        CertificateCollection certificateCollection = new CertificateCollection();
        Iterator iterator = this.chains.iterator();
        while (iterator.hasNext()) {
            CertificateCollection certificateCollection2 = (CertificateCollection)iterator.next();
            Iterator iterator2 = certificateCollection2.iterator();
            while (iterator2.hasNext()) {
                CsiCertificate csiCertificate = (CsiCertificate)iterator2.next();
                if (csiCertificate.getBasicConstraints() != -1) continue;
                certificateCollection.addCertificate(csiCertificate);
            }
        }
        return certificateCollection;
    }

    public static String getPasswordFromAbnPic(String string, String string2) throws Pkcs12Exception {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = string2.getBytes("UTF-8");
            MessageDigest messageDigest = q.a(Oids.md5);
            byte[] byArray3 = messageDigest.digest(byArray);
            BigInteger bigInteger = new BigInteger(byArray3);
            BigInteger bigInteger2 = new BigInteger(byArray2);
            ByteArray byteArray = new ByteArray(bigInteger2.xor(bigInteger).toByteArray());
            ByteArray byteArray2 = new ByteArray(byArray2);
            byteArray2.append(byteArray);
            return Pkcs12Importer.convertToCharString(byteArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Pkcs12Exception("UTF-8 encoding not available.", unsupportedEncodingException);
        }
    }

    private static String convertToCharString(ByteArray byteArray) {
        char[] cArray = new char[byteArray.length()];
        for (int i10 = 0; i10 < cArray.length; ++i10) {
            cArray[i10] = (char)byteArray.byteAt(i10);
        }
        return new String(cArray);
    }
}

