/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common;

import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.e4;
import au.gov.bafcsi.clapi.crypto.e5;
import au.gov.bafcsi.clapi.crypto.fi;
import au.gov.bafcsi.clapi.crypto.i3;
import au.gov.bafcsi.clapi.crypto.iw;
import au.gov.bafcsi.common.CertSelectTable;
import au.gov.bafcsi.common.jr;
import au.gov.bafcsi.common.js;
import au.gov.bafcsi.common.jt;
import au.gov.bafcsi.common.ju;
import au.gov.bafcsi.common.jv;
import au.gov.bafcsi.common.jw;
import au.gov.bafcsi.common.utils.HelpViewer;
import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.af;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import au.gov.bafcsi.ui.jd;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;

public final class SelectCertificateFrame
extends af {
    private JLabel m_messageLabel;
    private JScrollPane m_tablePanel;
    private JPanel m_controlPanel;
    private JButton m_selectButton;
    private JButton m_cancelButton;
    private JButton m_detailButton;
    private JButton m_refreshButton;
    private JButton m_helpButton;
    private CertSelectTable m_table = null;
    private e4 m_tableModel;
    private e5 m_tableSorter;
    private ListSelectionModel m_rowSM;
    private List m_certificates;
    private boolean m_isNonRepudiation;
    private CertificateStore m_store;
    private int m_selection;
    private int m_certsInList = -1;

    public SelectCertificateFrame(boolean bl2, String string) {
        super(string);
        this.m_isNonRepudiation = bl2;
        this.m_store = CertificateStore.getInstance();
        this.init();
    }

    public void show() {
        if (this.m_certsInList < 1) {
            ae.b(af.a(), "No digital certificates are available for signing operations.", "CSI - Information", 1);
            this.cancel();
        } else {
            super.show();
        }
    }

    public CsiCertificate getSelectedCertificate() {
        if (this.m_selection == -1) {
            return null;
        }
        return ((fi)this.m_certificates.get(this.m_selection)).e();
    }

    private void init() {
        this.refresh();
        this.m_messageLabel = new JLabel("");
        this.m_tableModel = new i3(this.m_certificates);
        this.m_tableSorter = new e5(this.m_tableModel);
        this.m_table = new CertSelectTable(this.m_tableSorter);
        this.m_tableSorter.a(this.m_table.getTableHeader());
        this.m_table.setAutoResizeMode(0);
        this.m_tableModel.a(this.m_table.getColumnModel());
        this.m_rowSM = this.m_table.getSelectionModel();
        this.m_rowSM.setSelectionMode(0);
        this.m_tablePanel = new JScrollPane();
        this.m_tablePanel.getViewport().add(this.m_table);
        this.m_selectButton = new JButton("Select");
        this.m_cancelButton = new JButton("Cancel");
        this.m_detailButton = new JButton("Details...");
        this.m_refreshButton = new JButton("Refresh");
        this.m_helpButton = new JButton("Help");
        this.m_controlPanel = new JPanel();
        this.m_controlPanel.setLayout(new FlowLayout());
        this.m_controlPanel.add(this.m_selectButton);
        this.m_controlPanel.add(this.m_cancelButton);
        this.m_controlPanel.add(this.m_detailButton);
        this.m_controlPanel.add(this.m_refreshButton);
        if (!s.a().an()) {
            this.m_controlPanel.add(this.m_helpButton);
        }
        this.m().setLayout(new BorderLayout());
        this.m().add((Component)this.m_messageLabel, "North");
        this.m().add((Component)this.m_tablePanel, "Center");
        this.m().add((Component)this.m_controlPanel, "South");
        this.m_table.addKeyListener(new jr(this));
        js js2 = new js(this);
        this.m_table.registerKeyboardAction(js2, KeyStroke.getKeyStroke(10, 0), 0);
        this.m_selectButton.setMnemonic(83);
        this.m_selectButton.setToolTipText("Select the highlighted certificate for signing");
        this.m_selectButton.addActionListener(js2);
        jt jt2 = new jt(this);
        this.m_cancelButton.setMnemonic(67);
        this.m_cancelButton.setToolTipText("Cancel certificate selection");
        this.m_cancelButton.addActionListener(jt2);
        this.m_detailButton.setMnemonic(68);
        this.m_detailButton.setToolTipText("Show certificate details");
        this.m_detailButton.addActionListener(jt2);
        this.m_helpButton.setMnemonic(72);
        this.m_helpButton.setToolTipText("Show help information");
        this.m_helpButton.addActionListener(jt2);
        this.m_refreshButton.setMnemonic(82);
        this.m_refreshButton.setToolTipText("Refresh certificate list");
        this.m_refreshButton.addActionListener(jt2);
        this.m_rowSM.addListSelectionListener(new ju(this));
        this.a(new jv(this));
        this.m_table.addMouseListener(new jw(this));
        this.setButtonEnablement(true);
        this.i = 500;
        this.j = 250;
        this.m_messageLabel.setText("Please select a certificate from the following list:");
        this.m_messageLabel.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.g();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 50);
    }

    private void select() {
        if (this.m_selection != -1) {
            this.c();
        }
    }

    private void cancel() {
        this.m_selection = -1;
        this.c();
    }

    private void help() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        HelpViewer helpViewer = HelpViewer.getInstance(this.a);
        this.setCursor(Cursor.getPredefinedCursor(0));
        helpViewer.showPage(SelectCertificateFrame.class.getResource("/au/gov/bafcsi/helppages/IdentitySelectionScreen.htm"));
    }

    private void details() {
        if (this.m_selection >= 0 && this.m_selection < this.m_certificates.size()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            fi fi2 = (fi)this.m_certificates.get(this.m_selection);
            this.setCursor(Cursor.getPredefinedCursor(0));
            new jd(fi2, true, (Object)af.a());
        }
    }

    private void setButtonEnablement(boolean bl2) {
        if (bl2) {
            if (this.m_selection < 0 || this.m_selection >= this.m_certsInList) {
                this.m_detailButton.setEnabled(false);
                this.m_selectButton.setEnabled(false);
            } else {
                String string = this.m_isNonRepudiation ? "NR" : "A";
                fi fi2 = (fi)this.m_certificates.get(this.m_selection);
                if (fi2.b(string)) {
                    this.m_detailButton.setEnabled(true);
                    this.m_selectButton.setEnabled(true);
                } else {
                    this.m_detailButton.setEnabled(true);
                    this.m_selectButton.setEnabled(false);
                }
            }
        } else {
            this.m_detailButton.setEnabled(false);
            this.m_selectButton.setEnabled(false);
        }
        this.m_cancelButton.setEnabled(bl2);
        this.m_helpButton.setEnabled(bl2);
    }

    private void refresh() {
        try {
            this.m_store.refreshStore();
            int n10 = this.m_isNonRepudiation ? 1 : 0;
            List list = iw.a().b();
            this.m_certificates = iw.a().a(list, n10);
        }
        catch (CertStoreException certStoreException) {
            r.a(w.f, "CertStoreException in SelectCertificateFrame.", certStoreException);
            ae.b(null, "An unexpected error occured while accessing certificate information.\n", "CSI - Error", 0);
            this.cancel();
            return;
        }
        if (this.m_certsInList != this.m_certificates.size()) {
            this.m_certsInList = this.m_certificates.size();
            this.m_selection = -1;
            if (this.m_rowSM != null) {
                this.m_rowSM.clearSelection();
            }
            if (this.m_table != null) {
                this.m_tableModel.a(this.m_certificates);
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.m_table.requestFocus();
    }

    static /* synthetic */ JButton access$000(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_helpButton;
    }

    static /* synthetic */ JButton access$100(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_selectButton;
    }

    static /* synthetic */ void access$200(SelectCertificateFrame selectCertificateFrame) {
        selectCertificateFrame.select();
    }

    static /* synthetic */ JButton access$300(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_cancelButton;
    }

    static /* synthetic */ void access$400(SelectCertificateFrame selectCertificateFrame) {
        selectCertificateFrame.cancel();
    }

    static /* synthetic */ JButton access$500(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_detailButton;
    }

    static /* synthetic */ void access$600(SelectCertificateFrame selectCertificateFrame) {
        selectCertificateFrame.details();
    }

    static /* synthetic */ void access$700(SelectCertificateFrame selectCertificateFrame) {
        selectCertificateFrame.help();
    }

    static /* synthetic */ JButton access$800(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_refreshButton;
    }

    static /* synthetic */ void access$900(SelectCertificateFrame selectCertificateFrame) {
        selectCertificateFrame.refresh();
    }

    static /* synthetic */ int access$1002(SelectCertificateFrame selectCertificateFrame, int n10) {
        selectCertificateFrame.m_selection = n10;
        return selectCertificateFrame.m_selection;
    }

    static /* synthetic */ e5 access$1100(SelectCertificateFrame selectCertificateFrame) {
        return selectCertificateFrame.m_tableSorter;
    }

    static /* synthetic */ void access$1200(SelectCertificateFrame selectCertificateFrame, boolean bl2) {
        selectCertificateFrame.setButtonEnablement(bl2);
    }
}

