/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.utils.base64;

import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class Base64 {
    public static final boolean ENCODE = true;
    public static final boolean DECODE = false;
    static final byte WHITE_SPACE = -2;
    static final byte BAD_ENCODING = -3;
    static final byte EQUALS_SIGN = -1;
    public static final byte[] NEW_LINE = new byte[]{13, 10};
    private static final byte[] base64Encode = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] base64Decode = new byte[]{-3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -3, -3, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 62, -3, -3, -3, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -3, -3, -3, -1, -3, -3, -3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -3, -3, -3, -3, -3, -3, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -3, -3, -3, -3, -3};

    private Base64() {
    }

    static byte[] base64Encode(byte[] byArray, int n10, int n11, byte[] byArray2, int n12) {
        int n13 = (n11 > 0 ? byArray[n10] << 24 >>> 8 : 0) | (n11 > 1 ? byArray[n10 + 1] << 24 >>> 16 : 0) | (n11 > 2 ? byArray[n10 + 2] << 24 >>> 24 : 0);
        switch (n11) {
            case 3: {
                byArray2[n12] = base64Encode[n13 >>> 18];
                byArray2[n12 + 1] = base64Encode[n13 >>> 12 & 0x3F];
                byArray2[n12 + 2] = base64Encode[n13 >>> 6 & 0x3F];
                byArray2[n12 + 3] = base64Encode[n13 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n12] = base64Encode[n13 >>> 18];
                byArray2[n12 + 1] = base64Encode[n13 >>> 12 & 0x3F];
                byArray2[n12 + 2] = base64Encode[n13 >>> 6 & 0x3F];
                byArray2[n12 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n12] = base64Encode[n13 >>> 18];
                byArray2[n12 + 1] = base64Encode[n13 >>> 12 & 0x3F];
                byArray2[n12 + 2] = 61;
                byArray2[n12 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    static int base64Decode(byte[] byArray, int n10, byte[] byArray2, int n11) {
        if (byArray[n10 + 2] == 61) {
            int n12 = base64Decode[byArray[n10]] << 24 >>> 6 | base64Decode[byArray[n10 + 1]] << 24 >>> 12;
            byArray2[n11] = (byte)(n12 >>> 16);
            return 1;
        }
        if (byArray[n10 + 3] == 61) {
            int n13 = base64Decode[byArray[n10]] << 24 >>> 6 | base64Decode[byArray[n10 + 1]] << 24 >>> 12 | base64Decode[byArray[n10 + 2]] << 24 >>> 18;
            byArray2[n11] = (byte)(n13 >>> 16);
            byArray2[n11 + 1] = (byte)(n13 >>> 8);
            return 2;
        }
        int n14 = base64Decode[byArray[n10]] << 24 >>> 6 | base64Decode[byArray[n10 + 1]] << 24 >>> 12 | base64Decode[byArray[n10 + 2]] << 24 >>> 18 | base64Decode[byArray[n10 + 3]] << 24 >>> 24;
        byArray2[n11] = (byte)(n14 >> 16);
        byArray2[n11 + 1] = (byte)(n14 >> 8);
        byArray2[n11 + 2] = (byte)n14;
        return 3;
    }

    static byte[] base64Decode(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        int n10 = Base64.base64Decode(byArray, 0, byArray2, 0);
        if (n10 != 3) {
            byte[] byArray3 = new byte[n10];
            System.arraycopy(byArray2, 0, byArray3, 0, n10);
            return byArray3;
        }
        return byArray2;
    }

    public static ByteArray encode(ByteArray byteArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        base64OutputStream.write(byteArray);
        base64OutputStream.close();
        return new ByteArray(byteArrayOutputStream.toByteArray());
    }

    public static ByteArray decode(ByteArray byteArray) {
        return Base64.decode(byteArray.getBytes(), 0, byteArray.getLength());
    }

    public static ByteArray decode(byte[] byArray, int n10, int n11) {
        if (byArray == null) {
            throw new IllegalArgumentException("Base64.decode(byte[], int, int) - The supplied byte[] is null.");
        }
        if (n11 == 0) {
            return new ByteArray();
        }
        byte[] byArray2 = new byte[4];
        int n12 = 0;
        byte[] byArray3 = new byte[n11 / 4 * 3 + 3];
        int n13 = 0;
        for (int i10 = 0; i10 < n11; ++i10) {
            byte by2 = byArray[n10 + i10];
            if (by2 > 127 || by2 >= 0 && (base64Decode[by2 & 0x7F] == -3 || base64Decode[by2 & 0x7F] == -2)) continue;
            byArray2[n12++] = (byte)(by2 & 0x7F);
            if (n12 != 4) continue;
            n12 = 0;
            n13 += Base64.base64Decode(byArray2, 0, byArray3, n13);
        }
        if (n13 == byArray3.length) {
            return new ByteArray(byArray3, false);
        }
        byte[] byArray4 = new byte[n13];
        System.arraycopy(byArray3, 0, byArray4, 0, n13);
        return new ByteArray(byArray4, false);
    }

    public static ByteArray decode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Base64.decode(String) - The supplied String is null.");
        }
        int n10 = string.length();
        if (n10 == 0) {
            return new ByteArray();
        }
        byte[] byArray = new byte[4];
        int n11 = 0;
        byte[] byArray2 = new byte[n10 / 4 * 3 + 3];
        int n12 = 0;
        for (int i10 = 0; i10 < n10; ++i10) {
            char c10 = string.charAt(i10);
            if (c10 > '\u007f' || c10 >= '\u0000' && (base64Decode[c10 & 0x7F] == -3 || base64Decode[c10 & 0x7F] == -2)) continue;
            byArray[n11++] = (byte)(c10 & 0x7F);
            if (n11 != 4) continue;
            n11 = 0;
            n12 += Base64.base64Decode(byArray, 0, byArray2, n12);
        }
        if (n12 == byArray2.length) {
            return new ByteArray(byArray2, false);
        }
        byte[] byArray3 = new byte[n12];
        System.arraycopy(byArray2, 0, byArray3, 0, n12);
        return new ByteArray(byArray3, false);
    }
}

