/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.hapi;

import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class CertificateValidator {
    final boolean coreIsCertificateValid(X509Certificate x509Certificate) {
        if (!this.isCertificateTimeValid(x509Certificate)) {
            return false;
        }
        return this.isCertificateValid(x509Certificate);
    }

    final boolean coreIsCertificateValid(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("No certificates in certificate chain.");
        }
        for (int i10 = 0; i10 < x509CertificateArray.length; ++i10) {
            if (this.isCertificateTimeValid(x509CertificateArray[i10])) continue;
            return false;
        }
        if (!this.isCertificateChainValid(x509CertificateArray)) {
            return false;
        }
        return this.isCertificateValid(x509CertificateArray);
    }

    public boolean isCertificateTimeValid(X509Certificate x509Certificate) {
        CsiCertificate csiCertificate = new CsiCertificate(x509Certificate);
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            String string = "Certificate expired in CertificateValidator. Subject name = " + csiCertificate.getSubjectCommonName() + ", issuer name = " + csiCertificate.getIssuerCommonName();
            r.a(w.h, string);
            return false;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            String string = "Certificate not yet valid in CertificateValidator. Subject name = " + csiCertificate.getSubjectCommonName() + ", issuer name = " + csiCertificate.getIssuerCommonName();
            r.a(w.h, string);
            return false;
        }
        return true;
    }

    public boolean isCertificateChainValid(X509Certificate[] x509CertificateArray) {
        return true;
    }

    public boolean isCertificateValid(X509Certificate x509Certificate) {
        return true;
    }

    public boolean isCertificateValid(X509Certificate[] x509CertificateArray) {
        return true;
    }
}

