/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.chunk.CertificateStatus;
import au.gov.bafcsi.chunk.Chunk;
import au.gov.bafcsi.chunk.VerificationConfig;
import au.gov.bafcsi.chunk.VerificationStatus;
import au.gov.bafcsi.chunk.ef;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.smime.SignedSMimeInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedOutputStream;

public final class SmimeVerifier {
    private PipedOutputStream out;
    private ByteArrayOutputStream smimeOut;
    private SignedSMimeInputStream smimeIn;
    private Thread otherEnd;
    private boolean shouldReturnData = true;
    private final Object lock = new Object();

    public void start(VerificationConfig verificationConfig) throws IOException {
        if (verificationConfig == null) {
            throw new IllegalArgumentException("SmimeVerifier.start(VerificationConfig): VerificationConfig is null.");
        }
        this.out = new PipedOutputStream();
        this.otherEnd = new Thread(new ef(this));
        this.otherEnd.start();
        this.shouldReturnData = verificationConfig.isReturnData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk update(Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("SmimeVerifier.update(Chunk): Chunk is null.");
        }
        byte[] byArray = chunk.getData();
        if (byArray != null && byArray.length > 0) {
            this.out.write(byArray);
        }
        byte[] byArray2 = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldReturnData) {
                byArray2 = this.smimeOut.toByteArray();
            }
            this.smimeOut.reset();
        }
        return new Chunk(chunk.getId(), byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationStatus finish() throws IOException {
        this.out.flush();
        this.out.close();
        while (this.otherEnd.isAlive()) {
        }
        byte[] byArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldReturnData) {
                byArray = this.smimeOut.toByteArray();
            }
            this.smimeOut.reset();
        }
        object = new Chunk(-1L, byArray);
        VerificationStatus verificationStatus = new VerificationStatus((Chunk)object);
        CsiCertificate csiCertificate = this.smimeIn.verify(this.smimeIn.getCertificates());
        if (csiCertificate != null) {
            CertificateStatus certificateStatus = new CertificateStatus(csiCertificate);
            verificationStatus.setVerifyingChainStatus(new CertificateStatus[]{certificateStatus});
            verificationStatus.setSignatureVerified();
        }
        return verificationStatus;
    }

    static /* synthetic */ ByteArrayOutputStream access$002(SmimeVerifier smimeVerifier, ByteArrayOutputStream byteArrayOutputStream) {
        smimeVerifier.smimeOut = byteArrayOutputStream;
        return smimeVerifier.smimeOut;
    }

    static /* synthetic */ PipedOutputStream access$100(SmimeVerifier smimeVerifier) {
        return smimeVerifier.out;
    }

    static /* synthetic */ SignedSMimeInputStream access$202(SmimeVerifier smimeVerifier, SignedSMimeInputStream signedSMimeInputStream) {
        smimeVerifier.smimeIn = signedSMimeInputStream;
        return smimeVerifier.smimeIn;
    }

    static /* synthetic */ SignedSMimeInputStream access$200(SmimeVerifier smimeVerifier) {
        return smimeVerifier.smimeIn;
    }

    static /* synthetic */ Object access$300(SmimeVerifier smimeVerifier) {
        return smimeVerifier.lock;
    }

    static /* synthetic */ ByteArrayOutputStream access$000(SmimeVerifier smimeVerifier) {
        return smimeVerifier.smimeOut;
    }
}

