/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.aq;
import au.gov.bafcsi.common.utils.p;
import java.io.IOException;
import java.security.cert.CertificateException;

public final class KeyUsage
extends b0 {
    private static final boolean[] allPowerful = new boolean[]{true, true, true, true, true, true, true, true, true};
    public static final int DigitalSignature = 0;
    public static final int NonRepudiation = 1;
    public static final int KeyEncipherment = 2;
    public static final int DataEncipherment = 3;
    public static final int KeyAgreement = 4;
    public static final int KeyCertSign = 5;
    public static final int CRLSign = 6;
    public static final int EncipherOnly = 7;
    public static final int DecipherOnly = 8;
    private static final String[] keyUsages = new String[]{"DigitalSignature", "NonRepudiation", "KeyEncipherment", "DataEncipherment", "KeyAgreement", "KeyCertSign", "CRLSign", "EncipherOnly", "DecipherOnly"};
    private String dumbString = null;
    private boolean[] keyUsage;

    public KeyUsage(ByteArray byteArray) throws CertificateException {
        if (byteArray == null) {
            throw new IllegalArgumentException("KeyUsage(ByteArray) - The supplied ByteArray is null.");
        }
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("KeyUsage(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("KeyUsage(ByteArray) - " + coderException.getMessage());
        }
        try {
            this.keyUsage = p.a(this.a, this.b);
        }
        catch (aq aq2) {
            throw new CertificateException("KeyUsage(ByteArray) - " + aq2.getMessage());
        }
    }

    public KeyUsage(boolean[] blArray) {
        if (blArray == null) {
            blArray = allPowerful;
        } else if (blArray.length == 0) {
            throw new IllegalArgumentException("KeyUsage(boolean[]) - The length of the supplied boolean[] is 0.");
        }
        this.keyUsage = blArray;
        int n10 = blArray.length % 8;
        if (n10 != 0) {
            n10 = 8 - n10;
        }
        this.setValue(p.a(this.keyUsage), n10);
    }

    public boolean hasUsage(int n10) {
        if (n10 < 0) {
            throw new IndexOutOfBoundsException("KeyUsage.hasUsage(int) - keyUsage " + p.a(n10, 0, 8));
        }
        if (n10 >= this.keyUsage.length) {
            return false;
        }
        return this.keyUsage[n10];
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i10 = 0; i10 < this.keyUsage.length; ++i10) {
            if (!this.keyUsage[i10]) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(keyUsages[i10]);
        }
        return "KeyUsage = " + stringBuffer.toString();
    }

    public String toDumbString() {
        if (this.dumbString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.keyUsage.length > 0 && this.keyUsage[0]) {
                stringBuffer.append(", Authentication");
            }
            if (this.keyUsage.length > 1 && this.keyUsage[1]) {
                stringBuffer.append(", Non-repudiation");
            }
            if (this.keyUsage.length > 2 && this.keyUsage[2]) {
                stringBuffer.append(", Encryption");
            }
            if (this.keyUsage.length > 6 && (this.keyUsage[5] || this.keyUsage[6])) {
                stringBuffer.append(", Certificate Authority functions");
            }
            if (stringBuffer.length() > 2) {
                stringBuffer.delete(0, 2);
            }
            this.dumbString = stringBuffer.toString();
        }
        return this.dumbString;
    }
}

