/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.bh;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.certs.extensions.PolicyQualifierInfo;
import au.gov.bafcsi.clapi.certs.extensions.PolicyQualifiers;
import au.gov.bafcsi.clapi.certs.extensions.Qualifier;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PolicyInformation
extends az {
    public PolicyInformation() {
        this.a((ax)new bh(), "policyIdentifier");
        this.a((ax)new bm(new PolicyQualifiers()), "policyQualifiers");
    }

    public Oid getPolicyIdentifier() {
        return ((bh)this.a((String)"policyIdentifier")).a;
    }

    public PolicyQualifiers getPolicyQualifiers() {
        bm bm2 = (bm)this.a("policyQualifiers");
        if (!bm2.a) {
            return null;
        }
        return (PolicyQualifiers)bm2.getPrimitive();
    }

    public List getQualifiers(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("PolicyInformation.getQualifiers(Oid) - The supplied Oid is null.");
        }
        LinkedList<Qualifier> linkedList = new LinkedList<Qualifier>();
        PolicyQualifiers policyQualifiers = this.getPolicyQualifiers();
        Iterator iterator = policyQualifiers.a();
        while (iterator.hasNext()) {
            PolicyQualifierInfo policyQualifierInfo = (PolicyQualifierInfo)iterator.next();
            if (!policyQualifierInfo.getPolicyQualifierId().equals(oid)) continue;
            linkedList.add(policyQualifierInfo.getQualifier());
        }
        return linkedList;
    }

    public List getCPSuriQualifiers() {
        return this.getQualifiers(Oids.cpsUri);
    }

    public List getUserNoticeQualifiers() {
        return this.getQualifiers(Oids.userNotice);
    }

    public boolean hasPolicyIdentifier(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("PolicyInformation.hasPolicyIdentifier(Oid) - The supplied Oid is null.");
        }
        bh bh2 = (bh)this.a("policyIdentifier");
        return bh2.a.equals(oid);
    }

    public boolean hasSubordinatePolicyIdentifier(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("PolicyInformation.hasSubordinatePolicyIdentifier(Oid) - The supplied Oid is null.");
        }
        bh bh2 = (bh)this.a("policyIdentifier");
        return bh2.a.isASubOrdinateOf(oid);
    }
}

