/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.common;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.UnsupportedAlgorithmException;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.util.HashMap;

public class SignatureOid
extends Oid {
    private static HashMap SigtoDigestMapping = new HashMap(50);
    public static final SignatureOid MD2_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.2", DigestOid.MD2);
    public static final SignatureOid MD5_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.4", DigestOid.MD5);
    public static final SignatureOid SHA1_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.5", DigestOid.SHA1);
    public static final SignatureOid SHA256_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.11", DigestOid.SHA256);
    public static final SignatureOid SHA384_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.12", DigestOid.SHA384);
    public static final SignatureOid SHA512_WITH_RSA = new SignatureOid("1.2.840.113549.1.1.13", DigestOid.SHA512);
    public static final SignatureOid DSAANSI = new SignatureOid("1.2.840.10040.4.1", DigestOid.SHA1);
    public static final SignatureOid DSA_WITH_SHA1 = new SignatureOid("1.2.840.10040.4.3", DigestOid.SHA1);
    public static final SignatureOid ECDSA = new SignatureOid("1.2.840.10045.2.1", DigestOid.SHA1);
    public static final SignatureOid RSA_SIGNATURE = new SignatureOid("1.3.14.3.2.11", DigestOid.SHA1);
    public static final SignatureOid DSA = new SignatureOid("1.3.14.3.2.12", DigestOid.SHA1);
    public static final SignatureOid SHA_WITH_RSASIGNATURE = new SignatureOid("1.3.14.3.2.15", DigestOid.SHA1);
    public static final SignatureOid DSA_COMMON = new SignatureOid("1.3.14.3.2.20", DigestOid.SHA1);
    public static final SignatureOid DSA_COMMON_WITH_SHA = new SignatureOid("1.3.14.3.2.21", DigestOid.SHA1);
    public static final SignatureOid MD2_WITH_RSASIGNATURE = new SignatureOid("1.3.14.3.2.24", DigestOid.MD2);
    public static final SignatureOid MD5_WITH_RSASIGNATURE = new SignatureOid("1.3.14.3.2.25", DigestOid.MD5);
    public static final SignatureOid SHA1_WITH_RSASIGNATURE = new SignatureOid("1.3.14.3.2.29", DigestOid.SHA1);

    public SignatureOid(String string, DigestOid digestOid) {
        super(string);
        SignatureOid.addSigAlgToMDAlgMapping(string, digestOid);
    }

    public static DigestOid getDigestOid(String string) throws UnsupportedAlgorithmException {
        if (!Oid.validateOID(string)) {
            throw new UnsupportedAlgorithmException("Invalid signature oid " + string);
        }
        return SignatureOid.getMDOidMapping(string);
    }

    private static void addSigAlgToMDAlgMapping(String string, DigestOid digestOid) {
        if (string != null && string.length() != 0 && digestOid != null) {
            SigtoDigestMapping.put(string, digestOid);
        }
    }

    private static DigestOid getMDOidMapping(String string) {
        DigestOid digestOid = null;
        if (string != null && (digestOid = (DigestOid)SigtoDigestMapping.get(string)) == null) {
            r.a(w.i, "No OID mapping exists for the OID " + string + ".");
        }
        return digestOid;
    }
}

