/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.AbnDscSet;
import au.gov.bafcsi.clapi.crypto.CapiToken;
import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateFilter;
import au.gov.bafcsi.clapi.crypto.CertificateStoreType;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.crypto.ServerSidePasswordListener;
import au.gov.bafcsi.clapi.crypto.aa;
import au.gov.bafcsi.clapi.crypto.ab;
import au.gov.bafcsi.clapi.crypto.ac;
import au.gov.bafcsi.clapi.crypto.as;
import au.gov.bafcsi.clapi.crypto.ca;
import au.gov.bafcsi.clapi.crypto.ex;
import au.gov.bafcsi.clapi.crypto.z;
import au.gov.bafcsi.common.utils.base64.Base64;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.File;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class CertificateStore {
    private static CertificateStore m_certificateStore;

    private CertificateStore() {
    }

    public void setCertificateFilter(CertificateFilter certificateFilter) {
        z.a().d = certificateFilter;
    }

    public void deleteCertificateAndPrivateKey(CsiCertificate csiCertificate) throws ac {
        ab.a().b(csiCertificate);
        r.a(w.j, "Deleted the certificate belonging to " + ((Object)csiCertificate.getSubjectDN()).toString() + " via the method CertificateStore.deleteCertificateAndPrivateKey()");
    }

    public CertificateCollection getCertificateChain(CsiCertificate csiCertificate) {
        return z.a().a(csiCertificate);
    }

    public void registerStore(CertificateStoreType certificateStoreType) {
        z z2 = null;
        if (certificateStoreType != null) {
            z2 = z.a();
            try {
                z2.a(this.getToken(certificateStoreType));
            }
            catch (ac ac2) {
                r.a(w.h, "Could not register the token of type " + certificateStoreType.toString(), ac2);
            }
        }
    }

    public void unregisterStore(CertificateStoreType certificateStoreType) {
        z z2 = null;
        z2 = z.a();
        try {
            z2.b(this.getToken(certificateStoreType));
        }
        catch (ac ac2) {
            r.a(w.h, "Could not unregister the token of type " + certificateStoreType.toString(), ac2);
        }
    }

    public void secureStore() {
        z.a().f();
    }

    public void refreshStore() throws CertStoreException {
        try {
            z.b();
            z.a().d();
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to refresh the certificate stores.", ac2);
        }
    }

    private aa getToken(CertificateStoreType certificateStoreType) throws ac {
        aa aa2 = null;
        if (certificateStoreType == CertificateStoreType.CSI_STORE) {
            aa2 = ab.a();
        } else if (certificateStoreType == CertificateStoreType.CAPI_STORE) {
            aa2 = CapiToken.a();
        } else if (certificateStoreType == CertificateStoreType.PKCS11_STORE) {
            aa2 = as.a();
        } else if (certificateStoreType == CertificateStoreType.PKCS12_STORE) {
            aa2 = ca.a();
        }
        return aa2;
    }

    public void setServerSidePasswordListener(ServerSidePasswordListener serverSidePasswordListener) {
        ex.a(serverSidePasswordListener);
    }

    public boolean hasServerSidePasswordListener() {
        return ex.a();
    }

    public void setIgnoreBrokenAbnDscSets(boolean bl2) {
        z.a().a(bl2);
    }

    public static CertificateStore getInstance() {
        if (m_certificateStore == null) {
            m_certificateStore = new CertificateStore();
        }
        return m_certificateStore;
    }

    public boolean containsCertificate(CsiCertificate csiCertificate) throws CertStoreException {
        boolean bl2 = false;
        try {
            bl2 = z.a().d(csiCertificate);
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to check the certificate stores for the given certificate.", ac2);
        }
        return bl2;
    }

    public AbnDscSet getAbnDscCertificateSet(CsiCertificate csiCertificate) throws CertStoreException {
        AbnDscSet abnDscSet = null;
        try {
            abnDscSet = z.a().c(csiCertificate);
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get the ABN-DSC certificate set from the stores.", ac2);
        }
        return abnDscSet;
    }

    public AbnDscSet getAbnDscCertificateSet(String string) throws CertStoreException {
        AbnDscSet abnDscSet = null;
        try {
            abnDscSet = z.a().a(string);
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get the ABN-DSC certificate set from the stores.", ac2);
        }
        return abnDscSet;
    }

    public CertificateCollection getAllAuthenticationCertificates() throws CertStoreException {
        try {
            return z.a().g();
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get all authentication certificates from the stores.", ac2);
        }
    }

    public CertificateCollection getAllValidAuthenticationCertificates() throws CertStoreException {
        return this.getValidCerts(this.getAllAuthenticationCertificates());
    }

    public CertificateCollection getAllNonRepudiationCertificates() throws CertStoreException {
        try {
            return z.a().h();
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get all non-repudiation certificates from the stores.", ac2);
        }
    }

    public CertificateCollection getAllValidNonRepudiationCertificates() throws CertStoreException {
        return this.getValidCerts(this.getAllNonRepudiationCertificates());
    }

    public CertificateCollection getAllConfidentialityCertificates() throws CertStoreException {
        try {
            return z.a().i();
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get all confidentiality certificates from the stores.", ac2);
        }
    }

    public CertificateCollection getAllValidConfidentialityCertificates() throws CertStoreException {
        return this.getValidCerts(this.getAllConfidentialityCertificates());
    }

    public CertificateCollection getCertificates() throws CertStoreException {
        CertificateCollection certificateCollection;
        try {
            certificateCollection = z.a().c();
        }
        catch (ac ac2) {
            throw new CertStoreException("An unexpected TokenException occured while attempting to get all certificates from the stores.", ac2);
        }
        return certificateCollection;
    }

    public CertificateCollection getCertificates(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return z.a().a(bl2, bl3, bl4, bl5);
    }

    public CsiCertificate getCertificate(byte[] byArray, DigestOid digestOid) throws CertStoreException {
        byte[] byArray2 = null;
        CertificateCollection certificateCollection = this.getCertificates();
        Iterator iterator = certificateCollection.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            try {
                byArray2 = csiCertificate.getFingerprint(Oids.sha1);
                if (!Arrays.equals(byArray, byArray2)) continue;
                return csiCertificate;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                r.a(w.h, "Could not create the fingerprint of a certificate.", certificateEncodingException);
            }
        }
        return null;
    }

    public CsiCertificate getCertificate(byte[] byArray, DigestOid digestOid, CertificateStoreType certificateStoreType) throws CertStoreException {
        byte[] byArray2 = null;
        CertificateStoreType certificateStoreType2 = null;
        CertificateCollection certificateCollection = this.getCertificates();
        Iterator iterator = certificateCollection.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            try {
                byArray2 = csiCertificate.getFingerprint(Oids.sha1);
                certificateStoreType2 = csiCertificate.getStoreType();
                if (!Arrays.equals(byArray, byArray2) || !certificateStoreType.equals(certificateStoreType2)) continue;
                return csiCertificate;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                r.a(w.h, "Could not create the fingerprint of a certificate.", certificateEncodingException);
            }
        }
        return null;
    }

    public CsiCertificate getMatchingConfidentialityCertificate(CsiCertificate csiCertificate) throws CertStoreException {
        if (csiCertificate.canDoEncryption()) {
            return csiCertificate;
        }
        return this.findMySibling(csiCertificate, this.getAllConfidentialityCertificates());
    }

    private CsiCertificate findMySibling(CsiCertificate csiCertificate, CertificateCollection certificateCollection) {
        CertificateCollection certificateCollection2 = certificateCollection.filterOnAbn(csiCertificate.getAbn());
        if (certificateCollection2.isEmpty()) {
            return null;
        }
        return this.findMySibling(csiCertificate, certificateCollection2.getInternalCollection());
    }

    private CsiCertificate findMySibling(CsiCertificate csiCertificate, Collection collection) {
        if (collection.size() == 0) {
            return null;
        }
        Principal principal = csiCertificate.getSubjectDN();
        Principal principal2 = csiCertificate.getIssuerDN();
        CsiCertificate csiCertificate2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            long l10;
            CsiCertificate csiCertificate3 = (CsiCertificate)iterator.next();
            if (!((Object)principal).equals(csiCertificate3.getSubjectDN()) || !((Object)principal2).equals(csiCertificate3.getIssuerDN())) continue;
            if (csiCertificate2 == null) {
                csiCertificate2 = csiCertificate3;
                continue;
            }
            long l11 = csiCertificate.getNotAfter().getTime();
            long l12 = csiCertificate2.getNotAfter().getTime();
            long l13 = csiCertificate3.getNotAfter().getTime();
            long l14 = Math.abs(l12 - l11);
            csiCertificate2 = l14 < (l10 = Math.abs(l13 - l11)) ? csiCertificate2 : csiCertificate3;
        }
        if (csiCertificate2 != null) {
            collection.remove(csiCertificate2);
        }
        return csiCertificate2;
    }

    public CsiPrivateKey getPrivateKey(CsiCertificate csiCertificate) {
        CsiPrivateKey csiPrivateKey = null;
        csiPrivateKey = new CsiPrivateKey(csiCertificate);
        return csiPrivateKey;
    }

    public CsiCertificate getCertificate(String string, String string2) {
        throw new UnsupportedOperationException("CertificateStore.getCertificate() is not yet implemented.");
    }

    public CsiCertificate getCertificate(String string, DigestOid digestOid) throws CertStoreException {
        byte[] byArray = Base64.decode(string).getBytes();
        return this.getCertificate(byArray, digestOid);
    }

    public CsiCertificate getCertificate(String string, DigestOid digestOid, CertificateStoreType certificateStoreType) throws CertStoreException {
        byte[] byArray = Base64.decode(string).getBytes();
        return this.getCertificate(byArray, digestOid, certificateStoreType);
    }

    public CsiCertificate getCertificateForSignature(String string, CertificateStoreType certificateStoreType) throws CertStoreException {
        try {
            if (certificateStoreType == CertificateStoreType.CSI_STORE) {
                ab ab2 = (ab)this.getToken(CertificateStoreType.CSI_STORE);
                return ab2.b(string);
            }
            byte[] byArray = Base64.decode(string).getBytes();
            byte[] byArray2 = null;
            CertificateStoreType certificateStoreType2 = null;
            CertificateCollection certificateCollection = this.getCertificates();
            Iterator iterator = certificateCollection.iterator();
            while (iterator.hasNext()) {
                CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
                byArray2 = csiCertificate.getSignature();
                certificateStoreType2 = csiCertificate.getStoreType();
                if (!Arrays.equals(byArray, byArray2) || !certificateStoreType.equals(certificateStoreType2)) continue;
                return csiCertificate;
            }
            return null;
        }
        catch (ac ac2) {
            return null;
        }
    }

    private CertificateCollection getValidCerts(CertificateCollection certificateCollection) {
        CertificateCollection certificateCollection2 = new CertificateCollection();
        Iterator iterator = certificateCollection.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            try {
                csiCertificate.checkValidity();
                certificateCollection2.addCertificate(csiCertificate);
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {}
        }
        return certificateCollection2;
    }

    public void setPkcs12Directory(File file) throws ac {
        ca.a().a(file);
    }

    public File getPkcs12Directory() throws ac {
        return ca.a().b;
    }
}

