/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.certs.CsiX509Certificate;
import au.gov.bafcsi.clapi.certs.Name;
import au.gov.bafcsi.clapi.certs.extensions.AuthorityKeyIdentifier;
import au.gov.bafcsi.clapi.certs.extensions.CertificatePolicies;
import au.gov.bafcsi.clapi.certs.extensions.ExtendedKeyUsage;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.certs.extensions.SubjectAltName;
import au.gov.bafcsi.clapi.certs.extensions.SubjectKeyIdentifier;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertificateStoreType;
import au.gov.bafcsi.clapi.crypto.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.aa;
import au.gov.bafcsi.clapi.crypto.ac;
import au.gov.bafcsi.clapi.crypto.do;
import au.gov.bafcsi.clapi.crypto.ez;
import au.gov.bafcsi.clapi.crypto.y;
import au.gov.bafcsi.clapi.crypto.z;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CsiCertificate
extends X509Certificate
implements Comparable {
    static final String ABN_OID_FOR_ABNDSC = "1.2.36.1.333.1";
    static final String ABN_OID_FOR_ATO = "1.2.36.824753556.10000.1";
    private CertificateStoreType m_orginatingStoreId = null;
    private String m_originatingSubTokenName = null;
    private CertificatePolicies m_certificatePolicies = null;
    private y lightCert = null;
    private ez displayInfo = null;
    private HashMap subjectInfo = null;
    private HashMap issuerInfo = null;

    public CsiCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("CsiCertificate(X509Certificate) - The supplied X509Certificate is null.");
        }
        this.lightCert = x509Certificate instanceof y ? (y)x509Certificate : new y(x509Certificate);
        this.m_orginatingStoreId = CertificateStoreType.UNKNOWN_STORE;
    }

    public CsiCertificate(InputStream inputStream) throws CertificateEncodingException {
        this(new CsiX509Certificate(inputStream));
    }

    CsiCertificate(X509Certificate x509Certificate, CertificateStoreType certificateStoreType) {
        this(x509Certificate);
        this.m_orginatingStoreId = certificateStoreType;
    }

    CsiCertificate(X509Certificate x509Certificate, CertificateStoreType certificateStoreType, String string) {
        this(x509Certificate, certificateStoreType);
        this.m_originatingSubTokenName = string;
    }

    public CsiCertificate(X509Certificate x509Certificate, boolean bl2) {
        this(x509Certificate);
        if (bl2) {
            CertificateStoreType certificateStoreType = CertificateStoreType.UNKNOWN_STORE;
            try {
                aa aa2 = z.a().b(this);
                certificateStoreType = aa2.e();
            }
            catch (ac ac2) {
                String string = "CsiCertificate(X509Certificate, boolean): TokenException.\nThe originating error is: " + ac2.getMessage();
                r.a(w.f, string, ac2);
            }
            this.m_orginatingStoreId = certificateStoreType;
        }
    }

    private static Name createName(Principal principal) {
        Name name;
        if (principal instanceof Name) {
            return (Name)principal;
        }
        try {
            name = new Name(((Object)principal).toString());
        }
        catch (CertificateException certificateException) {
            String string = "Could not decode the principal value: " + ((Object)principal).toString() + " Will assume the certificate has an empty principal.";
            r.a(w.i, string, certificateException);
            name = new Name();
        }
        return name;
    }

    private static ExtendedKeyUsage createExtendedKeyUsage(X509Certificate x509Certificate) {
        ExtendedKeyUsage extendedKeyUsage;
        byte[] byArray = x509Certificate.getExtensionValue(Oids.extendedKeyUsage.getValue());
        if (byArray != null) {
            try {
                extendedKeyUsage = new ExtendedKeyUsage(new ByteArray(byArray));
            }
            catch (CertificateException certificateException) {
                String string = "There was a problem decoding the extended key usage from the certificate owned by: " + ((Object)x509Certificate.getSubjectDN()).toString() + ". Will assume that there is no extended key usage set" + " in the certificate.";
                r.a(w.i, string, certificateException);
                extendedKeyUsage = null;
            }
        } else {
            extendedKeyUsage = null;
        }
        return extendedKeyUsage;
    }

    public String getFingerprintAsBase64(DigestOid digestOid) throws CertificateEncodingException {
        byte[] byArray = null;
        ByteArray byteArray = null;
        byArray = this.getFingerprint(digestOid);
        try {
            byteArray = Base64.encode(new ByteArray(byArray));
        }
        catch (IOException iOException) {
            String string = "";
            string = "An error occured while attempting to base64 encode a fingerprint. This is a programming error. The originating error is " + iOException.toString();
            r.a(w.f, string, iOException);
            throw new RuntimeException(string);
        }
        return new String(byteArray.getBytes());
    }

    public byte[] getFingerprint(Oid oid) throws CertificateEncodingException {
        if (oid == null) {
            throw new IllegalArgumentException("CsiCertificate.getFingerprint(DigestOid): DigestOid is null");
        }
        if (oid.equals(Oids.sha1)) {
            return this.lightCert.g();
        }
        if (oid.equals(Oids.sha256)) {
            return this.lightCert.a(Oids.sha256);
        }
        if (oid.equals(Oids.md5)) {
            return this.lightCert.h();
        }
        String string = "";
        string = "The digest algoritm " + oid.toString() + " is not supported by the getFingerprint() method.";
        r.a(w.f, string);
        throw new UnsupportedAlgorithmException(string);
    }

    public CertificateStoreType getStoreType() {
        return this.m_orginatingStoreId;
    }

    public void setStoreType(CertificateStoreType certificateStoreType) {
        this.m_orginatingStoreId = certificateStoreType;
    }

    String getSubTokenName() {
        return this.m_originatingSubTokenName;
    }

    public void setSubTokenName(String string) {
        this.m_originatingSubTokenName = string;
    }

    int getKeyLength() {
        PublicKey publicKey = null;
        int n10 = 0;
        publicKey = this.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            n10 = do.a((RSAPublicKey)publicKey);
        } else if (publicKey instanceof DSAPublicKey) {
            n10 = (((DSAPublicKey)publicKey).getY().bitLength() + 7) / 8;
        } else {
            String string = "The algorithm " + publicKey.getAlgorithm() + " is not supported by the CSI certificate class." + " The private key class name is " + publicKey.getClass().getName() + ".";
            r.a(w.f, string);
            throw new UnsupportedAlgorithmException(string);
        }
        return n10;
    }

    public String getCertificateTypeString() {
        String string = null;
        if (this.isATOPrimaryCertificate()) {
            string = "ATO Primary";
        } else if (this.isATOSecondaryCertificate()) {
            string = "ATO Secondary";
        } else if (this.isIdentrusCertificate()) {
            string = "Identrus certificate";
        }
        return string;
    }

    public boolean isIdentrusCertificate() {
        return this.hasPolicyInformation(Oids.identrus);
    }

    private boolean isATOPrimaryCertificate() {
        return this.hasPolicyInformation(Oids.ATOPrimaryCertificateHolder);
    }

    private boolean isATOSecondaryCertificate() {
        return this.hasPolicyInformation(Oids.ATOSecondaryCertificateHolder);
    }

    public boolean canDoAuthenticationSigning() {
        KeyUsage keyUsage = this.lightCert.a();
        ExtendedKeyUsage extendedKeyUsage = this.lightCert.b();
        return keyUsage.hasUsage(0) && (extendedKeyUsage == null || extendedKeyUsage.canDoAuthenticationSigning());
    }

    public boolean canDoNonRepudiationSigning() {
        KeyUsage keyUsage = this.lightCert.a();
        ExtendedKeyUsage extendedKeyUsage = this.lightCert.b();
        return keyUsage.hasUsage(1) && (extendedKeyUsage == null || extendedKeyUsage.canDoNonRepudiationSigning());
    }

    public boolean canDoEncryption() {
        if (this.lightCert.getPublicKey() instanceof DSAPublicKey) {
            return false;
        }
        KeyUsage keyUsage = this.lightCert.a();
        ExtendedKeyUsage extendedKeyUsage = this.lightCert.b();
        return keyUsage.hasUsage(2) && (extendedKeyUsage == null || extendedKeyUsage.canDoEncryption());
    }

    public String getAbn() {
        return this.lightCert.e();
    }

    public String getCan() {
        return this.lightCert.f();
    }

    public ez getCertificateDisplayInfo() {
        if (this.displayInfo == null) {
            this.displayInfo = new ez(this);
        }
        return this.displayInfo;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.lightCert.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.lightCert.checkValidity(date);
    }

    public int getVersion() {
        return this.lightCert.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.lightCert.getSerialNumber();
    }

    public Principal getIssuerDN() {
        return this.lightCert.getIssuerDN();
    }

    public Principal getSubjectDN() {
        return this.lightCert.getSubjectDN();
    }

    public Date getNotBefore() {
        return this.lightCert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.lightCert.getNotAfter();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.lightCert.getTBSCertificate();
    }

    public byte[] getSignature() {
        return this.lightCert.getSignature();
    }

    public String getSigAlgName() {
        return this.lightCert.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.lightCert.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.lightCert.getSigAlgParams();
    }

    public boolean[] getIssuerUniqueID() {
        return this.lightCert.getIssuerUniqueID();
    }

    public boolean[] getSubjectUniqueID() {
        return this.lightCert.getSubjectUniqueID();
    }

    public boolean[] getKeyUsage() {
        boolean[] blArray = new boolean[]{true, true, true, true, true, true, true, true, true};
        boolean[] blArray2 = this.lightCert.getKeyUsage();
        if (blArray2 == null) {
            blArray2 = blArray;
        }
        return blArray2;
    }

    public int getBasicConstraints() {
        return this.lightCert.getBasicConstraints();
    }

    protected void removeSibling(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e10 = iterator.next();
            if (e10 == null || e10 != this) continue;
            iterator.remove();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            byte[] byArray;
            if (object instanceof CsiCertificate) {
                byArray = ((CsiCertificate)object).getFingerprint(Oids.sha1);
            } else if (object instanceof X509Certificate) {
                MessageDigest messageDigest = q.a(Oids.sha1);
                byArray = messageDigest.digest(((X509Certificate)object).getTBSCertificate());
            } else {
                return false;
            }
            return Arrays.equals(this.getFingerprint(Oids.sha1), byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public int hashCode() {
        return this.lightCert.hashCode();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.lightCert.getEncoded();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.lightCert.verify(publicKey);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.lightCert.verify(publicKey, string);
    }

    public String toString() {
        return this.lightCert.toString();
    }

    public PublicKey getPublicKey() {
        return this.lightCert.getPublicKey();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.lightCert.hasUnsupportedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        return this.lightCert.getCriticalExtensionOIDs();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.lightCert.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.lightCert.getExtensionValue(string);
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return p.a(this.lightCert);
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return p.a((X509Extension)this.lightCert);
    }

    public String getKeyUsageString() {
        return this.lightCert.a().toDumbString();
    }

    private void parseSubjectAndIssuer() {
        this.subjectInfo = new HashMap();
        Name name = this.lightCert.d();
        this.subjectInfo.put(Oids.commonName, this.getValueFromDistinguishedNamePair(name.toString(Oids.commonName)));
        this.subjectInfo.put(Oids.organizationalUnit, this.getValueFromDistinguishedNamePair(name.toString(Oids.organizationalUnit)));
        this.subjectInfo.put(Oids.organization, this.getValueFromDistinguishedNamePair(name.toString(Oids.organization)));
        this.subjectInfo.put(Oids.country, this.getValueFromDistinguishedNamePair(name.toString(Oids.country)));
        this.issuerInfo = new HashMap();
        Name name2 = this.lightCert.c();
        this.issuerInfo.put(Oids.commonName, this.getValueFromDistinguishedNamePair(name2.toString(Oids.commonName)));
        this.issuerInfo.put(Oids.organizationalUnit, this.getValueFromDistinguishedNamePair(name2.toString(Oids.organizationalUnit)));
        this.issuerInfo.put(Oids.organization, this.getValueFromDistinguishedNamePair(name2.toString(Oids.organization)));
        this.issuerInfo.put(Oids.country, this.getValueFromDistinguishedNamePair(name2.toString(Oids.country)));
    }

    private String getValueFromDistinguishedNamePair(String string) {
        String string2 = "";
        int n10 = 0;
        if (string == "") {
            string2 = "";
        } else {
            n10 = string.indexOf(61);
            if (n10 == -1) {
                string2 = string;
            } else {
                String string3 = string.substring(0, n10 + 1);
                StringBuffer stringBuffer = new StringBuffer(string);
                while (stringBuffer.toString().indexOf(string3) != -1) {
                    int n11;
                    int n12 = stringBuffer.toString().indexOf(string3);
                    int n13 = n12 + string3.length();
                    stringBuffer.delete(n12, n13);
                    if (n12 > 0 && stringBuffer.charAt(n12 - 1) == ',') {
                        stringBuffer.insert(n12, " ");
                    }
                    if (stringBuffer.charAt(n11 = ++n12) != '\"') continue;
                    stringBuffer.deleteCharAt(n11);
                    int n14 = stringBuffer.toString().indexOf(string3);
                    int n15 = n14 == -1 ? stringBuffer.length() - 1 : n14 - 2;
                    if (stringBuffer.charAt(n15) != '\"') continue;
                    stringBuffer.deleteCharAt(n15);
                }
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    public String getSubjectCommonName() {
        if (this.subjectInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.subjectInfo.get(Oids.commonName);
    }

    public String getSubjectOrganisationalUnit() {
        if (this.subjectInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.subjectInfo.get(Oids.organizationalUnit);
    }

    public String getSubjectOrganisation() {
        if (this.subjectInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.subjectInfo.get(Oids.organization);
    }

    public String getSubjectCountry() {
        if (this.subjectInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.subjectInfo.get(Oids.country);
    }

    public String getIssuerCommonName() {
        if (this.issuerInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.issuerInfo.get(Oids.commonName);
    }

    public String getIssuerOrganisationalUnit() {
        if (this.issuerInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.issuerInfo.get(Oids.organizationalUnit);
    }

    public String getIssuerOrganisation() {
        if (this.issuerInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.issuerInfo.get(Oids.organization);
    }

    public String getIssuerCountry() {
        if (this.issuerInfo == null) {
            this.parseSubjectAndIssuer();
        }
        return (String)this.issuerInfo.get(Oids.country);
    }

    public String[] getSubjectAltNameEmails() {
        SubjectAltName subjectAltName;
        byte[] byArray = this.getExtensionValue(Oids.subjectAltName.getValue());
        if (byArray == null) {
            return null;
        }
        try {
            subjectAltName = new SubjectAltName(new ByteArray(byArray));
        }
        catch (CertificateException certificateException) {
            r.a(w.i, "Bad SubjectAltName encoding", certificateException);
            return null;
        }
        String[] stringArray = subjectAltName.getRFC822Names();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public X509Certificate getX509Certificate() {
        return this.lightCert;
    }

    public int compareTo(Object object) {
        int n10;
        if (!CsiCertificate.class.isAssignableFrom(object.getClass())) {
            throw new ClassCastException("CsiCertificate.compareTo(): Cannot compare CsiCertificate to " + object.getClass().getName());
        }
        CsiCertificate csiCertificate = (CsiCertificate)object;
        if (this.equals(csiCertificate) && this.getStoreType().equals(csiCertificate.getStoreType())) {
            return 0;
        }
        String string = this.getStoreType().toString();
        String string2 = csiCertificate.getStoreType().toString();
        if (this.getStoreType().equals(CertificateStoreType.CSI_STORE)) {
            string = "AAA";
        }
        if (csiCertificate.getStoreType().equals(CertificateStoreType.CSI_STORE)) {
            string2 = "AAA";
        }
        if ((n10 = string.compareTo(string2)) != 0) {
            return n10;
        }
        n10 = this.getSubjectCommonName().compareTo(csiCertificate.getSubjectCommonName());
        if (n10 != 0) {
            return n10;
        }
        n10 = this.getIssuerCommonName().compareTo(csiCertificate.getIssuerCommonName());
        if (n10 != 0) {
            return n10;
        }
        String string3 = this.getAbn();
        String string4 = csiCertificate.getAbn();
        if (string3 == null) {
            string3 = "0";
        }
        if (string4 == null) {
            string4 = "0";
        }
        if ((n10 = string3.compareTo(string4)) != 0) {
            return n10;
        }
        n10 = this.getNotAfter().compareTo(csiCertificate.getNotAfter());
        if (n10 != 0) {
            return n10;
        }
        n10 = this.getKeyUsageString().compareTo(csiCertificate.getKeyUsageString());
        if (n10 != 0) {
            return n10;
        }
        n10 = this.toString().compareTo(csiCertificate.toString());
        return n10;
    }

    public String getAbnDscIdentifier() {
        StringBuffer stringBuffer = new StringBuffer("abn=" + this.getAbn());
        stringBuffer.append(",cn=" + this.getSubjectCommonName());
        stringBuffer.append(",ou=" + this.getSubjectOrganisationalUnit());
        stringBuffer.append(",o=" + this.getSubjectOrganisation());
        stringBuffer.append(",c=" + this.getSubjectCountry());
        stringBuffer.append(",issuer cn=" + this.getIssuerCommonName());
        stringBuffer.append(",ou=" + this.getIssuerOrganisationalUnit());
        stringBuffer.append(",o=" + this.getIssuerOrganisation());
        stringBuffer.append(",c=" + this.getIssuerCountry());
        return stringBuffer.toString();
    }

    public boolean isUserCertificate() {
        if (this.getVersion() != 3) {
            return false;
        }
        return this.getBasicConstraints() == -1;
    }

    public boolean isSelfSignedCertificate() {
        return ((Object)this.getIssuerDN()).equals(this.getSubjectDN());
    }

    public boolean hasMatchingPrivateKey(PrivateKey privateKey) {
        PublicKey publicKey = this.getPublicKey();
        if (!privateKey.getAlgorithm().equalsIgnoreCase(publicKey.getAlgorithm())) {
            return false;
        }
        if (privateKey instanceof RSAPrivateKey && publicKey instanceof RSAPublicKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            return rSAPublicKey.getModulus().equals(rSAPrivateKey.getModulus());
        }
        if (privateKey instanceof DSAPrivateKey && publicKey instanceof DSAPublicKey) {
            DSAParams dSAParams = ((DSAPrivateKey)privateKey).getParams();
            DSAParams dSAParams2 = ((DSAPublicKey)publicKey).getParams();
            return dSAParams.getG().equals(dSAParams2.getG()) && dSAParams.getP().equals(dSAParams2.getP()) && dSAParams.getQ().equals(dSAParams2.getQ());
        }
        r.a(w.i, "Key type (" + publicKey.getAlgorithm() + ") is not supported by the CSI.");
        return false;
    }

    protected boolean hasPolicyInformation(Oid oid) {
        if (this.m_certificatePolicies == null) {
            String string = Oids.certificatePolicies.getValue();
            byte[] byArray = this.lightCert.getExtensionValue(string);
            if (byArray == null) {
                return false;
            }
            try {
                this.m_certificatePolicies = new CertificatePolicies(new ByteArray(byArray));
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        return this.m_certificatePolicies.hasSubordinatePolicyInformation(oid);
    }
}

