/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.a3;
import au.gov.bafcsi.clapi.asn1.aw;
import au.gov.bafcsi.clapi.asn1.bn;
import au.gov.bafcsi.clapi.asn1.bv;
import au.gov.bafcsi.clapi.asn1.by;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.bx;
import au.gov.bafcsi.clapi.common.Attribute;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.crypto.DsaSignatureData;
import au.gov.bafcsi.clapi.crypto.NonRepudiationParameterSpec;
import au.gov.bafcsi.clapi.crypto.Pkcs1;
import au.gov.bafcsi.clapi.crypto.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.crypto.ab;
import au.gov.bafcsi.clapi.crypto.ac;
import au.gov.bafcsi.clapi.crypto.do;
import au.gov.bafcsi.clapi.crypto.ec;
import au.gov.bafcsi.clapi.crypto.fs;
import au.gov.bafcsi.clapi.crypto.z;
import au.gov.bafcsi.clapi.packaging.cms.full.ed;
import au.gov.bafcsi.clapi.packaging.xml.signature.fv;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;

abstract class CsiSignatureSpi
extends SignatureSpi {
    private MessageDigest m_messageDigest = null;
    private ed m_signingParams = null;
    private PrivateKey m_signingPrivateKey = null;
    private PublicKey m_publicKey = null;
    private ByteArray m_nonRepudiationData = null;
    private boolean m_isUpdateStarted = false;
    private ec m_nonRepudiationParams = null;

    protected CsiSignatureSpi(MessageDigest messageDigest) {
        this.m_messageDigest = messageDigest;
        this.resetSignature();
        this.appRandom = q.c();
    }

    private void updateNonRepudiationData(byte by2) {
        this.m_nonRepudiationData = this.appendData(this.m_nonRepudiationData, by2);
    }

    private void updateNonRepudiationData(byte[] byArray, int n10, int n11) {
        this.m_nonRepudiationData = this.appendData(this.m_nonRepudiationData, byArray, n10, n11);
    }

    private ByteArray appendData(ByteArray byteArray, byte[] byArray, int n10, int n11) {
        int n12 = 0;
        ByteArray byteArray2 = null;
        if (byteArray == null) {
            byteArray = new ByteArray(2048);
        }
        if ((n12 = byteArray.length() + n11) > byteArray.allocatedLength()) {
            byteArray2 = new ByteArray((int)((double)n12 * 1.6));
            byteArray2.append(byteArray.getBytes(), 0, byteArray.length());
            byteArray2.append(byArray, n10, n11);
        } else {
            byteArray2 = byteArray;
            byteArray2.append(byArray, n10, n11);
        }
        return byteArray2;
    }

    private ByteArray appendData(ByteArray byteArray, byte by2) {
        int n10 = 0;
        ByteArray byteArray2 = null;
        if (byteArray == null) {
            byteArray = new ByteArray(2048);
        }
        if ((n10 = byteArray.length() + 1) > byteArray.allocatedLength()) {
            byteArray2 = new ByteArray((int)((double)n10 * 1.6));
            byteArray2.append(byteArray.getBytes());
            byteArray2.append(by2);
        } else {
            byteArray2 = byteArray;
            byteArray2.append(by2);
        }
        return byteArray2;
    }

    private void resetSignature() {
        this.m_messageDigest.reset();
        this.m_signingParams = null;
        this.m_nonRepudiationData = null;
        this.m_nonRepudiationParams = null;
        this.m_isUpdateStarted = false;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("The privateKey variable is null.");
        }
        try {
            q.b(privateKey);
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            throw new InvalidKeyException(unsupportedAlgorithmException.getMessage());
        }
        this.m_signingPrivateKey = privateKey;
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        byte[] byArray = null;
        this.engineInitSign(privateKey);
        byArray = new byte[128];
        secureRandom.nextBytes(byArray);
        this.appRandom.setSeed(byArray);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("The publicKey variable is null.");
        }
        try {
            q.b(publicKey);
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            throw new InvalidKeyException(unsupportedAlgorithmException.getMessage());
        }
        this.m_publicKey = publicKey;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof ec) {
            if (this.m_isUpdateStarted) {
                throw new IllegalStateException("Cannot set the NonRepudiationParameterSpec after calling update methods.");
            }
            if (algorithmParameterSpec instanceof NonRepudiationParameterSpec) {
                this.m_nonRepudiationData = new ByteArray(2048);
            } else if (!(algorithmParameterSpec instanceof fv)) {
                throw new IllegalArgumentException("An invalid parameter spec was passed to the CSI Signature.");
            }
            this.m_nonRepudiationParams = (ec)((Object)algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof ed) {
            this.m_signingParams = (ed)algorithmParameterSpec;
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("This method has been deprecated in Java and is not supported in this api. Please use the method setParameter(AlgorithmParameterSpec params) instead.");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("This method has been deprecated in Java and is not supported in this api.");
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.m_signingPrivateKey == null) {
            throw new SignatureException("The signature engine has not been initialised for signing.");
        }
        boolean bl2 = this.m_nonRepudiationParams != null;
        CsiCertificate csiCertificate = null;
        if (this.m_signingPrivateKey instanceof CsiPrivateKey) {
            csiCertificate = ((CsiPrivateKey)this.m_signingPrivateKey).getAssociatedCertificate();
        }
        ByteArray byteArray = new ByteArray(this.m_messageDigest.digest());
        try {
            if (this.m_signingParams != null && this.m_signingParams.a != null) {
                object5 = new Attribute(Oids.messageDigest, new cf(byteArray));
                object4 = this.m_signingParams.a;
                ((Attributes)object4).removeAttribute(Oids.messageDigest);
                ((Attributes)object4).addAttribute((Attribute)object5);
                object3 = new bx();
                object2 = new by();
                ((bv)object2).a(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                ((bn)object3).c((aw)object2);
                object = new Attribute(Oids.signingTime, (aw)object3);
                ((Attributes)object4).addAttribute((Attribute)object);
                this.m_messageDigest.reset();
                this.m_messageDigest.update(((a3)object4).g().getBytes());
                byteArray = new ByteArray(this.m_messageDigest.digest());
            }
        }
        catch (IOException iOException) {
            String string = "";
            string = "CsiSignatureSpi.engineSign() - Failed while signing Attributes: " + iOException.getMessage();
            r.a(w.f, string, iOException);
            throw new SignatureException(string);
        }
        catch (CoderException coderException) {
            String string = "";
            string = "CsiSignatureSpi.engineSign() - Failed while signing Attributes: " + coderException.getMessage();
            r.a(w.f, string, coderException);
            throw new SignatureException(string);
        }
        this.m_messageDigest.reset();
        if (bl2 && !this.doesWysiwysInDriver()) {
            this.performWysiwys();
        }
        object5 = z.a();
        object4 = null;
        try {
            object4 = csiCertificate != null ? ((z)object5).a(csiCertificate, this.getDigestOid(), byteArray, bl2) : ab.a(this.m_signingPrivateKey, this.getDigestOid(), byteArray, bl2);
        }
        catch (ac ac2) {
            object2 = "The private key could not be accessed on the token. The orginating error is " + ac2.toString();
            r.a(w.f, (String)object2, ac2);
            throw new SignatureException((String)object2);
        }
        finally {
            this.resetSignature();
        }
        if (object4 == null) {
            object3 = "The private key could not be accessed. This is likely because the user cancelled out of entering their password.";
            r.a(w.j, (String)object3);
            throw new SignatureException((String)object3);
        }
        if (csiCertificate != null) {
            boolean bl3;
            object3 = csiCertificate.getPublicKey();
            if (object3.getAlgorithm().equalsIgnoreCase("RSA")) {
                bl3 = this.verifyRsaSignature(byteArray, (ByteArray)object4, (PublicKey)object3);
            } else if (object3.getAlgorithm().equalsIgnoreCase("DSA")) {
                bl3 = this.verifyDsaSignature(byteArray, (ByteArray)object4, (PublicKey)object3);
            } else {
                object = "";
                object = "An unsupported signing algoritm was found when attempting to verifiy a newly created signature. The unsupported algorithm is " + csiCertificate.getPublicKey().getAlgorithm();
                r.a(w.f, (String)object);
                throw new UnsupportedAlgorithmException((String)object);
            }
            if (!bl3) {
                object = "The signature returned from the token does not validate when compared with the calculated digest.";
                r.a(w.h, (String)object);
                throw new SignatureException((String)object);
            }
            object = s.a();
            ((s)object).a(csiCertificate, bl2);
        }
        return ((ByteArray)object4).toBytes();
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.m_isUpdateStarted = true;
        if (this.m_nonRepudiationData != null) {
            this.updateNonRepudiationData(by2);
        }
        this.m_messageDigest.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n10, int n11) throws SignatureException {
        this.m_isUpdateStarted = true;
        if (this.m_nonRepudiationData != null) {
            this.updateNonRepudiationData(byArray, n10, n11);
        }
        this.m_messageDigest.update(byArray, n10, n11);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        ByteArray byteArray = null;
        ByteArray byteArray2 = null;
        boolean bl2 = false;
        if (this.m_publicKey == null) {
            throw new SignatureException("The signature engine has not been initialised for verify.");
        }
        byteArray = new ByteArray(this.m_messageDigest.digest());
        byteArray2 = new ByteArray(byArray);
        if (this.m_publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            bl2 = this.verifyRsaSignature(byteArray, byteArray2, this.m_publicKey);
        } else if (this.m_publicKey.getAlgorithm().equalsIgnoreCase("DSA")) {
            bl2 = this.verifyDsaSignature(byteArray, byteArray2, this.m_publicKey);
        }
        return bl2;
    }

    protected abstract DigestOid getDigestOid();

    private void performWysiwys() throws UserCancelledSignatureException {
        Object object;
        boolean bl2 = false;
        if (this.m_nonRepudiationParams instanceof NonRepudiationParameterSpec) {
            object = new fs(this.m_nonRepudiationData.getDefensiveBytes(), this.m_nonRepudiationParams.getMimeType());
            bl2 = object.d;
        } else if (this.m_nonRepudiationParams instanceof fv) {
            object = ((fv)this.m_nonRepudiationParams).a();
            for (int i10 = 0; i10 < ((ByteArray[])object).length; ++i10) {
                fs fs2 = new fs(object[i10].getDefensiveBytes(), this.m_nonRepudiationParams.getMimeType());
                bl2 = fs2.d;
                if (bl2) {
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalStateException("The CsiSignatureSpi does not contain the correct AlgorithmParameterSpec.");
        }
        if (!bl2) {
            this.resetSignature();
            object = "The user cancelled WYSIWYS and hence the signature cannot be completed";
            throw new UserCancelledSignatureException((String)object);
        }
    }

    private boolean verifyRsaSignature(ByteArray byteArray, ByteArray byteArray2, PublicKey publicKey) throws SignatureException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        RSAPublicKey rSAPublicKey = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        boolean bl2 = false;
        rSAPublicKey = (RSAPublicKey)publicKey;
        bigInteger3 = rSAPublicKey.getModulus();
        bigInteger4 = rSAPublicKey.getPublicExponent();
        bigInteger = new BigInteger(1, byteArray2.toBytes());
        if (bigInteger.compareTo(BigInteger.ZERO) != 1 || bigInteger3.compareTo(BigInteger.ZERO) != 1 || bigInteger4.compareTo(BigInteger.ZERO) != 1) {
            throw new SignatureException("CsiSignatureSpi.verifyRsaSignature: Invalid parameter set.");
        }
        bigInteger2 = do.a(bigInteger, bigInteger3, bigInteger4);
        byte[] byArray = null;
        try {
            byArray = Pkcs1.extractDataFromPkcs1(bigInteger2);
            byte[] byArray2 = Pkcs1.createPkcs1SignatureData(this.getDigestOid(), byteArray);
            if (byArray2.length < 16) {
                throw new SignatureException("CsiSignatureSpi.verifyRsaSignature: Invalid internalSigData length.");
            }
            bl2 = Arrays.equals(byArray, byArray2);
        }
        catch (BadPaddingException badPaddingException) {
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        return this.verifyWithWorkAroundForTelstra(byteArray, byArray);
    }

    private boolean verifyWithWorkAroundForTelstra(ByteArray byteArray, byte[] byArray) {
        if (byArray == null || byteArray == null) {
            return false;
        }
        if (byArray.length != 20 && byArray.length != 16) {
            return false;
        }
        return Arrays.equals(byteArray.getDefensiveBytes(), byArray);
    }

    private boolean verifyDsaSignature(ByteArray byteArray, ByteArray byteArray2, PublicKey publicKey) throws SignatureException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: publicKey is not a DSA public key.");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        BigInteger bigInteger = dSAPublicKey.getY();
        if (bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: Public key y is invalid.");
        }
        DSAParams dSAParams = dSAPublicKey.getParams();
        BigInteger bigInteger2 = dSAParams.getG();
        BigInteger bigInteger3 = dSAParams.getP();
        BigInteger bigInteger4 = dSAParams.getQ();
        if (bigInteger2.compareTo(BigInteger.ZERO) != 1 || bigInteger3.compareTo(BigInteger.ZERO) != 1 || bigInteger4.compareTo(BigInteger.ZERO) != 1) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: Group parameters (g, p, q) are invalid.");
        }
        DsaSignatureData dsaSignatureData = new DsaSignatureData(byteArray2.toBytes());
        BigInteger bigInteger5 = dsaSignatureData.getR();
        BigInteger bigInteger6 = dsaSignatureData.getS();
        if (bigInteger5.compareTo(BigInteger.ZERO) != 1 || bigInteger5.compareTo(bigInteger4) != -1 || bigInteger6.compareTo(BigInteger.ZERO) != 1 || bigInteger6.compareTo(bigInteger4) != -1) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: Signature parameters (r, s) are invalid.");
        }
        BigInteger bigInteger7 = new BigInteger(1, byteArray.toBytes());
        if (bigInteger7.bitLength() > 160) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: Calculated digest is too long (" + bigInteger7.bitLength() + " bits).");
        }
        BigInteger bigInteger8 = bigInteger6.modInverse(bigInteger4);
        BigInteger bigInteger9 = bigInteger7.multiply(bigInteger8).mod(bigInteger4);
        BigInteger bigInteger10 = bigInteger5.multiply(bigInteger8).mod(bigInteger4);
        BigInteger bigInteger11 = bigInteger2.modPow(bigInteger9, bigInteger3);
        BigInteger bigInteger12 = bigInteger.modPow(bigInteger10, bigInteger3);
        BigInteger bigInteger13 = bigInteger11.multiply(bigInteger12).mod(bigInteger3).mod(bigInteger4);
        if (bigInteger8.compareTo(bigInteger4) != -1 || bigInteger13.compareTo(bigInteger4) != -1 || bigInteger9.compareTo(bigInteger4) != -1 || bigInteger10.compareTo(bigInteger4) != -1 || bigInteger11.compareTo(bigInteger3) != -1 || bigInteger12.compareTo(bigInteger3) != -1) {
            throw new SignatureException("CsiSignatureSpi.verifyDsaSignature: Invalid calculated parameter.");
        }
        return bigInteger13.equals(bigInteger5);
    }

    protected boolean doesWysiwysInDriver() {
        return false;
    }

    protected boolean isForcedSignatureOnDevice() throws SignatureException {
        boolean bl2 = false;
        CsiPrivateKey csiPrivateKey = null;
        if (this.m_publicKey == null) {
            if (this.m_signingPrivateKey == null) {
                throw new SignatureException("The private key has not been set before calling the isForcedSignatureOnDevice method.");
            }
            bl2 = this.m_signingPrivateKey instanceof CsiPrivateKey ? (csiPrivateKey = (CsiPrivateKey)this.m_signingPrivateKey).getAssociatedCertificate().isIdentrusCertificate() : false;
        } else {
            bl2 = false;
        }
        return bl2;
    }
}

