/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.crypto.PKCS11Exception;
import au.gov.bafcsi.clapi.crypto.PKCS11Slot;
import au.gov.bafcsi.clapi.crypto.as;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class PKCS11Module {
    private String pkcs11Library;
    private int moduleId;
    private List slots = new ArrayList();
    private static List modules = new Vector();

    private native int loadLibrary(String var1) throws PKCS11Exception;

    private native int getNumberOfSlots(int var1) throws PKCS11Exception;

    private native long waitForSlotEvent(int var1) throws PKCS11Exception;

    private native void refresh(int var1) throws PKCS11Exception;

    private PKCS11Module(String string) throws PKCS11Exception {
        if (string == null) {
            throw new IllegalArgumentException("PKCS11Module(String) - The supplied String is null.");
        }
        this.pkcs11Library = string;
        this.moduleId = this.loadLibrary(string);
        int n10 = this.getNumberOfSlots(this.moduleId);
        boolean bl2 = s.a().e(string);
        for (int i10 = 0; i10 < n10; ++i10) {
            PKCS11Slot pKCS11Slot = new PKCS11Slot(this, i10);
            try {
                pKCS11Slot.setCall2ndInit(bl2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                r.a(w.f, "PKCS11Module(): Error setting call 2nd init; Module:" + string, pKCS11Exception);
            }
            this.slots.add(pKCS11Slot);
        }
    }

    public static void addInstance(String string) throws PKCS11Exception {
        PKCS11Module.getInstance(string);
    }

    public static PKCS11Module getInstance(String string) throws PKCS11Exception {
        PKCS11Module pKCS11Module;
        if (string == null || string.equals("null")) {
            return null;
        }
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            pKCS11Module = (PKCS11Module)iterator.next();
            if (!pKCS11Module.getPKCS11Library().equals(string)) continue;
            return pKCS11Module;
        }
        pKCS11Module = new PKCS11Module(string);
        modules.add(pKCS11Module);
        return pKCS11Module;
    }

    public static int getNumberOfModules() {
        return modules.size();
    }

    public static PKCS11Module getModule(int n10) {
        if (n10 < 0 || n10 >= modules.size()) {
            throw new IndexOutOfBoundsException("PKCS11Module.getModule(int) - index " + p.a(n10, 0, modules.size() - 1));
        }
        return (PKCS11Module)modules.get(n10);
    }

    public static PKCS11Module getModuleWithID(int n10) throws PKCS11Exception {
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            PKCS11Module pKCS11Module = (PKCS11Module)iterator.next();
            if (pKCS11Module.getModuleID() != n10) continue;
            return pKCS11Module;
        }
        throw new PKCS11Exception("PKCS11Module.getModuleWithID(int) - A Module with ID '" + n10 + "' does not exist.");
    }

    public static void clearModules() {
        Iterator iterator = modules.iterator();
        while (iterator.hasNext()) {
            PKCS11Module pKCS11Module = (PKCS11Module)iterator.next();
            int n10 = pKCS11Module.getNumberOfSlots();
            if (n10 <= 0) continue;
            for (int i10 = 0; i10 < n10; ++i10) {
                try {
                    PKCS11Slot pKCS11Slot = pKCS11Module.getPKCS11Slot(i10);
                    if (!pKCS11Slot.getSessionOpened()) continue;
                    pKCS11Slot.logout();
                    pKCS11Slot.closeSession();
                    continue;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    pKCS11Exception.printStackTrace();
                }
            }
        }
        modules.clear();
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public int getModuleID() {
        return this.moduleId;
    }

    public int getNumberOfSlots() {
        return this.slots.size();
    }

    public long waitForSlotEvent() throws PKCS11Exception {
        return this.waitForSlotEvent(this.moduleId);
    }

    public void refresh() throws PKCS11Exception {
        this.slots.clear();
        this.refresh(this.moduleId);
        int n10 = this.getNumberOfSlots(this.moduleId);
        boolean bl2 = s.a().e(this.pkcs11Library);
        for (int i10 = 0; i10 < n10; ++i10) {
            PKCS11Slot pKCS11Slot = new PKCS11Slot(this, i10);
            try {
                pKCS11Slot.setCall2ndInit(bl2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                r.a(w.f, "PKCS11Module.refresh(): Error setting call 2nd init; Module:" + this.pkcs11Library, pKCS11Exception);
            }
            this.slots.add(pKCS11Slot);
        }
    }

    public PKCS11Slot getPKCS11Slot(int n10) {
        if (n10 < 0 || n10 > this.slots.size()) {
            throw new IndexOutOfBoundsException("PKCS11Module.getPKCS11Slot(int) - index " + p.a(n10, 0, this.slots.size() - 1));
        }
        return (PKCS11Slot)this.slots.get(n10);
    }

    private boolean getPkcs11Call2ndInit(String string) {
        String[][] stringArray = s.a().ak();
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (stringArray[i10].length <= 1 || !stringArray[i10][0].equalsIgnoreCase(string)) continue;
            return Boolean.valueOf(stringArray[i10][1]);
        }
        return false;
    }

    static {
        as.class.getClass();
    }
}

