/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.prng.CsiSecureRandom;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.math.BigInteger;
import javax.crypto.BadPaddingException;

final class Pkcs1 {
    private static byte[] SHA1_PKCS1_ID = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static byte[] MD5_PKCS1_ID = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static byte[] SHA256_PKCS1_ID = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final int BLOCK_TYPE_WITH_00_PADDING = 0;
    private static final int BLOCK_TYPE_WITH_FF_PADDING = 1;
    private static final int BLOCK_TYPE_WITH_RANDOM_PADDING = 2;

    private Pkcs1() {
    }

    static ByteArray makePKCS1ForSignature(DigestOid digestOid, ByteArray byteArray, int n10) {
        byte[] byArray = Pkcs1.createPkcs1SignatureData(digestOid, byteArray);
        return Pkcs1.createPkcs1Packet(1, byArray, n10);
    }

    static ByteArray makePKCS1ForEncryption(byte[] byArray, int n10) {
        return Pkcs1.createPkcs1Packet(2, byArray, n10);
    }

    private static ByteArray createPkcs1Packet(int n10, byte[] byArray, int n11) {
        int n12;
        byte[] byArray2 = null;
        int n13 = 0;
        byArray2 = new byte[n11];
        n13 = n11 - 1 - 1 - 1 - byArray.length;
        if (n13 < 8) {
            throw new IllegalArgumentException("The PKCS#1 packet length is too short. The standard states that the PKCS#1 padding must be at least 8 bytes long but there is only room for " + n13 + " bytes.");
        }
        byArray2[1] = (byte)n10;
        switch (n10) {
            case 0: {
                break;
            }
            case 1: {
                for (n12 = 0; n12 < n13; ++n12) {
                    byArray2[2 + n12] = -1;
                }
                break;
            }
            case 2: {
                CsiSecureRandom csiSecureRandom = new CsiSecureRandom();
                byte[] byArray3 = null;
                byArray3 = new byte[1];
                for (int i10 = 0; i10 < n13; ++i10) {
                    do {
                        csiSecureRandom.nextBytes(byArray3);
                    } while (byArray3[0] == 0);
                    byArray2[2 + i10] = byArray3[0];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid block type. Block type was " + n10 + ".");
            }
        }
        n12 = n11 - byArray.length;
        System.arraycopy(byArray, 0, byArray2, n12, byArray.length);
        return new ByteArray(byArray2);
    }

    static byte[] extractDataFromPkcs1(BigInteger bigInteger) throws BadPaddingException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray2 = bigInteger.toByteArray();
        byArray = new byte[byArray2.length + 1];
        System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
        return Pkcs1.extractDataFromPkcs1(byArray);
    }

    static byte[] createPkcs1SignatureData(DigestOid digestOid, ByteArray byteArray) {
        byte[] byArray;
        if (digestOid.equals(Oids.nullDigest) && byteArray.length() > 20) {
            return byteArray.getBytes();
        }
        if (digestOid.equals(Oids.sha1) || digestOid.equals(Oids.nullDigest) && byteArray.length() == Oids.sha1.getDigestLength()) {
            byArray = SHA1_PKCS1_ID;
        } else if (digestOid.equals(Oids.md5) || digestOid.equals(Oids.nullDigest) && byteArray.length() == Oids.md5.getDigestLength()) {
            byArray = MD5_PKCS1_ID;
        } else if (digestOid.equals(Oids.sha256) || digestOid.equals(Oids.nullDigest) && byteArray.length() == Oids.sha256.getDigestLength()) {
            byArray = SHA256_PKCS1_ID;
        } else {
            throw new IllegalArgumentException("The digest algorithm identifier is not supported by this method.");
        }
        ByteArray byteArray2 = new ByteArray(byArray);
        byteArray2.append(byteArray);
        return byteArray2.getBytes();
    }

    static byte[] extractDataFromPkcs1(byte[] byArray) throws BadPaddingException {
        int n10 = 0;
        if (byArray.length < 3) {
            String string = "The PKCS#1 packet was too short. The length of the packet was " + byArray.length;
            r.a(w.i, string);
            throw new BadPaddingException(string);
        }
        byte by2 = byArray[1];
        block0 : switch (by2) {
            case 0: {
                int n11 = 2;
                while (true) {
                    if (byArray[n11] != 0) {
                        n10 = n11;
                        break block0;
                    }
                    ++n11;
                }
            }
            case 1: 
            case 2: {
                int n11 = 2;
                while (true) {
                    if (byArray[n11] == 0) {
                        n10 = n11 + 1;
                        break block0;
                    }
                    ++n11;
                }
            }
            default: {
                String string = "The pkcs#1 block passed to this method contains an invalid block type. The invalid block type was " + by2 + ".";
                r.a(w.i, string);
                throw new BadPaddingException(string);
            }
        }
        byte[] byArray2 = new byte[byArray.length - n10];
        System.arraycopy(byArray, n10, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

