/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.prng.CsiSecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class SecretKeyMaterial {
    private Oid _alg = null;
    private SecretKey _key = null;
    private byte[] _IV = null;
    private boolean PBE = false;
    private PBEParameterSpec pbeParams = null;

    public static SecretKeyMaterial getInstance(Oid oid, SecretKey secretKey) {
        if (oid == null) {
            throw new IllegalArgumentException("SecretKeyMaterial(Oid,SecretKey) - Oid is null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("SecretKeyMaterial(Oid,SecretKey) - SecretKey is null.");
        }
        return new SecretKeyMaterial(oid, secretKey);
    }

    private SecretKeyMaterial(Oid oid, SecretKey secretKey) {
        this.PBE = oid.equals(Oids.pbeWithSHAAnd3_KeyTripleDES_CBC);
        if (!this.isValidCipherOID(oid)) {
            throw new IllegalArgumentException("SecretKeyMaterial(Oid,SecretKey) - Illegal algorithm Oid specified. Must be either Oids.tripleDesCBC, Oids.aes128, Oids.aes192 or Oids.aes256.");
        }
        this._alg = oid;
        this._key = secretKey;
        this._IV = oid.equals(Oids.tripleDesCBC) || oid.equals(Oids.pbeWithSHAAnd3_KeyTripleDES_CBC) ? new byte[8] : new byte[16];
        new CsiSecureRandom().nextBytes(this._IV);
    }

    public Oid getAlgorithmOID() {
        return this._alg;
    }

    public SecretKey getSecretKey() {
        return this._key;
    }

    public byte[] getInitialisationVector() {
        return this._IV;
    }

    public void setPBEParameters(PBEParameterSpec pBEParameterSpec, byte[] byArray) {
        if (this.PBE) {
            this.pbeParams = pBEParameterSpec;
            this._IV = byArray;
        }
    }

    public PBEParameterSpec getPBEParameters() {
        return this.PBE ? this.pbeParams : null;
    }

    private boolean isValidCipherOID(Oid oid) {
        return oid.equals(Oids.tripleDesCBC) || oid.equals(Oids.aes128CBC) || this.PBE && oid.equals(Oids.pbeWithSHAAnd3_KeyTripleDES_CBC);
    }
}

