/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.keygen;

import au.gov.bafcsi.clapi.asn1.a3;
import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.a8;
import au.gov.bafcsi.clapi.asn1.aw;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b0;
import au.gov.bafcsi.clapi.asn1.b1;
import au.gov.bafcsi.clapi.asn1.ba;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.br;
import au.gov.bafcsi.clapi.asn1.by;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.certs.CertificationRequest;
import au.gov.bafcsi.clapi.certs.CertificationRequestInfo;
import au.gov.bafcsi.clapi.certs.CsiX509Certificate;
import au.gov.bafcsi.clapi.certs.Extension;
import au.gov.bafcsi.clapi.certs.Extensions;
import au.gov.bafcsi.clapi.certs.GeneralNames;
import au.gov.bafcsi.clapi.certs.Name;
import au.gov.bafcsi.clapi.certs.bw;
import au.gov.bafcsi.clapi.certs.bx;
import au.gov.bafcsi.clapi.certs.ei;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attribute;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.InsertIdentity;
import au.gov.bafcsi.clapi.crypto.keygen.IdGenerationException;
import au.gov.bafcsi.clapi.crypto.keygen.InvalidPasswordException;
import au.gov.bafcsi.clapi.crypto.keygen.KeyProfile;
import au.gov.bafcsi.clapi.crypto.keygen.UserCancelledException;
import au.gov.bafcsi.clapi.crypto.keygen.f3;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Exception;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Exporter;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Importer;
import au.gov.bafcsi.clapi.pkcs12.fx;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.exceptions.LoggedException;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class IdGenerator {
    private KeyProfile[] m_profiles = null;
    private Name subject = null;
    private String email = null;
    private Extensions extns = null;
    private boolean requestsGenerated = false;
    private char[] m_importPassword = null;
    private File m_persistantFile = null;

    public IdGenerator(KeyProfile[] keyProfileArray, Name name, String string) {
        if (IdGenerator.hasNull(keyProfileArray)) {
            throw new IllegalArgumentException("IdGenerator(KeyProfile[], Name, String) - KeyProfile[] is null.");
        }
        if (keyProfileArray.length == 0) {
            throw new IllegalArgumentException("IdGenerator(KeyProfile[], Name, String) - KeyProfile[] is empty.");
        }
        if (keyProfileArray.length > 2) {
            throw new IllegalArgumentException("IdGenerator(KeyProfile[], Name, String) - KeyProfile[] contains more than two key pairs.");
        }
        if (name == null) {
            throw new IllegalArgumentException("IdGenerator(KeyProfile[], Name, String) - Name is null.");
        }
        if (string != null && string.indexOf("@") < 1) {
            throw new IllegalArgumentException("IdGenerator(KeyProfile[], Name, String) - String is not a valid email address.");
        }
        this.m_profiles = keyProfileArray;
        this.subject = name;
        this.email = string;
    }

    public IdGenerator(String string, String string2) throws LoggedException, InvalidPasswordException, UserCancelledException {
        this.m_persistantFile = new File(IdGenerator.getRequestCacheFolder(), string);
        Collection collection = this.openP12(this.m_persistantFile, string2).getIdentities();
        ArrayList<KeyProfile> arrayList = new ArrayList<KeyProfile>();
        CsiCertificate csiCertificate = null;
        Object object = collection.iterator();
        while (object.hasNext()) {
            fx fx2 = (fx)object.next();
            csiCertificate = fx2.b()[0];
            KeyUsage keyUsage = new KeyUsage(csiCertificate.getKeyUsage());
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)fx2.b;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)csiCertificate.getPublicKey();
            KeyProfile keyProfile = new KeyProfile(keyUsage, rSAPrivateKey, rSAPublicKey);
            arrayList.add(keyProfile);
        }
        if (csiCertificate == null) {
            object = "Could not retrieve from the stored request file: " + this.m_persistantFile.getAbsolutePath();
            r.a(w.h, (String)object);
            throw new LoggedException((String)object);
        }
        this.m_profiles = new KeyProfile[arrayList.size()];
        this.m_profiles = arrayList.toArray(this.m_profiles);
        this.requestsGenerated = true;
    }

    private static boolean hasNull(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (int i10 = 0; i10 < objectArray.length; ++i10) {
            if (objectArray[i10] != null) continue;
            return true;
        }
        return false;
    }

    public void setExtensions(Extensions extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("IdGenerator.setExtensions(Extensions) - The supplied Extensions is null.");
        }
        if (extensions.d() == 0) {
            throw new IllegalArgumentException("IdGenerator.setExtensions(Extensions) - The supplied Extensions is empty.");
        }
        this.extns = extensions;
    }

    public ByteArray[] generateRequests() throws CertificateException, CoderException {
        LinkedList<ByteArray> linkedList = new LinkedList<ByteArray>();
        for (int i10 = 0; i10 < this.m_profiles.length; ++i10) {
            br br2;
            a3 a32;
            KeyProfile keyProfile = this.m_profiles[i10];
            keyProfile.generateKeys();
            if (this.extns == null) {
                this.extns = new Extensions();
            } else {
                this.extns.removeExtension(Oids.keyUsage);
                this.extns.removeExtension(Oids.subjectAltName);
            }
            if (this.email != null) {
                a32 = new ei(this.email);
                br2 = new GeneralNames();
                br2.a(a32);
                this.extns.addExtension(new Extension((Oid)Oids.subjectAltName, false, br2));
            }
            if (keyProfile.getKeyUsage() != null) {
                this.extns.addExtension(new Extension((Oid)Oids.keyUsage, true, keyProfile.getKeyUsage()));
            }
            a32 = new Attribute(Oids.extensionRequest, this.extns);
            br2 = new Attributes((Attribute)a32);
            try {
                CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(this.subject, keyProfile.getPublicKeyInfo(), (Attributes)br2);
                CertificationRequest certificationRequest = new CertificationRequest(certificationRequestInfo, keyProfile.getPrivateKey());
                linkedList.add(certificationRequest.g());
                continue;
            }
            catch (IOException iOException) {
                throw new CertificateException("IdGenerator.generateRequests() - " + iOException.toString());
            }
        }
        this.requestsGenerated = true;
        ByteArray[] byteArrayArray = new ByteArray[linkedList.size()];
        byteArrayArray = linkedList.toArray(byteArrayArray);
        return byteArrayArray;
    }

    public void importIdentities(CertificateCollection[] certificateCollectionArray, String string) throws LoggedException, UserCancelledException {
        if (certificateCollectionArray == null) {
            throw new IllegalArgumentException("IdGenerator.importAllButThese(CertificateCollection[], String) - The supplied CertificateCollection[] is null.");
        }
        if (!this.requestsGenerated) {
            throw new IllegalStateException("The method generateRequests() must be called first.");
        }
        List list = this.constructedIds(certificateCollectionArray);
        if (list.size() > 0) {
            if (this.m_importPassword == null) {
                this.m_importPassword = this.getNewPassword(string, true);
            }
        } else {
            throw new LoggedException(w.h, "No certificates were imported by the IdGenerator.importAllButThese() method. This indicates that this method was called with an invalid certificateChains parameter.");
        }
        InsertIdentity.insert(list, new String(this.m_importPassword));
        CertificateStore.getInstance().refreshStore();
        if (this.m_persistantFile != null) {
            this.m_persistantFile.delete();
        }
    }

    public void importIdentities(CertificateCollection[] certificateCollectionArray, char[] cArray) throws LoggedException {
        if (certificateCollectionArray == null) {
            throw new IllegalArgumentException("IdGenerator.importAllButThese(CertificateCollection[], String) - The supplied CertificateCollection[] is null.");
        }
        if (!this.requestsGenerated) {
            throw new IllegalStateException("The method generateRequests() must be called first.");
        }
        List list = this.constructedIds(certificateCollectionArray);
        if (list.size() <= 0) {
            throw new LoggedException(w.h, "No certificates were imported by the IdGenerator.importAllButThese() method. This indicates that this method was called with an invalid  certificateChains parameter.");
        }
        InsertIdentity.insert(list, new String(cArray));
        CertificateStore.getInstance().refreshStore();
        if (this.m_persistantFile != null) {
            this.m_persistantFile.delete();
        }
    }

    public void exportAsPkcs12(CertificateCollection[] certificateCollectionArray, char[] cArray, OutputStream outputStream) throws LoggedException {
        if (certificateCollectionArray == null) {
            throw new IllegalArgumentException("IdGenerator.importAllButThese(CertificateCollection[], String) - The supplied CertificateCollection[] is null.");
        }
        if (!this.requestsGenerated) {
            throw new IllegalStateException("The method generateRequests() must be called first.");
        }
        List list = this.constructedIds(certificateCollectionArray);
        if (list.size() <= 0) {
            throw new LoggedException(w.h, "No certificates were exported by the IdGenerator.exportAsPkcs12() method. This indicates that this method was called with an invalid  certificateChains parameter.");
        }
        Pkcs12Exporter.save(outputStream, new String(cArray), (Collection)list);
        if (this.m_persistantFile != null) {
            this.m_persistantFile.delete();
        }
    }

    private List constructedIds(CertificateCollection[] certificateCollectionArray) throws LoggedException {
        if (certificateCollectionArray == null) {
            throw new IllegalArgumentException("IdGenerator.importAllButThese(CertificateCollection[], String) - The supplied CertificateCollection[] is null.");
        }
        if (!this.requestsGenerated) {
            throw new IllegalStateException("The method generateRequests() must be called first.");
        }
        ArrayList<fx> arrayList = new ArrayList<fx>(certificateCollectionArray.length);
        for (int i10 = 0; i10 < certificateCollectionArray.length; ++i10) {
            if (!certificateCollectionArray[i10].isCertificateChainValid()) {
                throw new LoggedException("The certificate chain number with index " + i10 + " was not valid.");
            }
            CsiCertificate csiCertificate = certificateCollectionArray[i10].getCertificate(0);
            for (int i11 = 0; i11 < this.m_profiles.length; ++i11) {
                try {
                    if (csiCertificate.getPublicKey().equals(this.m_profiles[i10].getPublicKeyInfo().getPublicKey())) {
                        fx fx2 = new fx(this.m_profiles[i10].getPrivateKey());
                        fx2.a(certificateCollectionArray[i10].getCertificate(0));
                        fx2.a(certificateCollectionArray[i10]);
                        arrayList.add(fx2);
                        continue;
                    }
                    r.a(w.i, "The user certificate " + ((Object)csiCertificate.getSubjectDN()).toString() + " did not match any of the generated keys" + " during IdGenerator.importAllButThese().");
                    continue;
                }
                catch (Exception exception) {
                    throw new LoggedException(w.g, "An unexpected problem occured while attempting to access the public key in the list of key profiles.", exception);
                }
            }
        }
        return arrayList;
    }

    public String persistIdentities(String string) throws LoggedException, UserCancelledException {
        fx[] fxArray;
        if (string == null) {
            throw new IllegalArgumentException("IdGenerator.persistIdentities(String) - The supplied String is null.");
        }
        try {
            fxArray = this.createSelfSignedIds();
        }
        catch (IdGenerationException idGenerationException) {
            throw new LoggedException(idGenerationException);
        }
        File file = this.getPersistFile();
        char[] cArray = this.getNewPassword(string, true);
        Pkcs12Exporter.save(file, new String(cArray), Arrays.asList(fxArray));
        return file.getName();
    }

    private synchronized char[] getNewPassword(String string, boolean bl2) throws UserCancelledException {
        this.m_importPassword = f3.a(bl2, string);
        if (this.m_importPassword == null) {
            throw new UserCancelledException("User cancelled during enter password dialog.");
        }
        return this.m_importPassword;
    }

    private Pkcs12Importer openP12(File file, String string) throws UserCancelledException, InvalidPasswordException {
        Pkcs12Importer pkcs12Importer;
        if (file == null) {
            throw new IllegalArgumentException("IdGenerator.openP12(File, String) - The supplied File is null.");
        }
        int n10 = 0;
        while (true) {
            char[] cArray = this.getNewPassword(string, false);
            try {
                pkcs12Importer = new Pkcs12Importer(file.getAbsolutePath(), new String(cArray));
            }
            catch (Pkcs12Exception pkcs12Exception) {
                r.a(w.j, "User entered incorrect password while attempting to recover persistant keys from a previous key generation session.", pkcs12Exception);
                f3.u();
                if (++n10 < 3) continue;
                throw new InvalidPasswordException("User entered the wrong password 3 times.");
            }
            break;
        }
        return pkcs12Importer;
    }

    private File getPersistFile() throws LoggedException {
        File file;
        File file2 = IdGenerator.getRequestCacheFolder();
        int n10 = 0;
        int n11 = this.subject.hashCode();
        do {
            file = new File(file2, n10 + 95 + n11 + ".csireq");
            ++n10;
        } while (file.exists());
        try {
            if (!file.createNewFile()) {
                throw new IOException("Could not create the file " + file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            String string = "Could not create the persistant file.";
            r.a(w.h, string, iOException);
            string = string + " The originating error is " + iOException.getMessage();
            throw new LoggedException(string, iOException);
        }
        return file;
    }

    private static File getRequestCacheFolder() throws LoggedException {
        File file = s.a().e().getParentFile();
        if (!(file = new File(file, "cachedCertRequests")).exists() && !file.mkdirs()) {
            r.a(w.h, "Could not create the persistant certificate request folder.");
            throw new LoggedException("Could not create the persistant certificate request folder.");
        }
        return file;
    }

    private fx[] createSelfSignedIds() throws IdGenerationException {
        LinkedList<fx> linkedList = new LinkedList<fx>();
        if (!this.requestsGenerated) {
            throw new IllegalStateException("IdGenerator.createSelfSignedIds() : You must create request before trying to create self-signed ids.");
        }
        try {
            for (int i10 = 0; i10 < this.m_profiles.length; ++i10) {
                KeyProfile keyProfile = this.m_profiles[i10];
                ByteArray byteArray = this.subject.g();
                Name name = new Name();
                name.a(byteArray);
                Name name2 = new Name();
                name2.a(byteArray);
                this.extns.removeExtension(Oids.keyUsage);
                if (keyProfile.getKeyUsage() != null) {
                    this.extns.addExtension(new Extension((Oid)Oids.keyUsage, true, keyProfile.getKeyUsage()));
                }
                az az2 = new az();
                az2.a((ax)new ba((aw)new a8(new a7(2L), 0), BigInteger.valueOf(0L)), "version");
                az2.a((ax)new a7(System.currentTimeMillis()), "serialNumber");
                az2.a((ax)new AlgorithmIdentifier((Oid)Oids.sha1WithRSAEncryption, new dn()), "signatureAlgorithm");
                az2.a((ax)name2, "issuer");
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.set(1, calendar.get(1) + 1);
                by by2 = new by(calendar);
                by by3 = new by(calendar2);
                az2.a((ax)new bw(new bx(by2), new bx(by3)), "validity");
                az2.a((ax)name, "subject");
                az2.a((ax)keyProfile.getPublicKeyInfo(), "subjectPublicKeyInfo");
                az2.a((ax)new bm(new b1(new b0(), 1), false), "issuerUniqueID");
                az2.a((ax)new bm(new b1(new b0(), 2), false), "subjectUniqueID");
                az2.a((ax)new bm(new a8(this.extns, 3)), "extensions");
                ByteArray byteArray2 = az2.g();
                Signature signature = q.d("SHA1withRSA");
                signature.initSign(keyProfile.getPrivateKey());
                signature.update(byteArray2.getBytes());
                byte[] byArray = signature.sign();
                az az3 = new az();
                az3.a((ax)az2, "a");
                az3.a((ax)new AlgorithmIdentifier((Oid)Oids.sha1WithRSAEncryption, new dn()), "b");
                az3.a((ax)new b0(new ByteArray(byArray), 0), "c");
                ByteArray byteArray3 = az3.g();
                CsiX509Certificate csiX509Certificate = new CsiX509Certificate();
                csiX509Certificate.decode(new ByteArrayInputStream(byteArray3.getBytes()));
                csiX509Certificate.verify(keyProfile.getPublicKeyInfo().getPublicKey());
                fx fx2 = new fx(keyProfile.getPrivateKey());
                fx2.a(new CsiCertificate(csiX509Certificate));
                linkedList.add(fx2);
            }
        }
        catch (Exception exception) {
            throw new IdGenerationException("IdGenerator.createSelfSignedIds()", exception);
        }
        fx[] fxArray = new fx[linkedList.size()];
        fxArray = linkedList.toArray(fxArray);
        return fxArray;
    }
}

