/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.di;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.g6;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class Rc2KeyFactory
extends g6 {
    final SecretKey parseSecretKey(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        if (!secretKeySpec.getAlgorithm().equalsIgnoreCase("RC2")) {
            throw new InvalidKeySpecException("The keySpec does not contain a recognised algoritm name. Expected algoritm name is RC2, the unrecognised algorithm name is " + secretKeySpec.getAlgorithm());
        }
        byte[] byArray = secretKeySpec.getEncoded();
        if (secretKeySpec.getEncoded().length > 128) {
            throw new InvalidKeySpecException("The keySpec contain too many bytes. The CSI RC2 cipher provider can only use a maximum of 128 bytes in its RC2 key. The passed in SecretKeySpec contains " + byArray.length + " bytes.");
        }
        di di2 = new di("RC2", byArray);
        return di2;
    }
}

