/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.di;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.g6;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TripleDesKeyFactory
extends g6 {
    private static final int KEY_BYTE_LENGTH = 24;

    final SecretKey parseSecretKey(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        di di2 = null;
        byte[] byArray = null;
        TripleDesKeyFactory.checkValidAlgorithmName(secretKeySpec);
        TripleDesKeyFactory.checkValidBitLength(secretKeySpec);
        if (secretKeySpec.getEncoded().length == 24) {
            byArray = secretKeySpec.getEncoded();
        } else {
            byArray = new byte[24];
            System.arraycopy(secretKeySpec.getEncoded(), 0, byArray, 0, 24);
        }
        di2 = new di("3DES", byArray);
        return di2;
    }

    private static void checkValidAlgorithmName(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        String[] stringArray = new String[]{"3DES", "DES3", "TRIPLEDES", "TRIPLE-DES", "DESEDE", "DES-EDE"};
        String string = "";
        boolean bl2 = false;
        string = secretKeySpec.getAlgorithm();
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (!string.toUpperCase().equals(stringArray[i10])) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new InvalidKeySpecException("The keySpec does not contain a recognised algoritm name. Expected algoritm name was 3DES, the unrecognised algorithm name was " + secretKeySpec.getAlgorithm());
        }
    }

    private static void checkValidBitLength(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        byte[] byArray = null;
        byArray = secretKeySpec.getEncoded();
        if (byArray.length < 24) {
            throw new InvalidKeySpecException("The keySpec does not contain enough encoding bits to create a triple DES key. The keySpec only contains " + byArray.length * 8);
        }
    }
}

