/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.bl;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.c9;
import au.gov.bafcsi.clapi.packaging.cms.full.OriginatorInfo;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.db;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;

public class EnvelopedCmsInputStream
extends c9 {
    private InputStream in = null;
    private cc contentInfo = null;
    private CsiCertificate decryptingCert = null;
    private InputStream contentStream = null;
    private db envelopedData = null;
    private boolean cancelled = false;

    public EnvelopedCmsInputStream(InputStream inputStream, CertificateCollection certificateCollection) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(InputStream,Collection) : InputStream is null.");
        }
        if (certificateCollection == null) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(InputStream,Collection) : CertificateCollection is null.");
        }
        if (certificateCollection.isEmpty()) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(InputStream,Collection) : CertificateCollection is empty.");
        }
        this.in = inputStream;
        this.contentInfo = new cc();
        try {
            this.contentInfo.decode(this.in);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot decode contentInfo.", coderException);
        }
        if (!this.contentInfo.j().equals(Oids.envelopedData)) {
            throw new PackagingException("EnvelopedCmsInputStream(InputStream,Collection) : ContentInfo does not contain an EnvelopedData.");
        }
        this.envelopedData = (db)this.contentInfo.k();
        try {
            this.decryptingCert = this.envelopedData.a(certificateCollection);
            if (this.decryptingCert == null) {
                throw new PackagingException(w.i, "You do not have the key required to decrypt this message.");
            }
        }
        catch (ClassCastException classCastException) {
            throw new PackagingException(w.f, "The Collection is supposed to contain CsiCertificate objects.");
        }
        this.contentStream = this.envelopedData.m();
    }

    public int read() throws IOException {
        try {
            return this.contentStream.read();
        }
        catch (bl bl2) {
            throw new PackagingException("Unable to read stream.");
        }
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        try {
            return this.contentStream.read(byArray, n10, n11);
        }
        catch (bl bl2) {
            throw new PackagingException("Unable to read stream.");
        }
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
            try {
                this.envelopedData.decodeFully();
            }
            catch (CoderException coderException) {
                throw new PackagingException("Unable to close stream.", coderException);
            }
        }
        this.contentStream = null;
        this.in.close();
    }

    public CsiCertificate getDecryptingCertificate() {
        return this.decryptingCert;
    }

    public int getVersion() {
        return this.envelopedData.h();
    }

    public Pkcs7DataOid getContentType() {
        return this.envelopedData.l();
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.envelopedData.q();
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.envelopedData.i();
    }

    public Attributes getUnprotectedAttributes() {
        return this.envelopedData.k();
    }

    public SecretKey getSecretKey() {
        return this.envelopedData.b;
    }

    public Oid getCipherOid() {
        return this.envelopedData.q().getAlgorithmOID();
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.in instanceof da) {
            ((da)((Object)this.in)).setCancelled();
        }
    }
}

