/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms.full;

import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.ContentOid;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.SignatureOid;
import au.gov.bafcsi.clapi.common.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.cms.full.CertificateSet;
import au.gov.bafcsi.clapi.packaging.cms.full.OriginatorInfo;
import au.gov.bafcsi.common.MimeType;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.util.Iterator;

public final class SigningParameters {
    private Oid contentType = Oids.data;
    private Oid digestAlg = Oids.sha1;
    private MimeType mimeType = MimeType.PLAIN_TEXT;
    private OriginatorInfo originator = null;
    private CsiCertificate certificate = null;
    private CsiCertificate encryptionCert = null;
    private Attributes toBeSignedAttrs = null;
    private Attributes toBeUnsignedAttrs = null;
    private boolean isNonRepudiationIntended = false;
    private boolean createDetachedSignature = false;
    private boolean createCertificatesOnly = false;

    public SigningParameters(CsiCertificate csiCertificate) throws CertStoreException {
        if (csiCertificate == null) {
            throw new IllegalArgumentException("SigningParameters(CsiCertificate) : CsiCertificate is null.");
        }
        KeyUsage keyUsage = new KeyUsage(csiCertificate.getKeyUsage());
        if (!keyUsage.hasUsage(0) && !keyUsage.hasUsage(1)) {
            throw new IllegalArgumentException("SigningParameters(CsiCertificate) : CsiCertificate does not permit signing.");
        }
        this.certificate = csiCertificate;
        try {
            this.digestAlg = SignatureOid.getDigestOid(this.certificate.getSigAlgOID());
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            r.a(w.f, unsupportedAlgorithmException.getMessage());
            throw new CertStoreException(unsupportedAlgorithmException.getMessage(), unsupportedAlgorithmException);
        }
        CertificateCollection certificateCollection = null;
        boolean bl2 = s.a().an();
        if (!bl2) {
            CertificateStore certificateStore = CertificateStore.getInstance();
            this.encryptionCert = certificateStore.getMatchingConfidentialityCertificate(csiCertificate);
            certificateCollection = certificateStore.getCertificateChain(csiCertificate);
            if (this.encryptionCert != null) {
                certificateCollection.addAll(certificateStore.getCertificateChain(this.encryptionCert));
            }
        } else {
            certificateCollection = new CertificateCollection();
            certificateCollection.addCertificate(csiCertificate);
        }
        if (certificateCollection != null && !certificateCollection.isEmpty()) {
            this.originator = new OriginatorInfo(new CertificateSet(certificateCollection), null);
        }
    }

    CsiCertificate getSigningCertificate() {
        return this.certificate;
    }

    CsiCertificate getEncryptionCertificate() {
        return this.encryptionCert;
    }

    public void setContentType(ContentOid contentOid) {
        if (contentOid == null) {
            throw new IllegalArgumentException("SigningParameters.setContentType(Pkcs7DataOid) : ContentOid is null.");
        }
        this.contentType = contentOid;
    }

    Oid getContentType() {
        return this.contentType;
    }

    public void setDigestAlgorithm(DigestOid digestOid) {
        if (digestOid == null) {
            throw new IllegalArgumentException("SigningParameters.setDigestAlgorithm(DigestOid) : DigestOid is null.");
        }
        if (!this.isValidDigestOID(digestOid)) {
            throw new IllegalArgumentException("SigningParameters.setDigestAlgorithm(DigestOid) : DigestOid specifies an unsupported digest algorithm.");
        }
        this.digestAlg = digestOid;
    }

    public Oid getDigestAlgorithm() {
        return this.digestAlg;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        CertificateSet certificateSet;
        if (originatorInfo != null && this.originator != null) {
            certificateSet = this.originator.getCertificates();
            CertificateCollection certificateCollection = originatorInfo.getCertificates().getCertificates();
            Iterator iterator = certificateCollection.iterator();
            while (iterator.hasNext()) {
                certificateSet.addCertificate((CsiCertificate)iterator.next());
            }
            this.originator = new OriginatorInfo(certificateSet, originatorInfo.getCRLs());
        }
        if (this.originator == null) {
            certificateSet = new CertificateSet();
            this.originator = new OriginatorInfo(certificateSet, null);
        }
    }

    OriginatorInfo getOriginatorInfo() {
        return this.originator;
    }

    public void setSignedAttributes(Attributes attributes) {
        if (attributes != null) {
            attributes.removeAttribute(Oids.contentType);
            attributes.removeAttribute(Oids.messageDigest);
            attributes.removeAttribute(Oids.signingTime);
            attributes.removeAttribute(Oids.smimeCapabilities);
            attributes.removeAttribute(Oids.smimeEncrypKeyPref);
            attributes.removeAttribute(Oids.csiSigningInformation);
            this.toBeSignedAttrs = attributes;
        } else {
            this.toBeSignedAttrs = new Attributes();
        }
    }

    protected void updateSignedAttributes(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("SigningParameters.updateSignedAttributes() - Signed attributes are null.");
        }
        if (attributes.getNumberOfAttributes() == 0) {
            throw new IllegalArgumentException("SigningParameters.updateSignedAttributes() - There are zero signed attributes.");
        }
        this.toBeSignedAttrs = attributes;
    }

    Attributes getSignedAttributes() {
        return this.toBeSignedAttrs == null ? new Attributes() : this.toBeSignedAttrs;
    }

    public void setUnsignedAttributes(Attributes attributes) {
        this.toBeUnsignedAttrs = attributes;
    }

    Attributes getUnsignedAttributes() {
        return this.toBeUnsignedAttrs;
    }

    public void setNonRepudiationIsIntended(boolean bl2) {
        KeyUsage keyUsage = new KeyUsage(this.certificate.getKeyUsage());
        if (bl2) {
            if (!keyUsage.hasUsage(1)) {
                throw new IllegalArgumentException("SigningParameters.setNonRepudiationIsIntended() : CsiPrivateKey does not permit NonRepudiation signing.");
            }
        } else if (!keyUsage.hasUsage(0)) {
            throw new IllegalArgumentException("SigningParameters.setNonRepudiationIsIntended() : CsiPrivateKey does not permit Authentication signing.");
        }
        this.isNonRepudiationIntended = bl2;
    }

    public boolean isNonRepudiationIntended() {
        return this.isNonRepudiationIntended;
    }

    public void setMimeType(MimeType mimeType) {
        if (mimeType == null) {
            this.mimeType = MimeType.PLAIN_TEXT;
        }
        this.mimeType = mimeType;
    }

    public void setDetachedSignature(boolean bl2) {
        this.createDetachedSignature = bl2;
    }

    public boolean shouldSignatureBeDetached() {
        return this.createDetachedSignature;
    }

    public void setCertificatesOnly(boolean bl2) {
        this.createCertificatesOnly = bl2;
    }

    public boolean shouldCreateCertificatesOnly() {
        return this.createCertificatesOnly;
    }

    MimeType getMimeType() {
        return this.mimeType;
    }

    boolean hasSignedAttributes() {
        return this.toBeSignedAttrs != null;
    }

    boolean hasUnsignedAttributes() {
        return this.toBeUnsignedAttrs != null;
    }

    boolean hasOriginatorInfo() {
        return this.originator != null;
    }

    private boolean isValidDigestOID(Oid oid) {
        return oid.equals(Oids.sha1) || oid.equals(Oids.md5);
    }
}

