/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.c9;
import au.gov.bafcsi.clapi.packaging.cms.EnvelopedCmsInputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.OriginatorInfo;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.clapi.packaging.smime.SMimeHeaders;
import au.gov.bafcsi.common.utils.base64.Base64InputStream;
import au.gov.bafcsi.common.utils.w;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;

public class EnvelopedSMimeInputStream
extends c9 {
    private EnvelopedCmsInputStream envelopedStream = null;
    private Base64InputStream decoderStream = null;

    public EnvelopedSMimeInputStream(SMimeHeaders sMimeHeaders, InputStream inputStream, CertificateCollection certificateCollection) throws IOException {
        if (sMimeHeaders == null) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(SMimeHeaders,InputStream,Collection) : SMimeHeaders is null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(SMimeHeaders,InputStream,Collection) : InputStream is null.");
        }
        if (certificateCollection == null) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(SMimeHeaders,InputStream,Collection) : CertificateCollection is null.");
        }
        if (certificateCollection.isEmpty()) {
            throw new IllegalArgumentException("EnvelopedCmsInputStream(SMimeHeaders,InputStream,Collection) : CertificateCollection is empty.");
        }
        if (sMimeHeaders.getMessageType() != 2 && sMimeHeaders.getMessageType() != 5) {
            throw new PackagingException(w.i, "This is not an enveloped S/MIME message.");
        }
        InputStream inputStream2 = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        this.envelopedStream = new EnvelopedCmsInputStream(new Base64InputStream(inputStream2), certificateCollection);
    }

    public int read() throws IOException {
        return this.envelopedStream.read();
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        return this.envelopedStream.read(byArray, n10, n11);
    }

    public void close() throws IOException {
        this.envelopedStream.close();
    }

    public CsiCertificate getDecryptingCertificate() {
        return this.envelopedStream.getDecryptingCertificate();
    }

    public int getVersion() {
        return this.envelopedStream.getVersion();
    }

    public Pkcs7DataOid getContentType() {
        return this.envelopedStream.getContentType();
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.envelopedStream.getEncryptionAlgorithm();
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.envelopedStream.getOriginatorInfo();
    }

    public Attributes getUnprotectedAttributes() {
        return this.envelopedStream.getUnprotectedAttributes();
    }

    public SecretKey getSecretKey() {
        return this.envelopedStream.getSecretKey();
    }

    public void setCancelled() {
        this.envelopedStream.setCancelled();
    }

    public Oid getCipherOid() {
        return this.envelopedStream.getCipherOid();
    }
}

