/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.packaging.cms.EnvelopedCmsOutputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.EnvelopingParameters;
import au.gov.bafcsi.clapi.packaging.dd;
import au.gov.bafcsi.common.utils.base64.Base64OutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;

public class EnvelopedSMimeOutputStream
extends dd {
    private EnvelopedCmsOutputStream envelopingStream = null;

    public EnvelopedSMimeOutputStream(OutputStream outputStream, EnvelopingParameters envelopingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("EnvelopedSMimeOutputStream(OutputStream, EnvelopingParameters) : OutputStream is null.");
        }
        if (envelopingParameters == null) {
            throw new IllegalArgumentException("EnvelopedSMimeOutputStream(OutputStream, EnvelopingParameters) : EnvelopingParameters is null.");
        }
        this.writeHeaders(outputStream);
        OutputStream outputStream2 = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        this.envelopingStream = new EnvelopedCmsOutputStream(new Base64OutputStream(outputStream2), envelopingParameters);
    }

    public void write(int n10) throws IOException {
        this.envelopingStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.envelopingStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        this.envelopingStream.close();
    }

    public SecretKey getSecretKey() {
        return this.envelopingStream.getSecretKey();
    }

    private void writeHeaders(OutputStream outputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Content-Type: application/pkcs7-mime; smime-type=enveloped-data; name=smime.p7m\r\n");
        stringBuffer.append("Content-Transfer-Encoding: base64\r\n");
        stringBuffer.append("Content-Disposition: attachment; filename=smime.p7m\r\n");
        stringBuffer.append("\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
    }

    public void setCancelled() {
        this.envelopingStream.setCancelled();
    }
}

