/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.cms.SignedCmsInputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.SignerInfo;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.clapi.packaging.smime.SMimeHeaders;
import au.gov.bafcsi.common.utils.base64.Base64InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;

public class SignedSMimeInputStream
extends SignedInputStream {
    private SignedCmsInputStream signedStream = null;
    private boolean isSignatureDetached = false;
    private boolean isCertsOnly = false;

    public SignedSMimeInputStream(SMimeHeaders sMimeHeaders, InputStream inputStream) throws IOException {
        if (sMimeHeaders == null) {
            throw new IllegalArgumentException("SignedSMimeInputStream(SMimeHeaders, InputStream) : SMimeHeaders is null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("SignedSMimeInputStream(SMimeHeaders, InputStream) : InputStream is null.");
        }
        if (sMimeHeaders.getMessageType() == 2 || sMimeHeaders.getMessageType() == 3) {
            throw new PackagingException("SignedSMimeInputStream(SMimeHeaders, InputStream) : This is not a signed S/MIME message.");
        }
        InputStream inputStream2 = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        this.signedStream = new SignedCmsInputStream(new Base64InputStream(inputStream2));
        this.isSignatureDetached = this.signedStream.isSignatureDetached();
        this.isCertsOnly = sMimeHeaders.getMessageType() == 4;
    }

    public int read() throws IOException {
        return this.signedStream.read();
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        return this.signedStream.read(byArray, n10, n11);
    }

    public void close() throws IOException {
        this.signedStream.close();
    }

    public CsiCertificate verify(CertificateCollection certificateCollection) throws IOException {
        return this.signedStream.verify(certificateCollection);
    }

    public int getVersion() {
        return this.signedStream.getVersion();
    }

    public Pkcs7DataOid getContentType() {
        return this.signedStream.getContentType();
    }

    public CertificateCollection getCertificates() {
        return this.signedStream.getCertificates();
    }

    public Collection getCRLs() {
        return this.signedStream.getCRLs();
    }

    public DigestOid getDigestAlgorithm() {
        return this.signedStream.getDigestAlgorithm();
    }

    public SignerInfo getSignerInfo(CsiCertificate csiCertificate) throws CertificateException {
        return this.signedStream.getSignerInfo(csiCertificate);
    }

    public boolean isSignatureDetached() {
        return this.isSignatureDetached;
    }

    public boolean isCertsOnly() {
        return this.isCertsOnly;
    }

    public void setDetachedDigesters(Collection collection) {
        this.signedStream.setDetachedDigesters(collection);
    }

    public void setDetachedData(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        this.signedStream.setDetachedData(inputStream);
    }

    public void setCancelled() {
        this.signedStream.setCancelled();
    }

    public boolean isNonRepudiationSigned(CsiCertificate csiCertificate) {
        return this.signedStream.isNonRepudiationSigned(csiCertificate);
    }
}

