/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml.xpath;

import au.gov.bafcsi.clapi.packaging.xml.XMLUtils;
import au.gov.bafcsi.clapi.packaging.xml.xpath.h9;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ib;
import au.gov.bafcsi.common.ByteArray;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathUtils {
    private XPathUtils() {
    }

    public static NodeList toXPathNodeSet(Node node, boolean bl2) throws ib {
        if (node == null) {
            throw new IllegalArgumentException("XPathUtils.toNodeSet(Node, boolean) - The supplied Node is null.");
        }
        h9 h92 = new h9();
        XPathUtils.toXPathNodeSet(node, bl2, h92);
        return h92;
    }

    private static void toXPathNodeSet(Node node, boolean bl2, h9 h92) throws ib {
        if (node == null) {
            throw new IllegalArgumentException("XPathUtils.toNodeSet(NNode, boolean, NodeSet) - The supplied Node is null.");
        }
        if (h92 == null) {
            throw new IllegalArgumentException("XPathUtils.toNodeSet(Node, boolean, NodeSet) - The supplied NodeSet is null.");
        }
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 1: {
                h92.a(node);
                Hashtable hashtable = XMLUtils.getNamespaceAttributesInAncestors(node);
                Object object = hashtable.elements();
                while (object.hasMoreElements()) {
                    Attr attr = (Attr)object.nextElement();
                    if (attr.getNodeName().equals("xmlns") && attr.getNodeValue().length() == 0) continue;
                    h92.a(attr);
                }
                object = node.getAttributes();
                for (int i10 = 0; i10 < object.getLength(); ++i10) {
                    Node node2 = object.item(i10);
                    if (node2.getNodeName().equals("xmlns") || node2.getNodeName().startsWith("xmlns:")) continue;
                    h92.a(node2);
                }
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    XPathUtils.toXPathNodeSet(node3, bl2, h92);
                }
                break;
            }
            case 5: {
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    XPathUtils.toXPathNodeSet(node4, bl2, h92);
                }
                break;
            }
            case 8: {
                if (!bl2) break;
                h92.a(node);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                h92.a(node);
                break;
            }
            case 9: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    XPathUtils.toXPathNodeSet(node5, bl2, h92);
                }
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new ib("XPathUtils.toNodeSet(Node, boolean, NodeSet) - Invalid Node type '" + node.getNodeType() + "'");
            }
        }
    }

    public static ByteArray toByteArray(NodeList nodeList) {
        if (nodeList == null) {
            throw new IllegalArgumentException("XPathUtils.toByteArray(NodeList) - The supplied NodeList is null.");
        }
        ByteArray byteArray = new ByteArray();
        byteArray.append(("Number of Items = " + nodeList.getLength() + "\r\n").getBytes());
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            Node node = nodeList.item(i10);
            byteArray.append((node.toString() + "\r\n").getBytes());
        }
        return byteArray;
    }
}

