/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common;

import au.gov.bafcsi.common.utils.p;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public final class ByteArray
implements Comparable,
Serializable {
    public static final ByteArray emptyArray = new ByteArray();
    private byte[] bytes;
    private int usedLength;

    public ByteArray() {
        this.bytes = new byte[0];
        this.usedLength = 0;
    }

    public ByteArray(byte[] byArray) {
        if (byArray != null) {
            this.bytes = new byte[byArray.length];
            this.usedLength = 0;
            this.append(byArray);
        } else {
            this.bytes = new byte[0];
            this.usedLength = 0;
        }
    }

    public ByteArray(byte[] byArray, boolean bl2) {
        if (bl2) {
            this.bytes = new byte[0];
            this.usedLength = 0;
            this.append(byArray);
        } else if (byArray != null) {
            this.bytes = byArray;
            this.usedLength = byArray.length;
        } else {
            this.bytes = new byte[0];
            this.usedLength = 0;
        }
    }

    public ByteArray(byte[] byArray, int n10, int n11) {
        if (byArray != null) {
            ByteArray.checkBounds(byArray, n10, n11);
            this.bytes = new byte[n11];
            this.usedLength = 0;
            this.append(byArray, n10, n11);
        } else {
            this.bytes = new byte[0];
            this.usedLength = 0;
        }
    }

    public ByteArray(byte by2) {
        this.bytes = new byte[1];
        this.bytes[0] = by2;
        this.usedLength = 1;
    }

    public ByteArray(int n10) {
        if (n10 < 0) {
            throw new IllegalArgumentException("ByteArray(int) - The length parameter must be >= 0");
        }
        this.bytes = new byte[n10];
        this.usedLength = 0;
    }

    public ByteArray(InputStream inputStream) throws IOException {
        int n10;
        if (inputStream == null) {
            throw new IllegalArgumentException("ByteArray(InputStream) - The supplied InputStream is null.");
        }
        this.bytes = new byte[0];
        this.usedLength = 0;
        byte[] byArray = new byte[1024];
        while ((n10 = inputStream.read(byArray)) != -1) {
            this.append(byArray, 0, n10);
        }
    }

    public void append(byte by2) {
        int n10 = this.usedLength + 1;
        if (n10 <= this.bytes.length) {
            this.bytes[this.usedLength] = by2;
            this.usedLength = n10;
        } else {
            byte[] byArray = new byte[n10];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            byArray[this.usedLength] = by2;
            this.bytes = byArray;
            this.usedLength = n10;
        }
    }

    public void append(ByteArray byteArray) {
        if (byteArray == null) {
            return;
        }
        this.append(byteArray.getBytes(), 0, byteArray.length());
    }

    public void append(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.append(byArray, 0, byArray.length);
    }

    public void append(byte[] byArray, int n10, int n11) {
        if (byArray == null) {
            return;
        }
        ByteArray.checkBounds(byArray, n10, n11);
        int n12 = this.usedLength + n11;
        if (this.bytes.length >= n12) {
            System.arraycopy(byArray, n10, this.bytes, this.usedLength, n11);
            this.usedLength = n12;
        } else {
            byte[] byArray2 = new byte[n12];
            System.arraycopy(this.bytes, 0, byArray2, 0, this.usedLength);
            System.arraycopy(byArray, n10, byArray2, this.usedLength, n11);
            this.bytes = byArray2;
            this.usedLength = n12;
        }
    }

    public void prepend(byte by2) {
        int n10 = this.usedLength;
        this.append((byte)0);
        for (int i10 = n10; i10 >= 1; --i10) {
            this.bytes[i10] = this.bytes[i10 - 1];
        }
        this.bytes[0] = by2;
    }

    public void replace(ByteArray byteArray) {
        if (byteArray == null) {
            this.usedLength = 0;
        } else {
            this.replace(byteArray.getBytes(), 0, byteArray.length());
        }
    }

    public void replace(byte[] byArray) {
        if (byArray == null) {
            this.usedLength = 0;
        } else {
            this.replace(byArray, 0, byArray.length);
        }
    }

    public void replace(byte[] byArray, int n10, int n11) {
        if (byArray == null) {
            this.usedLength = 0;
            return;
        }
        ByteArray.checkBounds(byArray, n10, n11);
        this.usedLength = 0;
        this.append(byArray, n10, n11);
    }

    public ByteArray subbytes(int n10) {
        return this.subbytes(n10, this.length());
    }

    public ByteArray subbytes(int n10, int n11) {
        if (n10 < 0) {
            throw new IndexOutOfBoundsException("ByteArray.subbytes(int, int) - beginIndex " + p.a(n10, 0, this.bytes.length - 1));
        }
        if (n11 > this.usedLength) {
            throw new IndexOutOfBoundsException("ByteArray.subbytes(int, int) - endIndex " + p.a(n11, 0, this.bytes.length - 1));
        }
        if (n10 > n11) {
            throw new IndexOutOfBoundsException("ByteArray.subbytes(int, int) - beginIndex > endIndex.");
        }
        return n10 == 0 && n11 == this.usedLength ? this : new ByteArray(this.bytes, n10, n11 - n10);
    }

    public void reverse() {
        int n10 = this.usedLength >> 1;
        for (int i10 = 0; i10 < n10; ++i10) {
            byte by2 = this.bytes[this.usedLength - i10 - 1];
            this.bytes[this.usedLength - i10 - 1] = this.bytes[i10];
            this.bytes[i10] = by2;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public int getLength() {
        return this.length();
    }

    public byte[] getDefensiveBytes() {
        byte[] byArray = new byte[this.usedLength];
        System.arraycopy(this.bytes, 0, byArray, 0, this.usedLength);
        return byArray;
    }

    public int allocatedLength() {
        return this.bytes.length;
    }

    public int length() {
        return this.usedLength;
    }

    public void reset() {
        this.usedLength = 0;
    }

    public int compareTo(Object object) {
        ByteArray byteArray = (ByteArray)object;
        if (this.equals(byteArray)) {
            return 0;
        }
        if (this.lessThan(byteArray)) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return new String(this.bytes, 0, this.usedLength);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.bytes, 0, this.usedLength, string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteArray)) {
            return false;
        }
        ByteArray byteArray = (ByteArray)object;
        if (this.length() != byteArray.length()) {
            return false;
        }
        return p.a(this.getBytes(), 0, byteArray.getBytes(), 0, this.length());
    }

    public boolean equals(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        if (this.length() != byArray.length) {
            return false;
        }
        return p.a(this.getBytes(), 0, byArray, 0, this.length());
    }

    public boolean lessThan(ByteArray byteArray) {
        int n10 = Math.min(this.length(), byteArray.length());
        byte[] byArray = byteArray.getBytes();
        for (int i10 = 0; i10 < n10; ++i10) {
            int n11;
            int n12 = Math.abs(this.bytes[i10]);
            if (n12 < (n11 = Math.abs(byArray[i10]))) {
                return true;
            }
            if (n12 <= n11) continue;
            return false;
        }
        return this.length() < byteArray.length();
    }

    public String toHexString() {
        return p.a(this);
    }

    public int hashCode() {
        int n10 = 0;
        for (int i10 = 0; i10 < this.usedLength; ++i10) {
            n10 = 31 * n10 + this.bytes[i10];
        }
        return n10;
    }

    public byte byteAt(int n10) {
        ByteArray.checkBounds(this.bytes, n10, 0);
        return this.bytes[n10];
    }

    public static ByteArray fromHexString(String string) {
        return p.a(string);
    }

    private static void checkBounds(byte[] byArray, int n10, int n11) {
        if (n11 < 0) {
            throw new IndexOutOfBoundsException("ByteArray.checkBounds(byte[], int, int) - count " + p.a(n11, 0, byArray.length - 1));
        }
        if (n10 < 0) {
            throw new IndexOutOfBoundsException("ByteArray.checkBounds(byte[], int, int) - offset " + p.a(n10, 0, byArray.length - 1));
        }
        if (n10 > byArray.length - n11) {
            throw new IndexOutOfBoundsException("ByteArray.checkBounds(byte[], int, int) - offset + count " + p.a(n10 + n11, 0, byArray.length - 1));
        }
    }
}

