/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common;

import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiManager;
import au.gov.bafcsi.clapi.crypto.e4;
import au.gov.bafcsi.clapi.crypto.e5;
import au.gov.bafcsi.clapi.crypto.fi;
import au.gov.bafcsi.clapi.crypto.i3;
import au.gov.bafcsi.clapi.crypto.iw;
import au.gov.bafcsi.common.CertSelectTable;
import au.gov.bafcsi.common.SelectCertificateFrame;
import au.gov.bafcsi.common.i2;
import au.gov.bafcsi.common.i4;
import au.gov.bafcsi.common.i5;
import au.gov.bafcsi.common.i6;
import au.gov.bafcsi.common.i7;
import au.gov.bafcsi.common.utils.HelpViewer;
import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.af;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import au.gov.bafcsi.ui.jd;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;

final class CertSelectGui
extends af {
    private JLabel m_messageLabel;
    private JButton m_selectButton;
    private JButton m_cancelButton;
    private JButton m_detailButton;
    private JButton m_refreshButton;
    private JButton m_managementUtilityButton;
    private JButton m_helpButton;
    private CertSelectTable m_table = null;
    private e4 m_tableModel;
    private ListSelectionModel m_rowSM;
    private List certGroups;
    private boolean m_isNonRepudiation;
    private String m_abnFilter;
    private int m_selection;
    private int m_certsInList = -1;
    private e5 m_tableSorter;

    CertSelectGui(boolean bl2, String string) {
        super("Digital certificate selection");
        this.m_isNonRepudiation = bl2;
        this.m_abnFilter = string;
        this.init();
    }

    private void init() {
        this.refresh();
        i2 i22 = new i2(this);
        this.m_messageLabel = new JLabel("");
        this.m_messageLabel.setLabelFor(this.m_table);
        this.m_tableModel = new i3(this.certGroups);
        this.m_tableSorter = new e5(this.m_tableModel);
        this.m_table = new CertSelectTable(this.m_tableSorter);
        this.m_tableSorter.a(this.m_table.getTableHeader());
        this.m_tableModel.a(this.m_table.getColumnModel());
        this.m_table.registerKeyboardAction(i22, KeyStroke.getKeyStroke(10, 0), 0);
        this.m_table.setAutoResizeMode(0);
        this.m_rowSM = this.m_table.getSelectionModel();
        this.m_rowSM.setSelectionMode(0);
        this.m_rowSM.addListSelectionListener(new i4(this));
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        this.m_selectButton = new JButton("Select");
        this.m_selectButton.setMnemonic(83);
        this.m_selectButton.setToolTipText("Select certificate");
        this.m_selectButton.addActionListener(i22);
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setMnemonic(67);
        this.m_cancelButton.setToolTipText("Cancel");
        this.m_cancelButton.addActionListener(i22);
        this.m_refreshButton = new JButton("Refresh");
        this.m_refreshButton.setMnemonic(82);
        this.m_refreshButton.setToolTipText("Refresh List");
        this.m_refreshButton.addActionListener(i22);
        this.m_detailButton = new JButton("Details...");
        this.m_detailButton.setMnemonic(68);
        this.m_detailButton.setToolTipText("Show certificate details");
        this.m_detailButton.addActionListener(i22);
        this.m_managementUtilityButton = new JButton("Manage...");
        this.m_managementUtilityButton.setMnemonic(77);
        this.m_managementUtilityButton.setToolTipText("Manage digital certificates");
        this.m_managementUtilityButton.addActionListener(i22);
        this.m_helpButton = new JButton("Help");
        this.m_helpButton.setMnemonic(72);
        this.m_helpButton.setToolTipText("Show help information");
        this.m_helpButton.addActionListener(i22);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.m_selectButton);
        jPanel.add(this.m_cancelButton);
        jPanel.add(this.m_refreshButton);
        jPanel.add(this.m_detailButton);
        jPanel.add(this.m_managementUtilityButton);
        jPanel.add(this.m_helpButton);
        this.m_table.addKeyListener(new i5(this));
        this.m_table.addMouseListener(new i6(this));
        this.m().setLayout(new BorderLayout());
        this.m().add((Component)this.m_messageLabel, "North");
        this.m().add((Component)jScrollPane, "Center");
        this.m().add((Component)jPanel, "South");
        this.a(new i7(this));
        this.setButtonEnablement(true);
    }

    private void doButtonAction(Object object) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (object.equals(this.m_refreshButton)) {
            this.refresh();
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (object.equals(this.m_detailButton)) {
            if (this.m_selection >= 0 && this.m_selection < this.certGroups.size()) {
                fi fi2 = (fi)this.certGroups.get(this.m_selection);
                this.setCursor(Cursor.getPredefinedCursor(0));
                String string = this.m_isNonRepudiation ? "NR" : "A";
                new jd(fi2, string, true, (Object)af.a());
            }
        } else if (object.equals(this.m_managementUtilityButton)) {
            CsiManager csiManager = new CsiManager();
            this.setCursor(Cursor.getPredefinedCursor(0));
            csiManager.show();
            this.refresh();
        } else if (object.equals(this.m_helpButton)) {
            HelpViewer helpViewer = HelpViewer.getInstance(this.a);
            this.setCursor(Cursor.getPredefinedCursor(0));
            helpViewer.showPage(SelectCertificateFrame.class.getResource("/au/gov/bafcsi/helppages/IdentitySelectionScreen.htm"));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void doSelect() {
        if (this.m_selection != -1) {
            this.c();
        }
    }

    private void doCancel() {
        this.m_selection = -1;
        this.c();
    }

    private void setButtonEnablement(boolean bl2) {
        if (bl2) {
            if (this.m_selection < 0 || this.m_selection >= this.m_certsInList) {
                this.m_detailButton.setEnabled(false);
                this.m_selectButton.setEnabled(false);
            } else {
                String string;
                fi fi2 = (fi)this.certGroups.get(this.m_selection);
                String string2 = string = this.m_isNonRepudiation ? "NR" : "A";
                if (fi2.b(string)) {
                    this.m_detailButton.setEnabled(true);
                    this.m_selectButton.setEnabled(true);
                } else {
                    this.m_detailButton.setEnabled(true);
                    this.m_selectButton.setEnabled(false);
                }
            }
        } else {
            this.m_detailButton.setEnabled(false);
            this.m_selectButton.setEnabled(false);
        }
        this.m_cancelButton.setEnabled(bl2);
        this.m_refreshButton.setEnabled(bl2);
        this.m_managementUtilityButton.setEnabled(bl2);
        this.m_helpButton.setEnabled(bl2);
    }

    private void refresh() {
        try {
            CertificateStore.getInstance().refreshStore();
            List list = iw.a().b();
            int n10 = this.m_isNonRepudiation ? 1 : 0;
            List list2 = iw.a().a(list, this.m_abnFilter);
            this.certGroups = iw.a().a(list2, n10);
        }
        catch (CertStoreException certStoreException) {
            r.a(w.f, "CertStoreException in CertSelectGui.", certStoreException);
            ae.b(null, "An unexpected error occurred while accessing certificate information.\n", "CSI - Error", 0);
            this.doCancel();
            return;
        }
        if (this.m_certsInList != this.certGroups.size()) {
            this.m_certsInList = this.certGroups.size();
            this.m_selection = -1;
            if (this.m_rowSM != null) {
                this.m_rowSM.clearSelection();
            }
            if (this.m_table != null) {
                this.m_tableModel.a(this.certGroups);
            }
        }
    }

    fi showDialog() {
        this.i = 500;
        this.j = 200;
        String string = "Please select a new " + (this.m_isNonRepudiation ? "non-repudiation" : "authentication") + " signing certificate.";
        this.m_messageLabel.setText(string);
        this.m_messageLabel.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.g();
        this.b();
        this.setVisible(true);
        if (this.m_selection == -1) {
            return null;
        }
        return (fi)this.certGroups.get(this.m_selection);
    }

    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.m_table.requestFocus();
    }

    static /* synthetic */ JButton access$000(CertSelectGui certSelectGui) {
        return certSelectGui.m_cancelButton;
    }

    static /* synthetic */ void access$100(CertSelectGui certSelectGui) {
        certSelectGui.doCancel();
    }

    static /* synthetic */ CertSelectTable access$200(CertSelectGui certSelectGui) {
        return certSelectGui.m_table;
    }

    static /* synthetic */ JButton access$300(CertSelectGui certSelectGui) {
        return certSelectGui.m_selectButton;
    }

    static /* synthetic */ void access$400(CertSelectGui certSelectGui) {
        certSelectGui.doSelect();
    }

    static /* synthetic */ void access$500(CertSelectGui certSelectGui, Object object) {
        certSelectGui.doButtonAction(object);
    }

    static /* synthetic */ int access$602(CertSelectGui certSelectGui, int n10) {
        certSelectGui.m_selection = n10;
        return certSelectGui.m_selection;
    }

    static /* synthetic */ e5 access$700(CertSelectGui certSelectGui) {
        return certSelectGui.m_tableSorter;
    }

    static /* synthetic */ void access$800(CertSelectGui certSelectGui, boolean bl2) {
        certSelectGui.setButtonEnablement(bl2);
    }

    static /* synthetic */ JButton access$900(CertSelectGui certSelectGui) {
        return certSelectGui.m_helpButton;
    }

    static /* synthetic */ JButton access$1000(CertSelectGui certSelectGui) {
        return certSelectGui.m_detailButton;
    }
}

