/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common;

import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.ez;
import au.gov.bafcsi.clapi.crypto.fi;
import au.gov.bafcsi.clapi.crypto.manager.fp;
import au.gov.bafcsi.common.CertSelectGui;
import au.gov.bafcsi.common.i8;
import au.gov.bafcsi.common.utils.CertDetailsGui;
import au.gov.bafcsi.common.utils.HelpViewer;
import au.gov.bafcsi.common.utils.af;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

final class SignGui
extends af
implements ActionListener {
    private JPanel m_termsConditionsPanel;
    private JPanel m_certPanel;
    private JPanel m_infoPanel;
    private JPanel m_controlPanel;
    private JLabel m_certInfoLabel;
    private JLabel m_commonNameLabel;
    private JLabel m_commonNameValue;
    private JLabel m_orgLabel;
    private JLabel m_orgValue;
    private JLabel m_abnLabel;
    private JLabel m_abnValue;
    private JLabel m_issuerLabel;
    private JLabel m_issuerNameValue;
    private JLabel m_validToLabel;
    private JLabel m_validToValue;
    private JButton m_signButton;
    private JButton m_cancelButton;
    private JButton m_changeButton;
    private JButton m_detailButton;
    private JButton m_helpButton;
    private CsiCertificate m_cert;
    private String m_termsConditions;
    private boolean m_doSign = false;
    private boolean m_isNonRepudiation;
    private String m_abnFilter;

    SignGui(CsiCertificate csiCertificate, String string, boolean bl2) {
        super("CSI signing confirmation");
        this.init(csiCertificate, string, bl2, null);
    }

    SignGui(CsiCertificate csiCertificate, String string, boolean bl2, String string2) {
        super("CSI signing confirmation");
        this.init(csiCertificate, string, bl2, string2);
    }

    private void init(CsiCertificate csiCertificate, String string, boolean bl2, String string2) {
        this.m_cert = csiCertificate;
        this.m_termsConditions = string;
        this.m_isNonRepudiation = bl2;
        this.m_abnFilter = string2;
        if (this.m_cert == null || CertificateStore.getInstance() == null || this.m_termsConditions == null) {
            throw new IllegalArgumentException("SignGui constructed with null data.");
        }
        if (string2 != null && !string2.equals(this.m_cert.getAbn())) {
            throw new IllegalArgumentException("SignGui certificate ABN is not consistent with the specified abnFilter");
        }
        fp fp2 = new fp(this.m_termsConditions);
        fp2.setRows(5);
        fp2.setColumns(25);
        JScrollPane jScrollPane = new JScrollPane(fp2);
        this.m_termsConditionsPanel = new JPanel();
        fp2.getAccessibleContext().setAccessibleParent(this.m_termsConditionsPanel);
        this.m_termsConditionsPanel.setLayout(new BorderLayout());
        this.m_termsConditionsPanel.add((Component)jScrollPane, "Center");
        this.constructCertPanel();
        this.updateCertInfo();
        this.m_infoPanel = new JPanel();
        this.m_infoPanel.setLayout(new BorderLayout());
        this.m_infoPanel.add((Component)this.m_termsConditionsPanel, "Center");
        this.m_infoPanel.add((Component)this.m_certPanel, "South");
        this.m_infoPanel.setBorder(new EmptyBorder(15, 10, 15, 10));
        this.constructControlPanel();
        this.m().setLayout(new BorderLayout());
        this.m().add((Component)this.m_infoPanel, "Center");
        this.m().add((Component)this.m_controlPanel, "South");
        this.a(new i8(this));
        this.g();
        this.m_signButton.requestFocusInWindow();
        this.j = this.getHeight();
        this.i = this.getWidth();
        this.b();
        this.setName("Signing_Terms_and_Conditions");
    }

    private void constructControlPanel() {
        this.m_signButton = new JButton("Sign");
        this.m_cancelButton = new JButton("Cancel");
        this.m_detailButton = new JButton("Details...");
        this.m_changeButton = new JButton("Certificate...");
        this.m_helpButton = new JButton("Help");
        this.m_signButton.setMnemonic(83);
        this.m_signButton.setToolTipText("Sign this transaction");
        this.m_signButton.addActionListener(this);
        this.m_cancelButton.setMnemonic(67);
        this.m_cancelButton.setToolTipText("Cancel without signing");
        this.m_cancelButton.addActionListener(this);
        this.m_detailButton.setMnemonic(68);
        this.m_detailButton.setToolTipText("Show certificate details");
        this.m_detailButton.addActionListener(this);
        this.m_changeButton.setMnemonic(69);
        this.m_changeButton.setToolTipText("Change signing certificate");
        this.m_changeButton.addActionListener(this);
        this.m_helpButton.setMnemonic(72);
        this.m_helpButton.setToolTipText("Show help information");
        this.m_helpButton.addActionListener(this);
        this.m_controlPanel = new JPanel();
        this.m_controlPanel.setLayout(new FlowLayout());
        this.m_controlPanel.add((Component)this.m_signButton, null);
        this.m_controlPanel.add((Component)this.m_cancelButton, null);
        this.m_controlPanel.add((Component)this.m_detailButton, null);
        this.m_controlPanel.add((Component)this.m_changeButton, null);
        this.m_controlPanel.add((Component)this.m_helpButton, null);
        this.m_signButton.setName("btnSign");
        this.m_cancelButton.setName("btnCancel");
        this.m_detailButton.setName("btnCertDetails");
        this.m_changeButton.setName("btnChangeCert");
        this.m_helpButton.setName("btnHelpForT&C");
    }

    private void constructCertPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.m_certPanel = new JPanel();
        this.m_certPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.m_certInfoLabel = new JLabel("This transaction will be signed using the following digital certificate:");
        this.m_certInfoLabel.setBorder(new EmptyBorder(15, 0, 0, 0));
        gridBagLayout.setConstraints(this.m_certInfoLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_certInfoLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        JLabel jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.m_certPanel.add(jLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        this.m_commonNameLabel = new JLabel("Subject:  ");
        this.m_commonNameLabel.setLabelFor(this.m_commonNameValue);
        gridBagLayout.setConstraints(this.m_commonNameLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_commonNameLabel);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 2;
        this.m_commonNameValue = new JLabel("");
        gridBagLayout.setConstraints(this.m_commonNameValue, gridBagConstraints2);
        this.m_certPanel.add(this.m_commonNameValue);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 3;
        this.m_orgLabel = new JLabel("Organisation:  ");
        this.m_orgLabel.setLabelFor(this.m_orgValue);
        gridBagLayout.setConstraints(this.m_orgLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_orgLabel);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 3;
        this.m_orgValue = new JLabel("");
        gridBagLayout.setConstraints(this.m_orgValue, gridBagConstraints2);
        this.m_certPanel.add(this.m_orgValue);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 4;
        this.m_abnLabel = new JLabel("A.B.N.:  ");
        this.m_abnLabel.getAccessibleContext().setAccessibleName("ABN");
        this.m_abnLabel.setLabelFor(this.m_abnValue);
        gridBagLayout.setConstraints(this.m_abnLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_abnLabel);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 4;
        this.m_abnValue = new JLabel("");
        gridBagLayout.setConstraints(this.m_abnValue, gridBagConstraints2);
        this.m_certPanel.add(this.m_abnValue);
        gridBagConstraints.gridy = 5;
        this.m_issuerLabel = new JLabel("Issuer:  ");
        this.m_issuerLabel.setLabelFor(this.m_issuerNameValue);
        gridBagLayout.setConstraints(this.m_issuerLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_issuerLabel);
        gridBagConstraints2.gridy = 5;
        this.m_issuerNameValue = new JLabel("");
        gridBagLayout.setConstraints(this.m_issuerNameValue, gridBagConstraints2);
        this.m_certPanel.add(this.m_issuerNameValue);
        gridBagConstraints.gridy = 6;
        this.m_validToLabel = new JLabel("Expires:");
        this.m_validToLabel.setLabelFor(this.m_validToLabel);
        gridBagLayout.setConstraints(this.m_validToLabel, gridBagConstraints);
        this.m_certPanel.add(this.m_validToLabel);
        gridBagConstraints2.gridy = 6;
        this.m_validToValue = new JLabel("");
        gridBagLayout.setConstraints(this.m_validToValue, gridBagConstraints2);
        this.m_certPanel.add(this.m_validToValue);
    }

    public CsiCertificate getSigningCertificate() {
        return this.m_cert;
    }

    public boolean doSign() {
        return this.m_doSign;
    }

    private void sign() {
        this.m_doSign = true;
        this.c();
    }

    private void cancel() {
        this.m_doSign = false;
        this.c();
    }

    private void updateAndRedraw() {
        this.updateCertInfo();
        this.j = 10;
        this.i = 10;
        this.setVisible(true);
    }

    private void updateCertInfo() {
        this.m_commonNameValue.setText(this.m_cert.getSubjectCommonName());
        this.m_orgValue.setText(this.m_cert.getSubjectOrganisation());
        this.m_abnValue.setText(this.m_cert.getAbn());
        this.m_issuerNameValue.setText(this.m_cert.getIssuerCommonName());
        Date date = this.m_cert.getNotAfter();
        this.m_validToValue.setText(ez.n.format(date));
        this.m_validToValue.getAccessibleContext().setAccessibleName(ez.m.format(date));
        if (this.m_cert.getCertificateDisplayInfo().af) {
            this.m_validToValue.setBorder(ez.o);
        }
    }

    private void updateButtonEnablement(boolean bl2) {
        this.m_signButton.setEnabled(bl2);
        this.m_cancelButton.setEnabled(bl2);
        this.m_changeButton.setEnabled(bl2);
        this.m_detailButton.setEnabled(bl2);
        this.m_helpButton.setEnabled(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_signButton)) {
            this.sign();
        } else if (object.equals(this.m_cancelButton)) {
            this.cancel();
        } else if (object.equals(this.m_detailButton)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            CertDetailsGui certDetailsGui = new CertDetailsGui(af.a((Component)this), this.m_cert, true);
            this.setCursor(Cursor.getPredefinedCursor(0));
            certDetailsGui.setVisible(true);
        } else if (object.equals(this.m_changeButton)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            CertSelectGui certSelectGui = new CertSelectGui(this.m_isNonRepudiation, this.m_abnFilter);
            this.setCursor(Cursor.getPredefinedCursor(0));
            fi fi2 = certSelectGui.showDialog();
            if (fi2 != null) {
                this.m_cert = this.m_isNonRepudiation ? fi2.f() : fi2.e();
                this.m_cert = this.m_isNonRepudiation ? fi2.f() : fi2.e();
                this.updateAndRedraw();
            }
            this.m_signButton.requestFocus();
        } else if (object.equals(this.m_helpButton)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            HelpViewer helpViewer = HelpViewer.getInstance(this.a);
            this.setCursor(Cursor.getPredefinedCursor(0));
            helpViewer.showPage(SignGui.class.getResource("/au/gov/bafcsi/helppages/TermsConditionsConfirmation.htm"));
        }
    }

    static /* synthetic */ void access$000(SignGui signGui) {
        signGui.cancel();
    }
}

