/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.hapi;

import au.gov.bafcsi.clapi.asn1.bl;
import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.prng.CsiSecureRandom;
import au.gov.bafcsi.clapi.packaging.NonRepudiationSign;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.SignedOutputStream;
import au.gov.bafcsi.clapi.packaging.c9;
import au.gov.bafcsi.clapi.packaging.dd;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.CertificateSelector;
import au.gov.bafcsi.common.MimeType;
import au.gov.bafcsi.common.UserCancelledIOException;
import au.gov.bafcsi.common.UserPreferences;
import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.fq;
import au.gov.bafcsi.common.utils.jc;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import au.gov.bafcsi.hapi.CancelledOperationException;
import au.gov.bafcsi.hapi.CertificateValidator;
import au.gov.bafcsi.hapi.CsiCertificateException;
import au.gov.bafcsi.hapi.CsiGeneralException;
import au.gov.bafcsi.hapi.ErrorCode;
import au.gov.bafcsi.hapi.InvalidPackageException;
import au.gov.bafcsi.hapi.MessageInfo;
import au.gov.bafcsi.hapi.PackageFormat;
import au.gov.bafcsi.hapi.SignedMessageInputStream;
import au.gov.bafcsi.hapi.ka;
import au.gov.bafcsi.hapi.kb;
import au.gov.bafcsi.hapi.kf;
import au.gov.bafcsi.hapi.kg;
import au.gov.bafcsi.hapi.kh;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;

public class CsiEngine {
    private static final int MAX_NONSTREAM_CREATE_SIZE = 1000000;
    private static final int MAX_NONSTREAM_PROCESS_SIZE = 2000000;
    private CertificateValidator m_certificateValidator;
    private PackageFormat m_packageFormat;
    private boolean m_showUpdateDialog;
    private CertificateSelector m_certificateSelector;
    private String m_abnCertificateSelectionFilter;
    private final boolean m_serverMode = s.a().an();
    private jc m_cancelListener;

    CsiEngine(CertificateValidator certificateValidator, PackageFormat packageFormat) {
        if (certificateValidator == null) {
            String string = "Null certificateValidator in Csi constructor.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        if (packageFormat == null) {
            String string = "Null packageFormat in Csi constructor.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        this.m_packageFormat = packageFormat;
        this.m_certificateValidator = certificateValidator;
        if (this.m_serverMode) {
            this.m_showUpdateDialog = false;
        } else {
            this.m_showUpdateDialog = true;
            this.m_certificateSelector = new CertificateSelector();
        }
        CertificateStore.getInstance().secureStore();
    }

    public final void setShowUpdateStatus(boolean bl2) {
        this.m_showUpdateDialog = this.m_serverMode ? false : bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCancelListener(jc jc2) {
        CsiEngine csiEngine = this;
        synchronized (csiEngine) {
            this.m_cancelListener = jc2;
        }
    }

    public final boolean isShowUpdateStatus() {
        return this.m_showUpdateDialog;
    }

    public final void setAbnCertificateSelectionFilter(String string) {
        if (this.m_serverMode) {
            String string2 = "The CSI is running in server mode, which  does not support ABN certificate selection filtering.";
            r.a(w.h, string2);
            throw new IllegalStateException(string2);
        }
        this.m_abnCertificateSelectionFilter = string;
    }

    public final String getAbnCertificateSelectionFilter() {
        return this.m_abnCertificateSelectionFilter;
    }

    public final byte[] signForAuthentication(byte[] byArray, String string) throws CancelledOperationException, CsiGeneralException {
        if (byArray == null || byArray.length == 0) {
            String string2 = "Null or zero-length plainText in Csi.signForAuthentication.";
            r.a(w.f, string2);
            throw new IllegalArgumentException(string2);
        }
        this.checkDataSize(byArray.length, 1000000, "sign");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.setCancelListener(new jc());
        OutputStream outputStream = this.createSignForAuthenticationStream(byteArrayOutputStream, string);
        return this.pipeBytes(outputStream, byteArrayOutputStream, byArray);
    }

    public final byte[] signForNonRepudiation(byte[] byArray, MimeType mimeType, String string) throws CancelledOperationException, CsiGeneralException {
        ByteArray byteArray;
        if (byArray == null || byArray.length == 0) {
            String string2 = "Null or zero-length plainText in Csi.signForNonRepudiation.";
            r.a(w.f, string2);
            throw new IllegalArgumentException(string2);
        }
        if (mimeType == null) {
            String string3 = "Null MIME type in Csi.signForNonRepudiation.";
            r.a(w.f, string3);
            throw new IllegalArgumentException(string3);
        }
        if (this.m_serverMode) {
            String string4 = "Cannot sign for non-repudiation when running in server mode.";
            r.a(w.f, string4);
            throw new UnsupportedOperationException(string4);
        }
        this.checkDataSize(byArray.length, 1000000, "sign");
        if (!mimeType.equals(MimeType.PLAIN_TEXT)) {
            String string5 = "Unsupported MIME type (" + mimeType.toString() + ") for non-repudiation signing.";
            r.a(w.f, string5);
            throw new IllegalArgumentException(string5);
        }
        try {
            CsiCertificate csiCertificate = this.m_certificateSelector.getSigningCertificate(true, string, this.m_abnCertificateSelectionFilter);
            if (csiCertificate == null) {
                throw new CancelledOperationException(ErrorCode.USER_CANCELS_IN_HAPI, "The user does not want to sign, or no signing certificates are available.");
            }
            byteArray = NonRepudiationSign.sign(csiCertificate, byArray, this.m_packageFormat, mimeType);
            this.m_certificateSelector.flagSigningOperationAsSuccessful();
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Sign for non-repudiation operation cancelled.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Sign for non-repudiation operation failed.", iOException);
        }
        return byteArray.getBytes();
    }

    private void checkDataSize(int n10, int n11, String string) throws CancelledOperationException {
        if (this.m_serverMode) {
            return;
        }
        if (n10 > n11 || n10 < 0) {
            String string2 = "The CSI was requested to " + string + " data " + "in excess of the recommended maximum size " + "(size = " + n10 + ", limit = " + n11 + " bytes).  ";
            int n12 = ae.a("The CSI has been requested to " + string + " data in excess" + p.d + "of the recommended maximum size.  This may cause" + p.d + "memory problems with your computer." + p.d + "Do you wish to continue?", "Warning", 0, 2);
            if (n12 == 1) {
                string2 = string2 + "User decided to cancel operation.";
                throw new CancelledOperationException(ErrorCode.USER_CANCELS_IN_HAPI, string2);
            }
            string2 = string2 + "User decided to continue.";
            r.a(w.i, string2);
        }
    }

    public final MessageInfo verifySignedMessage(byte[] byArray) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        if (byArray == null) {
            String string = "Null signedPackage in Csi.verifySignedMessage.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        this.checkDataSize(byArray.length, 2000000, "verify");
        this.setCancelListener(new jc());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedMessageInputStream signedMessageInputStream = this.createVerifySignedMessageStream(byteArrayInputStream);
        byte[] byArray2 = this.readInputStream(signedMessageInputStream);
        return new MessageInfo(byArray2, signedMessageInputStream.getSigningCertificate(), signedMessageInputStream.getSignatureValidationResults(), signedMessageInputStream.isNonRepudiationSigned(), signedMessageInputStream.getSigningTime());
    }

    public final byte[] encryptMessage(byte[] byArray, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        if (byArray == null || byArray.length == 0) {
            String string = "Null or zero-length plainText in Csi.encryptMessage.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        this.checkDataSize(byArray.length, 1000000, "encrypt");
        return this.encryptMessageCore(byArray, collection);
    }

    private byte[] encryptMessageCore(byte[] byArray, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.setCancelListener(new jc());
        OutputStream outputStream = this.createEncryptMessageStream(byteArrayOutputStream, collection);
        return this.pipeBytes(outputStream, byteArrayOutputStream, byArray);
    }

    private CertificateCollection checkedEncryptionCertificates(Collection collection) throws CsiCertificateException {
        if (collection == null || collection.isEmpty()) {
            String string = "Encryption certificates passed to the Csi must contain at least one certificate.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        CertificateCollection certificateCollection = new CertificateCollection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e10 = iterator.next();
            if (!(e10 instanceof X509Certificate)) {
                object = "At least one of the supplied encryption certificates is not an instance of X509Certificate.";
                r.a(w.f, (String)object);
                throw new IllegalArgumentException((String)object);
            }
            object = new CsiCertificate((X509Certificate)e10);
            if (!((CsiCertificate)object).canDoEncryption()) {
                throw new CsiCertificateException(ErrorCode.ENCRYPTION_CERT_NOT_APPROPRIATE, w.f, "Invalid key usage for encryption certificate (subject name = " + ((CsiCertificate)object).getSubjectCommonName() + ", issuer name = " + ((CsiCertificate)object).getIssuerCommonName() + ").");
            }
            boolean bl2 = this.m_certificateValidator.coreIsCertificateValid((X509Certificate)object);
            if (bl2) {
                certificateCollection.addCertificate((CsiCertificate)object);
                continue;
            }
            throw new CsiCertificateException(ErrorCode.ENCRYPTION_CERT_NOT_VALID, w.h, "Encryption certificate is not valid (subject name = " + ((CsiCertificate)object).getSubjectCommonName() + ", issuer name = " + ((CsiCertificate)object).getIssuerCommonName() + ").");
        }
        return certificateCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] pipeBytes(OutputStream outputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) throws CancelledOperationException, CsiGeneralException {
        byte[] byArray2 = new byte[16384];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            int n10;
            while ((n10 = byteArrayInputStream.read(byArray2)) != -1) {
                outputStream.write(byArray2, 0, n10);
                if (this.m_cancelListener == null || !this.m_cancelListener.a()) continue;
                byteArrayInputStream.close();
                CsiEngine csiEngine = this;
                synchronized (csiEngine) {
                    this.m_cancelListener.b();
                }
                throw new CancelledOperationException(ErrorCode.USER_CANCELS_DURING_OPERATION, "Operation cancelled during operation.");
            }
            outputStream.close();
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Operation cancelled.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Operation failed.", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readInputStream(InputStream inputStream) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        byte[] byArray = new byte[16384];
        ByteArray byteArray = new ByteArray(2000000);
        try {
            int n10;
            while ((n10 = inputStream.read(byArray)) != -1) {
                byteArray.append(byArray, 0, n10);
                if (this.m_cancelListener == null || !this.m_cancelListener.a()) continue;
                inputStream.close();
                CsiEngine csiEngine = this;
                synchronized (csiEngine) {
                    this.m_cancelListener.b();
                }
                throw new CancelledOperationException(ErrorCode.USER_CANCELS_DURING_OPERATION, "Operation cancelled while reading input stream.");
            }
            inputStream.close();
        }
        catch (BadMessageFormatException badMessageFormatException) {
            throw new InvalidPackageException(ErrorCode.CLAPI_BAD_MESSAGE_FORMAT_EXCEPTION, w.h, "Failed while reading input stream.", badMessageFormatException);
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Failed while reading input stream.", iOException);
        }
        catch (bl bl2) {
            throw new CsiGeneralException(ErrorCode.CLAPI_BAD_MESSAGE_FORMAT_EXCEPTION, w.h, "Failed while reading input stream.", bl2);
        }
        return byteArray.getDefensiveBytes();
    }

    public final byte[] decryptMessage(byte[] byArray) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        if (byArray == null) {
            String string = "Null cipherTextPackage in Csi.decryptMessage.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        this.checkDataSize(byArray.length, 2000000, "decrypt");
        this.setCancelListener(new jc());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = this.createDecryptMessageStream(byteArrayInputStream);
        return this.readInputStream(inputStream);
    }

    public final byte[] signForAuthenticationAndEncrypt(byte[] byArray, String string, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        if (byArray == null || byArray.length == 0) {
            String string2 = "Null or zero-length plainText in Csi.signForAuthenticationAndEncrypt.";
            r.a(w.f, string2);
            throw new IllegalArgumentException(string2);
        }
        this.checkDataSize(byArray.length, 1000000, "sign and encrypt");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.setCancelListener(new jc());
        OutputStream outputStream = this.createSignForAuthenticationAndEncryptStream(byteArrayOutputStream, string, collection);
        return this.pipeBytes(outputStream, byteArrayOutputStream, byArray);
    }

    public final byte[] signForNonRepudiationAndEncrypt(byte[] byArray, MimeType mimeType, String string, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        byte[] byArray2 = this.signForNonRepudiation(byArray, mimeType, string);
        byte[] byArray3 = this.encryptMessageCore(byArray2, collection);
        return byArray3;
    }

    public final MessageInfo decryptAndVerifySignedMessage(byte[] byArray) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        if (byArray == null) {
            String string = "Null signedEncryptedPackage in Csi.decryptAndVerifySignedMessage.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        this.checkDataSize(byArray.length, 2000000, "decrypt and verify");
        this.setCancelListener(new jc());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedMessageInputStream signedMessageInputStream = this.createDecryptAndVerifySignedMessageStream(byteArrayInputStream);
        byte[] byArray2 = this.readInputStream(signedMessageInputStream);
        return new MessageInfo(byArray2, signedMessageInputStream.getSigningCertificate(), signedMessageInputStream.getSignatureValidationResults(), signedMessageInputStream.isNonRepudiationSigned(), signedMessageInputStream.getSigningTime());
    }

    public final OutputStream createSignForAuthenticationStream(OutputStream outputStream, String string) throws CancelledOperationException, CsiGeneralException {
        kf kf2;
        if (outputStream == null) {
            String string2 = "Null destination in Csi.createSignForAuthenticationStream.";
            r.a(w.f, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = "Null signingTermsConditions in Csi.createSignForAuthenticationStream.";
            r.a(w.f, string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            CsiCertificate csiCertificate;
            if (this.m_serverMode) {
                csiCertificate = UserPreferences.getPreferredAuthenticationCertificate();
                if (csiCertificate == null) {
                    String string4 = "The default signing certificate has not been configured for server-side use.  Run the Management Utility and select the default certificate.";
                    r.a(w.h, string4);
                    throw new IllegalStateException(string4);
                }
            } else {
                csiCertificate = this.m_certificateSelector.getSigningCertificate(false, string, this.m_abnCertificateSelectionFilter);
                if (csiCertificate == null) {
                    throw new CancelledOperationException(ErrorCode.USER_CANCELS_IN_HAPI, "The user does not want to sign, or no signing certificates are available.");
                }
            }
            ka ka2 = new ka(csiCertificate);
            ka2.b = false;
            SignedOutputStream signedOutputStream = this.m_packageFormat.getSignedOutputStream(outputStream, ka2);
            if (this.m_showUpdateDialog && this.m_cancelListener != null) {
                kb kb2 = new kb("CSI - Signing in progress", "Please wait while this message is signed.", this.m_cancelListener);
                kb2.a(signedOutputStream);
                kf2 = new kf(signedOutputStream, this.m_certificateSelector, kb2);
            } else {
                kf2 = new kf(signedOutputStream, this.m_certificateSelector);
            }
        }
        catch (CertStoreException certStoreException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_CERT_STORE_EXCEPTION, w.h, "Sign for authentication operation failed.", certStoreException);
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Sign for authentication operation cancelled.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Sign for authentication operation failed.", iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Sign for authentication operation failed.", runtimeException);
        }
        return kf2;
    }

    public final SignedMessageInputStream createVerifySignedMessageStream(InputStream inputStream) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        SignedMessageInputStream signedMessageInputStream;
        SignedInputStream signedInputStream;
        if (inputStream == null) {
            String string = "Null signedPackage in Csi.createVerifySignedMessageStream.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        try {
            signedInputStream = this.m_packageFormat.getSignedInputStream(inputStream);
        }
        catch (BadMessageFormatException badMessageFormatException) {
            throw new InvalidPackageException(ErrorCode.CLAPI_BAD_MESSAGE_FORMAT_EXCEPTION, w.f, "Verify operation failed.", badMessageFormatException);
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Verify operation failed.", iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Verify operation failed.", runtimeException);
        }
        if (this.m_showUpdateDialog && this.m_cancelListener != null) {
            kb kb2 = new kb("CSI - Verifying in progress", "Please wait while this message is verified.", this.m_cancelListener);
            kg kg2 = new kg(signedInputStream, kb2);
            signedMessageInputStream = new SignedMessageInputStream(kg2, signedInputStream, this.m_certificateValidator);
            kb2.a(signedMessageInputStream);
        } else {
            kg kg3 = new kg(signedInputStream);
            signedMessageInputStream = new SignedMessageInputStream(kg3, signedInputStream, this.m_certificateValidator);
        }
        return signedMessageInputStream;
    }

    public final OutputStream createEncryptMessageStream(OutputStream outputStream, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        kf kf2;
        dd dd2;
        Object object;
        if (outputStream == null) {
            String string = "Null destination in Csi.createEncryptMessageStream.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        if (collection == null || collection.isEmpty()) {
            String string = "Null or empty encryptionCertificates in Csi.createEncryptMessageStream.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        CertificateCollection certificateCollection = this.checkedEncryptionCertificates(collection);
        try {
            object = new kh(certificateCollection);
            dd2 = this.m_packageFormat.getEnvelopedOutputStream(outputStream, (kh)object);
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Encryption operation failed.", iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Encryption operation failed.", runtimeException);
        }
        if (this.m_showUpdateDialog && this.m_cancelListener != null) {
            object = new kb("CSI - Encrypt in progress", "Please wait while this message is encrypted.", this.m_cancelListener);
            ((kb)object).a(dd2);
            kf2 = new kf(dd2, this.m_certificateSelector, (kb)object);
        } else {
            kf2 = new kf(dd2, this.m_certificateSelector);
        }
        return kf2;
    }

    public final InputStream createDecryptMessageStream(InputStream inputStream) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        InputStream inputStream2;
        c9 c92;
        Object object;
        if (inputStream == null) {
            String string = "Null cipherText in Csi.createDecryptMessageStream.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        try {
            object = CertificateStore.getInstance();
            CertificateCollection certificateCollection = ((CertificateStore)object).getAllConfidentialityCertificates();
            if (certificateCollection.isEmpty()) {
                throw new CsiGeneralException(ErrorCode.USER_HAS_NO_DECRYPTION_KEYS, w.h, "No suitable keys for message decryption.");
            }
            c92 = this.m_packageFormat.getEnvelopedInputStream(inputStream, certificateCollection);
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Decryption operation failed.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (BadMessageFormatException badMessageFormatException) {
            throw new InvalidPackageException(ErrorCode.CLAPI_BAD_MESSAGE_FORMAT_EXCEPTION, w.f, "Decryption operation failed.", badMessageFormatException);
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Decryption operation failed.", iOException);
        }
        catch (CertStoreException certStoreException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_CERT_STORE_EXCEPTION, w.h, "Decryption operation failed.", certStoreException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Decryption operation failed.", runtimeException);
        }
        if (this.m_showUpdateDialog && this.m_cancelListener != null) {
            object = new kb("CSI - Decrypting in progress", "Please wait while this message is decrypted.", this.m_cancelListener);
            ((kb)object).a(c92);
            inputStream2 = new kg(c92, (kb)object);
        } else {
            inputStream2 = c92;
        }
        return inputStream2;
    }

    public final OutputStream createSignForAuthenticationAndEncryptStream(OutputStream outputStream, String string, Collection collection) throws CancelledOperationException, CsiCertificateException, CsiGeneralException {
        kf kf2;
        if (outputStream == null) {
            String string2 = "Null destination in Csi.createSignForAuthenticationAndEncryptStream.";
            r.a(w.f, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = "Null signingTermsConditions in Csi.createSignForAuthenticationAndEncryptStream.";
            r.a(w.f, string3);
            throw new IllegalArgumentException(string3);
        }
        if (collection == null || collection.isEmpty()) {
            String string4 = "Null or zero-length encryptionCertificates in Csi.createSignForAuthenticationAndEncryptStream.";
            r.a(w.f, string4);
            throw new IllegalArgumentException(string4);
        }
        CertificateCollection certificateCollection = this.checkedEncryptionCertificates(collection);
        try {
            CsiCertificate csiCertificate;
            kh kh2 = new kh(certificateCollection);
            dd dd2 = this.m_packageFormat.getEnvelopedOutputStream(outputStream, kh2);
            if (this.m_serverMode) {
                csiCertificate = UserPreferences.getPreferredAuthenticationCertificate();
                if (csiCertificate == null) {
                    String string5 = "The default signing certificate has not been configured for server-side use.  Run the Management Utility and select the default certificate.";
                    r.a(w.h, string5);
                    throw new IllegalStateException(string5);
                }
            } else {
                csiCertificate = this.m_certificateSelector.getSigningCertificate(false, string, this.m_abnCertificateSelectionFilter);
                if (csiCertificate == null) {
                    throw new CancelledOperationException(ErrorCode.USER_CANCELS_IN_HAPI, "The user does not want to sign, or no signing certificates are available.");
                }
            }
            ka ka2 = new ka(csiCertificate);
            ka2.b = false;
            SignedOutputStream signedOutputStream = this.m_packageFormat.getSignedOutputStream(dd2, ka2);
            if (this.m_showUpdateDialog && this.m_cancelListener != null) {
                kb kb2 = new kb("CSI - Signing and encrypting in progress", "Please wait while this message is signed and encrypted.", this.m_cancelListener);
                kf2 = new kf(signedOutputStream, this.m_certificateSelector, kb2);
                kb2.a(signedOutputStream, dd2);
            } else {
                kf2 = new kf(signedOutputStream, this.m_certificateSelector);
            }
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Sign for authentication and encrypt operation cancelled.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Sign for authentication and encrypt operation failed.", iOException);
        }
        catch (CertStoreException certStoreException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_CERT_STORE_EXCEPTION, w.h, "Sign for authentication and encrypt operation failed.", certStoreException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Sign for authentication and encrypt operation failed.", runtimeException);
        }
        return kf2;
    }

    public final SignedMessageInputStream createDecryptAndVerifySignedMessageStream(InputStream inputStream) throws CancelledOperationException, InvalidPackageException, CsiGeneralException {
        SignedMessageInputStream signedMessageInputStream;
        SignedInputStream signedInputStream;
        c9 c92;
        Object object;
        if (inputStream == null) {
            String string = "Null cipherText in Csi.createDecryptAndVerifySignedMessageStream.";
            r.a(w.f, string);
            throw new IllegalArgumentException(string);
        }
        try {
            object = CertificateStore.getInstance();
            CertificateCollection certificateCollection = ((CertificateStore)object).getAllConfidentialityCertificates();
            if (certificateCollection.isEmpty()) {
                throw new CsiGeneralException(ErrorCode.USER_HAS_NO_DECRYPTION_KEYS, w.h, "No suitable keys for message decryption.");
            }
            c92 = this.m_packageFormat.getEnvelopedInputStream(inputStream, certificateCollection);
            signedInputStream = this.m_packageFormat.getSignedInputStream(c92);
        }
        catch (UserCancelledIOException userCancelledIOException) {
            throw new CancelledOperationException(ErrorCode.CLAPI_USER_CANCELLED_IO_EXCEPTION, "Decryption operation cancelled.", userCancelledIOException, userCancelledIOException.getInvalidPasswordAttempts());
        }
        catch (BadMessageFormatException badMessageFormatException) {
            throw new InvalidPackageException(ErrorCode.CLAPI_BAD_MESSAGE_FORMAT_EXCEPTION, w.f, "Decryption operation failed.", badMessageFormatException);
        }
        catch (IOException iOException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_IO_EXCEPTION, w.h, "Decryption operation failed.", iOException);
        }
        catch (CertStoreException certStoreException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_CERT_STORE_EXCEPTION, w.h, "Decryption operation failed.", certStoreException);
        }
        catch (RuntimeException runtimeException) {
            throw new CsiGeneralException(ErrorCode.CLAPI_RUNTIME_EXCEPTION, w.f, "Decryption operation failed.", runtimeException);
        }
        if (this.m_showUpdateDialog && this.m_cancelListener != null) {
            object = new kb("CSI - Decrypting and verifying in progress", "Please wait while this message is decrypted and verified.", this.m_cancelListener);
            kg kg2 = new kg(signedInputStream, (kb)object);
            signedMessageInputStream = new SignedMessageInputStream(kg2, signedInputStream, this.m_certificateValidator);
            ((kb)object).a(signedMessageInputStream, c92);
        } else {
            kg kg3 = new kg(signedInputStream);
            signedMessageInputStream = new SignedMessageInputStream(kg3, signedInputStream, this.m_certificateValidator);
        }
        return signedMessageInputStream;
    }

    static {
        fq.a();
        new CsiSecureRandom();
    }
}

