/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.hapi;

import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.cms.SignedCmsInputStream;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.clapi.packaging.smime.SignedSMimeInputStream;
import au.gov.bafcsi.clapi.packaging.xml.SignedXMLInputStream;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignatureException;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import au.gov.bafcsi.hapi.CertificateValidator;
import au.gov.bafcsi.hapi.MessageInfo;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Date;

public final class SignedMessageInputStream
extends FilterInputStream
implements da {
    private MessageInfo m_messageInfo;
    private SignedInputStream m_underLyingVerifyStream;
    private CertificateValidator m_certValidator;
    private boolean m_isCancelled = false;

    SignedMessageInputStream(InputStream inputStream, SignedInputStream signedInputStream, CertificateValidator certificateValidator) {
        super(inputStream);
        this.m_underLyingVerifyStream = signedInputStream;
        this.m_certValidator = certificateValidator;
    }

    SignedMessageInputStream(SignedInputStream signedInputStream, CertificateValidator certificateValidator) {
        super(signedInputStream);
        this.m_underLyingVerifyStream = signedInputStream;
        this.m_certValidator = certificateValidator;
    }

    public String getAbn() throws IllegalStateException {
        if (this.m_messageInfo == null) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.getAbn();
    }

    public CsiCertificate getSigningCertificate() throws IllegalStateException {
        if (this.m_messageInfo == null) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.getCertificate();
    }

    public boolean isNonRepudiationSigned() throws IllegalStateException {
        if (this.m_messageInfo == null) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.isNonRepudiationSigned();
    }

    public boolean isSignatureValid() throws IllegalStateException {
        if (this.m_messageInfo == null) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.isSignatureValid();
    }

    public int getSignatureValidationResults() throws IllegalStateException {
        if (this.m_messageInfo == null || this.m_messageInfo.getSignatureValidationResults() == -1) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.getSignatureValidationResults();
    }

    public Date getSigningTime() throws IllegalStateException {
        if (this.m_messageInfo == null) {
            throw new IllegalStateException("This method cannot be called unless the stream has been fully read and closed.  Do not call this method if the stream is still open or has been cancelled by the user.");
        }
        return this.m_messageInfo.getSigningTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object;
        CertificateCollection certificateCollection = null;
        CsiCertificate csiCertificate = null;
        Date date = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n10 = -1;
        if (this.m_isCancelled) {
            super.close();
            return;
        }
        try {
            certificateCollection = this.m_underLyingVerifyStream.getCertificates();
            if (certificateCollection == null) {
                csiCertificate = null;
                bl3 = false;
            } else {
                csiCertificate = this.m_underLyingVerifyStream.verify(certificateCollection);
                bl3 = this.m_underLyingVerifyStream.isNonRepudiationSigned(csiCertificate);
            }
        }
        catch (PackagingException packagingException) {
            bl3 = false;
            String string = "An error occured while attempting to verifiy a signature from a verifying stream. The error will be ignored and the signature will be assumed to be invalid and signed for authentication.";
            r.a(w.i, string, packagingException);
        }
        finally {
            super.close();
        }
        if (csiCertificate == null) {
            n10 = 2;
        } else {
            if (certificateCollection != null) {
                object = certificateCollection.getCertificateChain(csiCertificate);
                bl2 = this.m_certValidator.coreIsCertificateValid(((CertificateCollection)object).getOrderedCertificateChain());
            } else {
                bl2 = false;
            }
            n10 = bl2 ? 0 : 1;
        }
        if (csiCertificate != null) {
            if (SignedCmsInputStream.class.isAssignableFrom(this.m_underLyingVerifyStream.getClass())) {
                try {
                    object = (SignedCmsInputStream)this.m_underLyingVerifyStream;
                    date = ((SignedCmsInputStream)object).getSignerInfo(csiCertificate).getSigningTime();
                }
                catch (CertificateException certificateException) {
                    r.a(w.g, "CertificateException in SignedMessageInputStream when getting SignerInfo from SignedCmsInputStream.");
                    date = null;
                }
            } else if (SignedSMimeInputStream.class.isAssignableFrom(this.m_underLyingVerifyStream.getClass())) {
                try {
                    object = (SignedSMimeInputStream)this.m_underLyingVerifyStream;
                    date = ((SignedSMimeInputStream)object).getSignerInfo(csiCertificate).getSigningTime();
                }
                catch (CertificateException certificateException) {
                    r.a(w.g, "CertificateException in SignedMessageInputStream when getting SignerInfo from SignedSMimeInputStream.");
                    date = null;
                }
            } else if (SignedXMLInputStream.class.isAssignableFrom(this.m_underLyingVerifyStream.getClass())) {
                try {
                    object = (SignedXMLInputStream)this.m_underLyingVerifyStream;
                    date = ((SignedXMLInputStream)object).getSigningTime();
                }
                catch (XMLSignatureException xMLSignatureException) {
                    r.a(w.g, "CertificateException in SignedMessageInputStream when getting SignerInfo from SignedSMimeInputStream.");
                    date = null;
                }
            }
        }
        this.m_messageInfo = new MessageInfo(null, csiCertificate, n10, bl3, date);
    }

    public void setCancelled() {
        this.m_isCancelled = true;
    }
}

