/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.chunk.CertificateStatus;
import au.gov.bafcsi.chunk.Chunk;
import au.gov.bafcsi.chunk.EncryptionConfig;
import au.gov.bafcsi.chunk.EncryptionStatus;
import au.gov.bafcsi.chunk.UserId;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.cms.full.EnvelopingParameters;
import au.gov.bafcsi.clapi.packaging.smime.EnvelopedSMimeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;

public final class SmimeEnveloper {
    private ByteArrayOutputStream baos;
    private EnvelopedSMimeOutputStream smime;

    public EncryptionStatus start(EncryptionConfig encryptionConfig) throws Exception {
        if (encryptionConfig == null) {
            throw new IllegalArgumentException("SmimeEnveloper.start(EncryptionConfig): EncryptionConfig is null.");
        }
        UserId[] userIdArray = encryptionConfig.getRecipients();
        if (userIdArray == null) {
            throw new IllegalArgumentException("SmimeEnveloper.start(EncryptionConfig): EncryptionConfig contains null recipients.");
        }
        if (userIdArray.length == 0) {
            throw new IllegalArgumentException("SmimeEnveloper.start(EncryptionConfig): EncryptionConfig contains no recipients.");
        }
        CertificateStatus[] certificateStatusArray = new CertificateStatus[userIdArray.length];
        CertificateCollection certificateCollection = new CertificateCollection();
        for (int i10 = 0; i10 < userIdArray.length; ++i10) {
            X509Certificate x509Certificate;
            UserId userId = userIdArray[i10];
            if (userId == null || !new KeyUsage((x509Certificate = userId.getCertificate()).getKeyUsage()).hasUsage(2)) continue;
            certificateStatusArray[i10] = new CertificateStatus(x509Certificate);
            boolean bl2 = certificateStatusArray[i10].getValidityCheck().isCheckPerformed();
            boolean bl3 = certificateStatusArray[i10].getValidityCheck().isCheckPassed();
            if (!bl2 || !bl3) continue;
            certificateCollection.addCertificate(new CsiCertificate(x509Certificate));
        }
        if (certificateCollection.size() == 0) {
            throw new IllegalArgumentException("SmimeEnveloper.start(EncryptionConfig): EncryptionConfig contains no valid recipients.");
        }
        EnvelopingParameters envelopingParameters = new EnvelopingParameters(certificateCollection);
        envelopingParameters.setCipherOID(encryptionConfig.getEncryptionAlgorithm().getAlgorithmOid());
        this.baos = new ByteArrayOutputStream(10240);
        this.smime = new EnvelopedSMimeOutputStream(this.baos, envelopingParameters);
        return new EncryptionStatus(certificateStatusArray);
    }

    public Chunk update(Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("SmimeEnveloper.update(Chunk): The supplied Chunk is null.");
        }
        byte[] byArray = chunk.getData();
        if (byArray != null && byArray.length > 0) {
            this.smime.write(byArray);
        }
        byte[] byArray2 = this.baos.toByteArray();
        this.baos.reset();
        return new Chunk(chunk.getId(), byArray2);
    }

    public Chunk finish() throws IOException {
        this.smime.close();
        return new Chunk(-1L, this.baos.toByteArray());
    }
}

