/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.crypto.DsaParameters;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class CsiDsaParameters
extends AlgorithmParametersSpi {
    private DSAParameterSpec dsaParams;
    private DsaParameters tree = new DsaParameters();

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("CsiDsaParameters.engineInit(AlgorithmParameterSpec) - " + algorithmParameterSpec.getClass().getName() + " not supported, expected DSAParameterSpec.");
        }
        this.dsaParams = (DSAParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.tree.a(new ByteArray(byArray, false));
            this.dsaParams = new DSAParameterSpec(this.tree.getP(), this.tree.getQ(), this.tree.getG());
        }
        catch (CoderException coderException) {
            throw new IOException("CsiDsaParameters.engineInit(byte[]) - " + coderException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(DSAParameterSpec.class)) {
            throw new InvalidParameterSpecException("CsiDsaParameters.engineGetParameterSpec(Class) - " + clazz.getName() + " not supported, expected DSAParameterSpec.");
        }
        return this.dsaParams;
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.tree.g().getBytes();
        }
        catch (CoderException coderException) {
            throw new IOException("CsiDsaParameters.engineGetEncoded() - " + coderException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "DSA Parameters";
    }
}

